/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.tuple;

import org.apache.datasketches.hive.tuple.ArrayOfDoublesState;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketchBuilder;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

class ArrayOfDoublesSketchState
extends ArrayOfDoublesState {
    private ArrayOfDoublesUpdatableSketch sketch_;

    ArrayOfDoublesSketchState() {
    }

    boolean isInitialized() {
        return this.sketch_ != null;
    }

    void init(int nominalNumEntries, float samplingProbability, int numValues) {
        super.init(nominalNumEntries, numValues);
        this.sketch_ = new ArrayOfDoublesUpdatableSketchBuilder().setNominalEntries(nominalNumEntries).setSamplingProbability(samplingProbability).setNumberOfValues(numValues).build();
    }

    void update(Object[] data, PrimitiveObjectInspector keyInspector, PrimitiveObjectInspector[] valuesInspectors) {
        double[] values = new double[valuesInspectors.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = PrimitiveObjectInspectorUtils.getDouble((Object)data[i + 1], (PrimitiveObjectInspector)valuesInspectors[i]);
        }
        switch (keyInspector.getPrimitiveCategory()) {
            case BINARY: {
                this.sketch_.update(PrimitiveObjectInspectorUtils.getBinary((Object)data[0], (PrimitiveObjectInspector)keyInspector).copyBytes(), values);
                return;
            }
            case BYTE: {
                this.sketch_.update((long)PrimitiveObjectInspectorUtils.getByte((Object)data[0], (PrimitiveObjectInspector)keyInspector), values);
                return;
            }
            case DOUBLE: {
                this.sketch_.update(PrimitiveObjectInspectorUtils.getDouble((Object)data[0], (PrimitiveObjectInspector)keyInspector), values);
                return;
            }
            case FLOAT: {
                this.sketch_.update((double)PrimitiveObjectInspectorUtils.getFloat((Object)data[0], (PrimitiveObjectInspector)keyInspector), values);
                return;
            }
            case INT: {
                this.sketch_.update((long)PrimitiveObjectInspectorUtils.getInt((Object)data[0], (PrimitiveObjectInspector)keyInspector), values);
                return;
            }
            case LONG: {
                this.sketch_.update(PrimitiveObjectInspectorUtils.getLong((Object)data[0], (PrimitiveObjectInspector)keyInspector), values);
                return;
            }
            case STRING: {
                this.sketch_.update(PrimitiveObjectInspectorUtils.getString((Object)data[0], (PrimitiveObjectInspector)keyInspector), values);
                return;
            }
        }
        throw new IllegalArgumentException("Unrecongnized input data type, please use data of type: byte, double, float, int, long, or string only.");
    }

    @Override
    ArrayOfDoublesSketch getResult() {
        if (this.sketch_ == null) {
            return null;
        }
        this.sketch_.trim();
        return this.sketch_.compact();
    }

    @Override
    void reset() {
        this.sketch_ = null;
    }
}

