/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.rewrite;

import java.util.ArrayList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.rewrite.MergeRewriter;
import org.apache.hadoop.hive.ql.parse.rewrite.MergeStatement;
import org.apache.hadoop.hive.ql.parse.rewrite.sql.MultiInsertSqlGenerator;
import org.apache.hadoop.hive.ql.parse.rewrite.sql.SqlGeneratorFactory;

public class SplitMergeRewriter
extends MergeRewriter {
    public SplitMergeRewriter(Hive db, HiveConf conf, SqlGeneratorFactory sqlGeneratorFactory) {
        super(db, conf, sqlGeneratorFactory);
    }

    @Override
    protected MergeRewriter.MergeWhenClauseSqlGenerator createMergeSqlGenerator(MergeStatement mergeStatement, MultiInsertSqlGenerator sqlGenerator) {
        return new SplitMergeWhenClauseSqlGenerator(this.conf, sqlGenerator, mergeStatement);
    }

    @Override
    public void setOperation(Context context) {
        context.setOperation(Context.Operation.MERGE, true);
    }

    @Override
    public int addDestNamePrefixOfUpdate(int pos, Context context) {
        context.addDestNamePrefix(pos, Context.DestClausePrefix.INSERT);
        context.addDeleteOfUpdateDestNamePrefix(pos + 1, Context.DestClausePrefix.DELETE);
        return 2;
    }

    static class SplitMergeWhenClauseSqlGenerator
    extends MergeRewriter.MergeWhenClauseSqlGenerator {
        SplitMergeWhenClauseSqlGenerator(HiveConf conf, MultiInsertSqlGenerator sqlGenerator, MergeStatement mergeStatement) {
            super(conf, sqlGenerator, mergeStatement);
        }

        @Override
        public void appendWhenMatchedUpdateClause(MergeStatement.UpdateClause updateClause) {
            Table targetTable = this.mergeStatement.getTargetTable();
            String targetAlias = this.mergeStatement.getTargetAlias();
            String onClauseAsString = this.mergeStatement.getOnClauseAsText();
            this.sqlGenerator.append("    -- update clause (insert part)\n");
            ArrayList<String> values = new ArrayList<String>(targetTable.getCols().size() + targetTable.getPartCols().size());
            this.addValues(targetTable, targetAlias, updateClause.getNewValuesMap(), values);
            this.sqlGenerator.appendInsertBranch(this.hintStr, values);
            this.hintStr = null;
            this.addWhereClauseOfUpdate(onClauseAsString, updateClause.getExtraPredicate(), updateClause.getDeleteExtraPredicate(), this.sqlGenerator);
            this.sqlGenerator.append("\n");
            this.sqlGenerator.append("    -- update clause (delete part)\n");
            this.handleWhenMatchedDelete(onClauseAsString, updateClause.getExtraPredicate(), updateClause.getDeleteExtraPredicate(), this.hintStr, this.sqlGenerator);
        }
    }
}

