/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hive.metastore.api.SQLDefaultConstraint;

public class DefaultConstraint
implements Serializable {
    Map<String, List<DefaultConstraintCol>> defaultConstraints;
    Map<String, String> colNameToDefaultValueMap;
    String tableName;
    String databaseName;

    public DefaultConstraint() {
    }

    public DefaultConstraint(List<SQLDefaultConstraint> defaultConstraintList, String tableName, String databaseName) {
        this.tableName = tableName;
        this.databaseName = databaseName;
        this.defaultConstraints = new TreeMap<String, List<DefaultConstraintCol>>();
        this.colNameToDefaultValueMap = new TreeMap<String, String>();
        if (defaultConstraintList == null) {
            return;
        }
        for (SQLDefaultConstraint uk : defaultConstraintList) {
            if (!uk.getTable_db().equalsIgnoreCase(databaseName) || !uk.getTable_name().equalsIgnoreCase(tableName)) continue;
            String colName = uk.getColumn_name();
            String defVal = uk.getDefault_value();
            this.colNameToDefaultValueMap.put(colName, defVal);
            String enable = uk.isEnable_cstr() ? "ENABLE" : "DISABLE";
            String validate = uk.isValidate_cstr() ? "VALIDATE" : "NOVALIDATE";
            String rely = uk.isRely_cstr() ? "RELY" : "NORELY";
            DefaultConstraintCol currCol = new DefaultConstraintCol(this, colName, defVal, enable, validate, rely);
            String constraintName = uk.getDc_name();
            if (this.defaultConstraints.containsKey(constraintName)) {
                this.defaultConstraints.get(constraintName).add(currCol);
                continue;
            }
            ArrayList<DefaultConstraintCol> currList = new ArrayList<DefaultConstraintCol>();
            currList.add(currCol);
            this.defaultConstraints.put(constraintName, currList);
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public Map<String, List<DefaultConstraintCol>> getDefaultConstraints() {
        return this.defaultConstraints;
    }

    public Map<String, String> getColNameToDefaultValueMap() {
        return this.colNameToDefaultValueMap;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Default Constraints for " + this.databaseName + "." + this.tableName + ":");
        sb.append("[");
        if (this.defaultConstraints != null && this.defaultConstraints.size() > 0) {
            for (Map.Entry<String, List<DefaultConstraintCol>> me : this.defaultConstraints.entrySet()) {
                sb.append(" {Constraint Name: " + me.getKey() + ",");
                List<DefaultConstraintCol> currCol = me.getValue();
                if (currCol != null && currCol.size() > 0) {
                    for (DefaultConstraintCol ukc : currCol) {
                        sb.append(" (Column Name: " + ukc.colName + ", Default Value: " + ukc.defaultVal + "),");
                    }
                    sb.setLength(sb.length() - 1);
                }
                sb.append("},");
            }
            sb.setLength(sb.length() - 1);
        }
        sb.append("]");
        return sb.toString();
    }

    public static boolean isNotEmpty(DefaultConstraint info) {
        return info != null && !info.getDefaultConstraints().isEmpty();
    }

    public class DefaultConstraintCol {
        public String colName;
        public String defaultVal;
        public String enable;
        public String validate;
        public String rely;

        public DefaultConstraintCol(DefaultConstraint this$0, String colName, String defaultVal, String enable, String validate, String rely) {
            this.colName = colName;
            this.defaultVal = defaultVal;
            this.enable = enable;
            this.validate = validate;
            this.rely = rely;
        }
    }
}

