/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.ReplicationState;
import org.apache.hadoop.hive.ql.exec.repl.util.AddDependencyToLeaves;
import org.apache.hadoop.hive.ql.exec.util.DAGTraversal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskTracker {
    private static Logger LOG = LoggerFactory.getLogger(TaskTracker.class);
    private final List<Task<?>> tasks = new ArrayList();
    private ReplicationState replicationState = null;
    private int numberOfTasks = 0;
    private final int maxTasksAllowed;

    public TaskTracker(int defaultMaxTasks) {
        this.maxTasksAllowed = defaultMaxTasks;
    }

    public TaskTracker(TaskTracker existing) {
        this.maxTasksAllowed = existing.maxTasksAllowed - existing.numberOfTasks;
    }

    public void addTask(Task<?> task) {
        this.tasks.add(task);
        ArrayList visited = new ArrayList();
        this.updateTaskCount(task, visited);
    }

    public void addTaskList(List<Task<?>> taskList) {
        ArrayList visited = new ArrayList();
        for (Task<?> task : taskList) {
            if (visited.contains(task)) continue;
            this.tasks.add(task);
            this.updateTaskCount(task, visited);
        }
    }

    public void addDependentTask(Task<?> dependent) {
        if (this.tasks.isEmpty()) {
            this.addTask(dependent);
        } else {
            DAGTraversal.traverse(this.tasks, new AddDependencyToLeaves(dependent));
            ArrayList visited = new ArrayList();
            this.updateTaskCount(dependent, visited);
        }
    }

    private void updateTaskCount(Task<?> task, List<Task<?>> visited) {
        ++this.numberOfTasks;
        visited.add(task);
        if (task.getChildTasks() != null) {
            for (Task<?> childTask : task.getChildTasks()) {
                if (visited.contains(childTask)) continue;
                this.updateTaskCount(childTask, visited);
            }
        }
    }

    public boolean canAddMoreTasks() {
        return this.numberOfTasks < this.maxTasksAllowed;
    }

    public boolean hasTasks() {
        return this.numberOfTasks != 0;
    }

    public void update(TaskTracker withAnother) {
        this.numberOfTasks += withAnother.numberOfTasks;
        if (withAnother.hasReplicationState()) {
            this.replicationState = withAnother.replicationState;
        }
    }

    public void setReplicationState(ReplicationState state) {
        this.replicationState = state;
    }

    public boolean hasReplicationState() {
        return this.replicationState != null;
    }

    public ReplicationState replicationState() {
        return this.replicationState;
    }

    public List<Task<?>> tasks() {
        return this.tasks;
    }

    public void debugLog(String forEventType) {
        LOG.debug("{} event with total / root number of tasks:{}/{}", new Object[]{forEventType, this.numberOfTasks, this.tasks.size()});
    }

    public int numberOfTasks() {
        return this.numberOfTasks;
    }
}

