/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.partition.rename;

import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableAnalyzer;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableType;
import org.apache.hadoop.hive.ql.ddl.table.partition.PartitionUtils;
import org.apache.hadoop.hive.ql.ddl.table.partition.rename.AlterTableRenamePartitionDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={891})
public class AlterTableRenamePartitionAnalyzer
extends AbstractAlterTableAnalyzer {
    public AlterTableRenamePartitionAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    protected void analyzeCommand(TableName tableName, Map<String, String> partitionSpec, ASTNode command) throws SemanticException {
        Table table = this.getTable(tableName, true);
        this.validateAlterTableType(table, AlterTableType.RENAMEPARTITION, false);
        Map<String, String> newPartitionSpec = AlterTableRenamePartitionAnalyzer.getValidatedPartSpec(table, (ASTNode)command.getChild(0), this.conf, false);
        if (newPartitionSpec == null) {
            throw new SemanticException("RENAME PARTITION Missing Destination" + String.valueOf(command));
        }
        ReadEntity re = new ReadEntity(table);
        re.noLockNeeded();
        this.inputs.add(re);
        ArrayList<Map<String, String>> allPartitionSpecs = new ArrayList<Map<String, String>>();
        allPartitionSpecs.add(partitionSpec);
        allPartitionSpecs.add(newPartitionSpec);
        boolean clonePart = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_RENAME_PARTITION_MAKE_COPY) || HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_LOCKLESS_READS_ENABLED) && AcidUtils.isTransactionalTable(table);
        PartitionUtils.addTablePartsOutputs(this.db, this.outputs, table, allPartitionSpecs, false, clonePart ? WriteEntity.WriteType.DDL_EXCL_WRITE : WriteEntity.WriteType.DDL_EXCLUSIVE);
        AlterTableRenamePartitionDesc desc = new AlterTableRenamePartitionDesc(tableName, partitionSpec, newPartitionSpec, null, table);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
        if (AcidUtils.isTransactionalTable(table)) {
            this.setAcidDdlDesc(desc);
        }
    }
}

