/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.processors.ErasureProcessor;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRedStats {
    private static final String CLASS_NAME = MapRedStats.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    private JobConf jobConf;
    private int numMap;
    private int numReduce;
    private long cpuMSec;
    private Counters counters = null;
    private boolean success;
    private String jobId;
    private long numModifiedRows;

    public MapRedStats(JobConf jobConf, int numMap, int numReduce, long cpuMSec, boolean ifSuccess, String jobId) {
        this.jobConf = jobConf;
        this.numMap = numMap;
        this.numReduce = numReduce;
        this.cpuMSec = cpuMSec;
        this.success = ifSuccess;
        this.jobId = jobId;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public long getCpuMSec() {
        return this.cpuMSec;
    }

    public int getNumMap() {
        return this.numMap;
    }

    public void setNumMap(int numMap) {
        this.numMap = numMap;
    }

    public int getNumReduce() {
        return this.numReduce;
    }

    public void setNumReduce(int numReduce) {
        this.numReduce = numReduce;
    }

    public void setCounters(Counters taskCounters) {
        this.counters = taskCounters;
    }

    public Counters getCounters() {
        return this.counters;
    }

    public void setCpuMSec(long cpuMSec) {
        this.cpuMSec = cpuMSec;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public long getNumModifiedRows() {
        return this.numModifiedRows;
    }

    public void setNumModifiedRows(long numModifiedRows) {
        this.numModifiedRows = numModifiedRows;
    }

    public String getTaskNumbers() {
        StringBuilder sb = new StringBuilder();
        if (this.numMap > 0) {
            sb.append("Map: " + this.numMap + "  ");
        }
        if (this.numReduce > 0) {
            sb.append("Reduce: " + this.numReduce + "  ");
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.numMap > 0) {
            sb.append("Map: " + this.numMap + "  ");
        }
        if (this.numReduce > 0) {
            sb.append("Reduce: " + this.numReduce + "  ");
        }
        if (this.cpuMSec > 0L) {
            sb.append(" Cumulative CPU: " + (double)this.cpuMSec / 1000.0 + " sec  ");
        }
        if (this.counters != null) {
            long hdfsReadEc;
            Counters.Counter hdfsReadEcCntr;
            HadoopShims.HdfsErasureCodingShim erasureShim;
            long hdfsWritten;
            Counters.Counter hdfsWrittenCntr;
            long hdfsRead;
            Counters.Counter hdfsReadCntr = this.counters.findCounter("FileSystemCounters", "HDFS_BYTES_READ");
            if (hdfsReadCntr != null && (hdfsRead = hdfsReadCntr.getValue()) >= 0L) {
                sb.append(" HDFS Read: " + hdfsRead);
            }
            if ((hdfsWrittenCntr = this.counters.findCounter("FileSystemCounters", "HDFS_BYTES_WRITTEN")) != null && (hdfsWritten = hdfsWrittenCntr.getValue()) >= 0L) {
                sb.append(" HDFS Write: " + hdfsWritten);
            }
            if ((erasureShim = this.getHdfsErasureCodingShim()) != null && erasureShim.isMapReduceStatAvailable() && (hdfsReadEcCntr = this.counters.findCounter("FileSystemCounters", "HDFS_BYTES_READ_EC")) != null && (hdfsReadEc = hdfsReadEcCntr.getValue()) >= 0L) {
                sb.append(" HDFS EC Read: " + hdfsReadEc);
            }
        }
        sb.append(" " + (this.success ? "SUCCESS" : "FAIL"));
        return sb.toString();
    }

    private HadoopShims.HdfsErasureCodingShim getHdfsErasureCodingShim() {
        HadoopShims.HdfsErasureCodingShim erasureShim = null;
        try {
            erasureShim = ErasureProcessor.getErasureShim((Configuration)this.jobConf);
        }
        catch (IOException e) {
            LOG.warn("Could not get Erasure Coding shim for reason: " + e.getMessage());
        }
        return erasureShim;
    }
}

