/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.io.IOException;
import java.util.function.Supplier;
import org.apache.hive.iceberg.org.apache.avro.Schema;
import org.apache.hive.iceberg.org.apache.avro.io.DatumReader;
import org.apache.hive.iceberg.org.apache.avro.io.Decoder;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.avro.SupportsRowPosition;
import org.apache.iceberg.mapping.NameMapping;

public class NameMappingDatumReader<D>
implements DatumReader<D>,
SupportsRowPosition {
    private final NameMapping nameMapping;
    private final DatumReader<D> wrapped;

    public NameMappingDatumReader(NameMapping nameMapping, DatumReader<D> wrapped) {
        this.nameMapping = nameMapping;
        this.wrapped = wrapped;
    }

    @Override
    public void setSchema(Schema newFileSchema) {
        Schema fileSchema = AvroSchemaUtil.hasIds(newFileSchema) ? newFileSchema : AvroSchemaUtil.applyNameMapping(newFileSchema, this.nameMapping);
        this.wrapped.setSchema(fileSchema);
    }

    @Override
    public D read(D reuse, Decoder in) throws IOException {
        return this.wrapped.read(reuse, in);
    }

    @Override
    public void setRowPositionSupplier(Supplier<Long> posSupplier) {
        if (this.wrapped instanceof SupportsRowPosition) {
            ((SupportsRowPosition)((Object)this.wrapped)).setRowPositionSupplier(posSupplier);
        }
    }
}

