/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.PeerProcedureInterface;
import org.apache.hadoop.hbase.master.replication.AbstractPeerProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, LargeTests.class})
public class TestProcedureWaitAndWake {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestProcedureWaitAndWake.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.getConfiguration().setInt("hbase.master.procedure.threads", 8);
        UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testPeerProcedure() {
        ProcedureExecutor procExec = UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor();
        CyclicBarrier barrier = new CyclicBarrier(2);
        MyPeerProcedure p1 = new MyPeerProcedure(barrier);
        MyPeerProcedure p2 = new MyPeerProcedure(barrier);
        long id1 = procExec.submitProcedure((Procedure)p1);
        long id2 = procExec.submitProcedure((Procedure)p2);
        UTIL.waitFor(10000L, () -> procExec.isFinished(id1));
        UTIL.waitFor(10000L, () -> procExec.isFinished(id2));
    }

    public static final class MyPeerProcedure
    extends AbstractPeerProcedure<Integer> {
        private final CyclicBarrier barrier;
        private boolean passedBarrier;

        public MyPeerProcedure() {
            this(null);
        }

        public MyPeerProcedure(CyclicBarrier barrier) {
            super("1");
            this.barrier = barrier;
        }

        public PeerProcedureInterface.PeerOperationType getPeerOperationType() {
            return PeerProcedureInterface.PeerOperationType.REMOVE;
        }

        protected Procedure.LockState acquireLock(MasterProcedureEnv env) {
            if (!this.passedBarrier) {
                try {
                    this.barrier.await();
                }
                catch (InterruptedException | BrokenBarrierException e) {
                    throw new RuntimeException(e);
                }
                this.passedBarrier = true;
            }
            return super.acquireLock(env);
        }

        protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, Integer state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
            if (state == 0) {
                this.setNextState(1);
                this.addChildProcedure((Procedure[])new MySubPeerProcedure[]{new MySubPeerProcedure()});
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            Thread.sleep(200L);
            return StateMachineProcedure.Flow.NO_MORE_STATE;
        }

        protected Integer getState(int stateId) {
            return stateId;
        }

        protected int getStateId(Integer state) {
            return state;
        }

        protected Integer getInitialState() {
            return 0;
        }

        protected void rollbackState(MasterProcedureEnv env, Integer state) throws IOException, InterruptedException {
            throw new UnsupportedOperationException();
        }

        public static final class MySubPeerProcedure
        extends StateMachineProcedure<MasterProcedureEnv, Integer>
        implements PeerProcedureInterface {
            public PeerProcedureInterface.PeerOperationType getPeerOperationType() {
                return PeerProcedureInterface.PeerOperationType.REFRESH;
            }

            protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, Integer state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
                return StateMachineProcedure.Flow.NO_MORE_STATE;
            }

            protected Integer getState(int stateId) {
                return stateId;
            }

            protected int getStateId(Integer state) {
                return state;
            }

            protected Integer getInitialState() {
                return 0;
            }

            public String getPeerId() {
                return "1";
            }

            protected void rollbackState(MasterProcedureEnv env, Integer state) throws IOException, InterruptedException {
                throw new UnsupportedOperationException();
            }
        }
    }
}

