/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.AnnotatedGenericBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.context.properties.BindMethodAttribute;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConfigurationPropertiesBean;
import org.springframework.boot.context.properties.ConstructorBound;
import org.springframework.boot.context.properties.bind.BindMethod;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.context.annotation.AnnotationScopeMetadataResolver;
import org.springframework.context.annotation.ScopeMetadata;
import org.springframework.context.annotation.ScopeMetadataResolver;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

final class ConfigurationPropertiesBeanRegistrar {
    private static final ScopeMetadataResolver scopeMetadataResolver = new AnnotationScopeMetadataResolver();
    private final BeanDefinitionRegistry registry;
    private final BeanFactory beanFactory;

    ConfigurationPropertiesBeanRegistrar(BeanDefinitionRegistry registry) {
        this.registry = registry;
        this.beanFactory = (BeanFactory)((Object)this.registry);
    }

    void register(Class<?> type) {
        MergedAnnotation<ConfigurationProperties> annotation = MergedAnnotations.from(type, MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(ConfigurationProperties.class);
        this.register(type, annotation);
    }

    void register(Class<?> type, MergedAnnotation<ConfigurationProperties> annotation) {
        String name = this.getName(type, annotation);
        if (!this.containsBeanDefinition(name)) {
            this.registerBeanDefinition(name, type, annotation);
        }
    }

    private String getName(Class<?> type, MergedAnnotation<ConfigurationProperties> annotation) {
        String prefix = annotation.isPresent() ? annotation.getString("prefix") : "";
        return StringUtils.hasText(prefix) ? prefix + "-" + type.getName() : type.getName();
    }

    private boolean containsBeanDefinition(String name) {
        ListableBeanFactory listableBeanFactory;
        BeanFactory beanFactory = this.beanFactory;
        return beanFactory instanceof ListableBeanFactory && (listableBeanFactory = (ListableBeanFactory)beanFactory).containsBeanDefinition(name);
    }

    private void registerBeanDefinition(String beanName, Class<?> type, MergedAnnotation<ConfigurationProperties> annotation) {
        Assert.state(annotation.isPresent(), () -> "No " + ConfigurationProperties.class.getSimpleName() + " annotation found on  '" + type.getName() + "'.");
        BeanDefinitionReaderUtils.registerBeanDefinition(this.createBeanDefinition(beanName, type), this.registry);
    }

    private BeanDefinitionHolder createBeanDefinition(String beanName, Class<?> type) {
        AnnotatedGenericBeanDefinition definition = new AnnotatedGenericBeanDefinition(type);
        AnnotationConfigUtils.processCommonDefinitionAnnotations(definition);
        BindMethod bindMethod = ConfigurationPropertiesBean.deduceBindMethod(type);
        BindMethodAttribute.set(definition, bindMethod);
        if (bindMethod == BindMethod.VALUE_OBJECT) {
            definition.setInstanceSupplier(() -> ConstructorBound.from(this.beanFactory, beanName, type));
        }
        ScopeMetadata metadata = scopeMetadataResolver.resolveScopeMetadata(definition);
        definition.setScope(metadata.getScopeName());
        BeanDefinitionHolder definitionHolder = new BeanDefinitionHolder(definition, beanName);
        return ConfigurationPropertiesBeanRegistrar.applyScopedProxyMode(metadata, definitionHolder, this.registry);
    }

    static BeanDefinitionHolder applyScopedProxyMode(ScopeMetadata metadata, BeanDefinitionHolder definition, BeanDefinitionRegistry registry) {
        ScopedProxyMode mode = metadata.getScopedProxyMode();
        if (mode != ScopedProxyMode.NO) {
            return ScopedProxyUtils.createScopedProxy(definition, registry, mode == ScopedProxyMode.TARGET_CLASS);
        }
        return definition;
    }
}

