/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.build.dependencies;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import java.util.Objects;
import org.grails.forge.build.dependencies.Coordinate;
import org.grails.forge.build.dependencies.DependencyCoordinate;
import org.grails.forge.build.dependencies.Scope;
import org.grails.forge.template.Writable;

public final class Dependency {
    private final Scope scope;
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String versionProperty;
    private final Writable extension;
    private final boolean requiresLookup;
    private final int order;
    private final boolean annotationProcessorPriority;
    private final boolean pom;

    private Dependency(Scope scope, String groupId, String artifactId, String version, String versionProperty, Writable extension, boolean requiresLookup, boolean annotationProcessorPriority, int order, boolean pom) {
        this.scope = scope;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.versionProperty = versionProperty;
        this.extension = extension;
        this.requiresLookup = requiresLookup;
        this.annotationProcessorPriority = annotationProcessorPriority;
        this.order = order;
        this.pom = pom;
    }

    private Dependency(Scope scope, String groupId, String artifactId, String version, String versionProperty, boolean requiresLookup, boolean annotationProcessorPriority, int order, boolean pom) {
        this(scope, groupId, artifactId, version, versionProperty, null, requiresLookup, annotationProcessorPriority, order, pom);
    }

    public Scope getScope() {
        return this.scope;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getVersionProperty() {
        return this.versionProperty;
    }

    public int getOrder() {
        return this.order;
    }

    public boolean isPom() {
        return this.pom;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean requiresLookup() {
        return this.requiresLookup;
    }

    public Dependency resolved(Coordinate coordinate) {
        return new Dependency(this.scope, coordinate.getGroupId(), this.artifactId, coordinate.getVersion(), null, false, this.annotationProcessorPriority, this.order, coordinate.isPom());
    }

    public Dependency scope(Scope newScope) {
        return new Dependency(newScope, this.groupId, this.artifactId, this.version, this.versionProperty, this.requiresLookup, this.annotationProcessorPriority, this.order, this.pom);
    }

    public boolean isAnnotationProcessorPriority() {
        return this.annotationProcessorPriority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dependency that = (Dependency)o;
        return Objects.equals(this.getGroupId(), that.getGroupId()) && Objects.equals(this.getArtifactId(), that.getArtifactId()) && Objects.equals(this.getScope(), that.getScope());
    }

    public int hashCode() {
        return Objects.hash(this.getGroupId(), this.getArtifactId(), this.getScope());
    }

    public static class Builder {
        private Scope scope;
        private String groupId;
        private String artifactId;
        private String version;
        private String versionProperty;
        private Writable extension;
        private boolean requiresLookup;
        private int order = 0;
        private boolean template = false;
        private boolean annotationProcessorPriority = false;
        private boolean pom = false;

        public Builder scope(@NonNull Scope scope) {
            if (this.template) {
                return this.copy().scope(scope);
            }
            this.scope = scope;
            return this;
        }

        public Builder buildSrc() {
            return this.scope(Scope.BUILD);
        }

        public Builder implementation() {
            return this.scope(Scope.IMPLEMENTATION);
        }

        public Builder console() {
            return this.scope(Scope.CONSOLE);
        }

        public Builder compileOnly() {
            return this.scope(Scope.COMPILE_ONLY);
        }

        public Builder developmentOnly() {
            return this.scope(Scope.DEVELOPMENT_ONLY);
        }

        public Builder testAndDevelopmentOnly() {
            return this.scope(Scope.TEST_AND_DEVELOPMENT_ONLY);
        }

        public Builder runtimeOnly() {
            return this.scope(Scope.RUNTIME_ONLY);
        }

        public Builder testImplementation() {
            return this.scope(Scope.TEST_IMPLEMENTATION);
        }

        public Builder testCompileOnly() {
            return this.scope(Scope.TEST_COMPILE_ONLY);
        }

        public Builder testRuntimeOnly() {
            return this.scope(Scope.TEST_RUNTIME_ONLY);
        }

        public Builder annotationProcessor() {
            return this.scope(Scope.ANNOTATION_PROCESSOR);
        }

        public Builder profile() {
            return this.scope(Scope.PROFILE);
        }

        public Builder integrationTestImplementationTestFixtures() {
            return this.scope(Scope.INTEGRATION_TEST_IMPLEMENTATION_TEST_FIXTURES);
        }

        public Builder classpath() {
            return this.scope(Scope.CLASSPATH);
        }

        public Builder annotationProcessor(boolean requiresPriority) {
            this.annotationProcessorPriority = requiresPriority;
            return this.annotationProcessor();
        }

        public Builder testAnnotationProcessor() {
            return this.scope(Scope.TEST_ANNOTATION_PROCESSOR);
        }

        public Builder testAnnotationProcessor(boolean requiresPriority) {
            this.annotationProcessorPriority = requiresPriority;
            return this.testAnnotationProcessor();
        }

        public Builder groupId(@Nullable String groupId) {
            if (this.template) {
                return this.copy().groupId(groupId);
            }
            this.groupId = groupId;
            return this;
        }

        public Builder artifactId(@NonNull String artifactId) {
            if (this.template) {
                return this.copy().artifactId(artifactId);
            }
            this.artifactId = artifactId;
            return this;
        }

        public Builder lookupArtifactId(@NonNull String artifactId) {
            if (this.template) {
                return this.copy().lookupArtifactId(artifactId);
            }
            this.artifactId = artifactId;
            this.requiresLookup = true;
            return this;
        }

        public Builder version(@Nullable String version) {
            if (this.template) {
                return this.copy().version(version);
            }
            this.version = version;
            return this;
        }

        public Builder versionProperty(@Nullable String versionProperty) {
            if (this.template) {
                return this.copy().versionProperty(versionProperty);
            }
            this.versionProperty = versionProperty;
            return this;
        }

        @NonNull
        public Builder extension(@Nullable Writable extension) {
            this.extension = extension;
            return this;
        }

        public Builder order(int order) {
            if (this.template) {
                return this.copy().order(order);
            }
            this.order = order;
            return this;
        }

        public Builder template() {
            this.template = true;
            return this;
        }

        public Builder pom(boolean pom) {
            this.pom = pom;
            return this;
        }

        public Dependency build() {
            Objects.requireNonNull(this.scope, "The dependency scope must be set");
            Objects.requireNonNull(this.artifactId, "The artifact id must be set");
            return this.buildInternal();
        }

        public DependencyCoordinate buildCoordinate() {
            return this.buildCoordinate(false);
        }

        public DependencyCoordinate buildCoordinate(boolean showVersionProperty) {
            Objects.requireNonNull(this.artifactId, "The artifact id must be set");
            return new DependencyCoordinate(this.buildInternal(), showVersionProperty);
        }

        private Dependency buildInternal() {
            return new Dependency(this.scope, this.groupId, this.artifactId, this.version, this.versionProperty, this.requiresLookup, this.annotationProcessorPriority, this.order, this.pom);
        }

        private Builder copy() {
            Builder builder = new Builder().scope(this.scope);
            if (this.requiresLookup) {
                builder.lookupArtifactId(this.artifactId);
            } else {
                builder.groupId(this.groupId).artifactId(this.artifactId);
                if (this.versionProperty != null) {
                    builder.versionProperty(this.versionProperty);
                } else {
                    builder.version(this.version);
                }
            }
            if (this.extension != null) {
                builder.extension(this.extension);
            }
            return builder.order(this.order).pom(this.pom);
        }
    }
}

