/*
 * Decompiled with CFR 0.152.
 */
package org.grails.cli.compiler.grape;

import java.io.PrintStream;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferResource;
import org.grails.cli.compiler.grape.ProgressReporter;

final class DetailedProgressReporter
implements ProgressReporter {
    DetailedProgressReporter(DefaultRepositorySystemSession session, final PrintStream out) {
        session.setTransferListener(new AbstractTransferListener(){

            @Override
            public void transferStarted(TransferEvent event) throws TransferCancelledException {
                out.println("Downloading: " + DetailedProgressReporter.this.getResourceIdentifier(event.getResource()));
            }

            @Override
            public void transferSucceeded(TransferEvent event) {
                out.printf("Downloaded: %s (%s)%n", DetailedProgressReporter.this.getResourceIdentifier(event.getResource()), DetailedProgressReporter.this.getTransferSpeed(event));
            }
        });
    }

    private String getResourceIdentifier(TransferResource resource) {
        return resource.getRepositoryUrl() + resource.getResourceName();
    }

    private String getTransferSpeed(TransferEvent event) {
        long kb = event.getTransferredBytes() / 1024L;
        float seconds = (float)(System.currentTimeMillis() - event.getResource().getTransferStartTime()) / 1000.0f;
        return String.format("%dKB at %.1fKB/sec", kb, Float.valueOf((float)kb / seconds));
    }

    @Override
    public void finished() {
    }
}

