/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.weaver.model;

import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.commons.weaver.model.Weavable;
import org.apache.commons.weaver.model.WeavableClass;

public class WeavablePackage
extends Weavable<WeavablePackage, Package> {
    private static final Comparator<WeavablePackage> CMP = Comparator.nullsFirst(Comparator.comparing(Weavable::getTarget, Comparator.nullsFirst(Comparator.comparing(Package::getName))));
    private final ConcurrentNavigableMap<String, WeavableClass<?>> clazzes = new ConcurrentSkipListMap();

    public WeavablePackage(Package target) {
        super(target);
    }

    public synchronized <T> WeavableClass<T> getWeavable(Class<T> cls) {
        return this.clazzes.computeIfAbsent(cls.getName(), k -> new WeavableClass(cls, this));
    }

    public Iterable<WeavableClass<?>> getClasses() {
        return Collections.unmodifiableCollection(this.clazzes.values());
    }

    @Override
    public int compareTo(WeavablePackage arg0) {
        return CMP.compare(this, arg0);
    }

    @Override
    public String toString() {
        if (this.getTarget() == null) {
            return "Weavable default package";
        }
        return super.toString();
    }
}

