/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.commons.pool2.impl.CallStack;
import org.apache.commons.pool2.impl.SecurityManagerCallStack;
import org.apache.commons.pool2.impl.ThrowableCallStack;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CallStackTest {
    private final CallStack stack;
    private final StringWriter writer = new StringWriter();

    public CallStackTest(CallStack stack) {
        this.stack = stack;
    }

    @Parameterized.Parameters
    public static Object[] data() {
        return new Object[]{new ThrowableCallStack("Test", false), new SecurityManagerCallStack("Test", false)};
    }

    @Test
    public void testPrintClearedStackTraceIsNoOp() throws Exception {
        this.stack.fillInStackTrace();
        this.stack.clear();
        this.stack.printStackTrace(new PrintWriter(this.writer));
        String stackTrace = this.writer.toString();
        Assert.assertEquals((Object)"", (Object)stackTrace);
    }

    @Test
    public void testPrintFilledStackTrace() throws Exception {
        this.stack.fillInStackTrace();
        this.stack.printStackTrace(new PrintWriter(this.writer));
        String stackTrace = this.writer.toString();
        Assert.assertTrue((boolean)stackTrace.contains(this.getClass().getName()));
    }
}

