/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization.general;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.analysis.differentiation.MultivariateDifferentiableVectorFunction;
import org.apache.commons.math3.exception.ConvergenceException;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.optimization.PointVectorValuePair;
import org.apache.commons.math3.optimization.general.AbstractLeastSquaresOptimizer;
import org.apache.commons.math3.optimization.general.CircleVectorial;
import org.apache.commons.math3.optimization.general.StatisticalReferenceDataset;
import org.apache.commons.math3.optimization.general.StatisticalReferenceDatasetFactory;
import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

@Deprecated
public abstract class AbstractLeastSquaresOptimizerAbstractTest {
    private final double[][] circlePoints = new double[][]{{-0.312967, 0.072366}, {-0.339248, 0.132965}, {-0.37978, 0.202724}, {-0.390426, 0.260487}, {-0.361212, 0.328325}, {-0.346039, 0.392619}, {-0.280579, 0.444306}, {-0.216035, 0.470009}, {-0.149127, 0.493832}, {-0.075133, 0.483271}, {-0.007759, 0.45268}, {0.060071, 0.410235}, {0.103037, 0.341076}, {0.118438, 0.273884}, {0.131293, 0.192201}, {0.115869, 0.129797}, {0.072223, 0.058396}, {0.022884, 7.18E-4}, {-0.053355, -0.020405}, {-0.123584, -0.032451}, {-0.216248, -0.032862}, {-0.278592, -0.005008}, {-0.337655, 0.056658}, {-0.385899, 0.112526}, {-0.405517, 0.186957}, {-0.415374, 0.262071}, {-0.387482, 0.343398}, {-0.347322, 0.397943}, {-0.287623, 0.458425}, {-0.223502, 0.475513}, {-0.135352, 0.478186}, {-0.061221, 0.483371}, {0.003711, 0.422737}, {0.065054, 0.37583}, {0.108108, 0.297099}, {0.123882, 0.22285}, {0.117729, 0.134382}, {0.085195, 0.05682}, {0.0298, -0.019138}, {-0.02752, -0.072374}, {-0.102268, -0.091555}, {-0.200299, -0.106578}, {-0.292731, -0.091473}, {-0.356288, -0.051108}, {-0.420561, 0.014926}, {-0.471036, 0.074716}, {-0.488638, 0.182508}, {-0.48599, 0.254068}, {-0.463943, 0.338438}, {-0.406453, 0.404704}, {-0.334287, 0.466119}, {-0.254244, 0.503188}, {-0.161548, 0.495769}, {-0.075733, 0.49556}, {0.001375, 0.434937}, {0.082787, 0.385806}, {0.11549, 0.323807}, {0.141089, 0.22345}, {0.138693, 0.131703}, {0.126415, 0.049174}, {0.066518, -0.010217}, {-0.005184, -0.070647}, {-0.080985, -0.103635}, {-0.177377, -0.116887}, {-0.260628, -0.100258}, {-0.335756, -0.056251}, {-0.405195, -8.95E-4}, {-0.444937, 0.085456}, {-0.484357, 0.175597}, {-0.472453, 0.248681}, {-0.43858, 0.347463}, {-0.402304, 0.422428}, {-0.326777, 0.479438}, {-0.247797, 0.505581}, {-0.152676, 0.51938}, {-0.071754, 0.516264}, {0.015942, 0.472802}, {0.076608, 0.419077}, {0.127673, 0.330264}, {0.159951, 0.26215}, {0.15353, 0.172681}, {0.140653, 0.089229}, {0.078666, 0.024981}, {0.023807, -0.037022}, {-0.048837, -0.077056}, {-0.127729, -0.075338}, {-0.221271, -0.067526}};

    public abstract AbstractLeastSquaresOptimizer createOptimizer();

    @Test
    public void testTrivial() {
        LinearProblem problem = new LinearProblem(new double[][]{{2.0}}, new double[]{3.0});
        AbstractLeastSquaresOptimizer optimizer = this.createOptimizer();
        PointVectorValuePair optimum = optimizer.optimize(100, (MultivariateDifferentiableVectorFunction)problem, problem.target, new double[]{1.0}, new double[]{0.0});
        Assert.assertEquals((double)0.0, (double)optimizer.getRMS(), (double)1.0E-10);
        Assert.assertEquals((double)1.5, (double)optimum.getPoint()[0], (double)1.0E-10);
        Assert.assertEquals((double)3.0, (double)optimum.getValue()[0], (double)1.0E-10);
        try {
            optimizer.guessParametersErrors();
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
    }

    @Test
    public void testQRColumnsPermutation() {
        LinearProblem problem = new LinearProblem(new double[][]{{1.0, -1.0}, {0.0, 2.0}, {1.0, -2.0}}, new double[]{4.0, 6.0, 1.0});
        AbstractLeastSquaresOptimizer optimizer = this.createOptimizer();
        PointVectorValuePair optimum = optimizer.optimize(100, (MultivariateDifferentiableVectorFunction)problem, problem.target, new double[]{1.0, 1.0, 1.0}, new double[]{0.0, 0.0});
        Assert.assertEquals((double)0.0, (double)optimizer.getRMS(), (double)1.0E-10);
        Assert.assertEquals((double)7.0, (double)optimum.getPoint()[0], (double)1.0E-10);
        Assert.assertEquals((double)3.0, (double)optimum.getPoint()[1], (double)1.0E-10);
        Assert.assertEquals((double)4.0, (double)optimum.getValue()[0], (double)1.0E-10);
        Assert.assertEquals((double)6.0, (double)optimum.getValue()[1], (double)1.0E-10);
        Assert.assertEquals((double)1.0, (double)optimum.getValue()[2], (double)1.0E-10);
    }

    @Test
    public void testNoDependency() {
        LinearProblem problem = new LinearProblem(new double[][]{{2.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 2.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 2.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 2.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 2.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 2.0}}, new double[]{0.0, 1.1, 2.2, 3.3, 4.4, 5.5});
        AbstractLeastSquaresOptimizer optimizer = this.createOptimizer();
        PointVectorValuePair optimum = optimizer.optimize(100, (MultivariateDifferentiableVectorFunction)problem, problem.target, new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0});
        Assert.assertEquals((double)0.0, (double)optimizer.getRMS(), (double)1.0E-10);
        for (int i = 0; i < problem.target.length; ++i) {
            Assert.assertEquals((double)(0.55 * (double)i), (double)optimum.getPoint()[i], (double)1.0E-10);
        }
    }

    @Test
    public void testOneSet() {
        LinearProblem problem = new LinearProblem(new double[][]{{1.0, 0.0, 0.0}, {-1.0, 1.0, 0.0}, {0.0, -1.0, 1.0}}, new double[]{1.0, 1.0, 1.0});
        AbstractLeastSquaresOptimizer optimizer = this.createOptimizer();
        PointVectorValuePair optimum = optimizer.optimize(100, (MultivariateDifferentiableVectorFunction)problem, problem.target, new double[]{1.0, 1.0, 1.0}, new double[]{0.0, 0.0, 0.0});
        Assert.assertEquals((double)0.0, (double)optimizer.getRMS(), (double)1.0E-10);
        Assert.assertEquals((double)1.0, (double)optimum.getPoint()[0], (double)1.0E-10);
        Assert.assertEquals((double)2.0, (double)optimum.getPoint()[1], (double)1.0E-10);
        Assert.assertEquals((double)3.0, (double)optimum.getPoint()[2], (double)1.0E-10);
    }

    @Test
    public void testTwoSets() {
        double epsilon = 1.0E-7;
        LinearProblem problem = new LinearProblem(new double[][]{{2.0, 1.0, 0.0, 4.0, 0.0, 0.0}, {-4.0, -2.0, 3.0, -7.0, 0.0, 0.0}, {4.0, 1.0, -2.0, 8.0, 0.0, 0.0}, {0.0, -3.0, -12.0, -1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, epsilon, 1.0}, {0.0, 0.0, 0.0, 0.0, 1.0, 1.0}}, new double[]{2.0, -9.0, 2.0, 2.0, 1.0 + epsilon * epsilon, 2.0});
        AbstractLeastSquaresOptimizer optimizer = this.createOptimizer();
        PointVectorValuePair optimum = optimizer.optimize(100, (MultivariateDifferentiableVectorFunction)problem, problem.target, new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0}, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0});
        Assert.assertEquals((double)0.0, (double)optimizer.getRMS(), (double)1.0E-10);
        Assert.assertEquals((double)3.0, (double)optimum.getPoint()[0], (double)1.0E-10);
        Assert.assertEquals((double)4.0, (double)optimum.getPoint()[1], (double)1.0E-10);
        Assert.assertEquals((double)-1.0, (double)optimum.getPoint()[2], (double)1.0E-10);
        Assert.assertEquals((double)-2.0, (double)optimum.getPoint()[3], (double)1.0E-10);
        Assert.assertEquals((double)(1.0 + epsilon), (double)optimum.getPoint()[4], (double)1.0E-10);
        Assert.assertEquals((double)(1.0 - epsilon), (double)optimum.getPoint()[5], (double)1.0E-10);
    }

    @Test(expected=ConvergenceException.class)
    public void testNonInvertible() throws Exception {
        LinearProblem problem = new LinearProblem(new double[][]{{1.0, 2.0, -3.0}, {2.0, 1.0, 3.0}, {-3.0, 0.0, -9.0}}, new double[]{1.0, 1.0, 1.0});
        AbstractLeastSquaresOptimizer optimizer = this.createOptimizer();
        optimizer.optimize(100, (MultivariateDifferentiableVectorFunction)problem, problem.target, new double[]{1.0, 1.0, 1.0}, new double[]{0.0, 0.0, 0.0});
    }

    @Test
    public void testIllConditioned() {
        LinearProblem problem1 = new LinearProblem(new double[][]{{10.0, 7.0, 8.0, 7.0}, {7.0, 5.0, 6.0, 5.0}, {8.0, 6.0, 10.0, 9.0}, {7.0, 5.0, 9.0, 10.0}}, new double[]{32.0, 23.0, 33.0, 31.0});
        AbstractLeastSquaresOptimizer optimizer = this.createOptimizer();
        PointVectorValuePair optimum1 = optimizer.optimize(100, (MultivariateDifferentiableVectorFunction)problem1, problem1.target, new double[]{1.0, 1.0, 1.0, 1.0}, new double[]{0.0, 1.0, 2.0, 3.0});
        Assert.assertEquals((double)0.0, (double)optimizer.getRMS(), (double)1.0E-10);
        Assert.assertEquals((double)1.0, (double)optimum1.getPoint()[0], (double)1.0E-10);
        Assert.assertEquals((double)1.0, (double)optimum1.getPoint()[1], (double)1.0E-10);
        Assert.assertEquals((double)1.0, (double)optimum1.getPoint()[2], (double)1.0E-10);
        Assert.assertEquals((double)1.0, (double)optimum1.getPoint()[3], (double)1.0E-10);
        LinearProblem problem2 = new LinearProblem(new double[][]{{10.0, 7.0, 8.1, 7.2}, {7.08, 5.04, 6.0, 5.0}, {8.0, 5.98, 9.89, 9.0}, {6.99, 4.99, 9.0, 9.98}}, new double[]{32.0, 23.0, 33.0, 31.0});
        PointVectorValuePair optimum2 = optimizer.optimize(100, (MultivariateDifferentiableVectorFunction)problem2, problem2.target, new double[]{1.0, 1.0, 1.0, 1.0}, new double[]{0.0, 1.0, 2.0, 3.0});
        Assert.assertEquals((double)0.0, (double)optimizer.getRMS(), (double)1.0E-10);
        Assert.assertEquals((double)-81.0, (double)optimum2.getPoint()[0], (double)1.0E-8);
        Assert.assertEquals((double)137.0, (double)optimum2.getPoint()[1], (double)1.0E-8);
        Assert.assertEquals((double)-34.0, (double)optimum2.getPoint()[2], (double)1.0E-8);
        Assert.assertEquals((double)22.0, (double)optimum2.getPoint()[3], (double)1.0E-8);
    }

    @Test
    public void testMoreEstimatedParametersSimple() {
        LinearProblem problem = new LinearProblem(new double[][]{{3.0, 2.0, 0.0, 0.0}, {0.0, 1.0, -1.0, 1.0}, {2.0, 0.0, 1.0, 0.0}}, new double[]{7.0, 3.0, 5.0});
        AbstractLeastSquaresOptimizer optimizer = this.createOptimizer();
        optimizer.optimize(100, (MultivariateDifferentiableVectorFunction)problem, problem.target, new double[]{1.0, 1.0, 1.0}, new double[]{7.0, 6.0, 5.0, 4.0});
        Assert.assertEquals((double)0.0, (double)optimizer.getRMS(), (double)1.0E-10);
    }

    @Test
    public void testMoreEstimatedParametersUnsorted() {
        LinearProblem problem = new LinearProblem(new double[][]{{1.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 1.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0, -1.0}, {0.0, 0.0, -1.0, 1.0, 0.0, 1.0}, {0.0, 0.0, 0.0, -1.0, 1.0, 0.0}}, new double[]{3.0, 12.0, -1.0, 7.0, 1.0});
        AbstractLeastSquaresOptimizer optimizer = this.createOptimizer();
        PointVectorValuePair optimum = optimizer.optimize(100, (MultivariateDifferentiableVectorFunction)problem, problem.target, new double[]{1.0, 1.0, 1.0, 1.0, 1.0}, new double[]{2.0, 2.0, 2.0, 2.0, 2.0, 2.0});
        Assert.assertEquals((double)0.0, (double)optimizer.getRMS(), (double)1.0E-10);
        Assert.assertEquals((double)3.0, (double)optimum.getPointRef()[2], (double)1.0E-10);
        Assert.assertEquals((double)4.0, (double)optimum.getPointRef()[3], (double)1.0E-10);
        Assert.assertEquals((double)5.0, (double)optimum.getPointRef()[4], (double)1.0E-10);
        Assert.assertEquals((double)6.0, (double)optimum.getPointRef()[5], (double)1.0E-10);
    }

    @Test
    public void testRedundantEquations() {
        LinearProblem problem = new LinearProblem(new double[][]{{1.0, 1.0}, {1.0, -1.0}, {1.0, 3.0}}, new double[]{3.0, 1.0, 5.0});
        AbstractLeastSquaresOptimizer optimizer = this.createOptimizer();
        PointVectorValuePair optimum = optimizer.optimize(100, (MultivariateDifferentiableVectorFunction)problem, problem.target, new double[]{1.0, 1.0, 1.0}, new double[]{1.0, 1.0});
        Assert.assertEquals((double)0.0, (double)optimizer.getRMS(), (double)1.0E-10);
        Assert.assertEquals((double)2.0, (double)optimum.getPointRef()[0], (double)1.0E-10);
        Assert.assertEquals((double)1.0, (double)optimum.getPointRef()[1], (double)1.0E-10);
    }

    @Test
    public void testInconsistentEquations() {
        LinearProblem problem = new LinearProblem(new double[][]{{1.0, 1.0}, {1.0, -1.0}, {1.0, 3.0}}, new double[]{3.0, 1.0, 4.0});
        AbstractLeastSquaresOptimizer optimizer = this.createOptimizer();
        optimizer.optimize(100, (MultivariateDifferentiableVectorFunction)problem, problem.target, new double[]{1.0, 1.0, 1.0}, new double[]{1.0, 1.0});
        Assert.assertTrue((optimizer.getRMS() > 0.1 ? 1 : 0) != 0);
    }

    @Test(expected=DimensionMismatchException.class)
    public void testInconsistentSizes1() {
        LinearProblem problem = new LinearProblem(new double[][]{{1.0, 0.0}, {0.0, 1.0}}, new double[]{-1.0, 1.0});
        AbstractLeastSquaresOptimizer optimizer = this.createOptimizer();
        PointVectorValuePair optimum = optimizer.optimize(100, (MultivariateDifferentiableVectorFunction)problem, problem.target, new double[]{1.0, 1.0}, new double[]{0.0, 0.0});
        Assert.assertEquals((double)0.0, (double)optimizer.getRMS(), (double)1.0E-10);
        Assert.assertEquals((double)-1.0, (double)optimum.getPoint()[0], (double)1.0E-10);
        Assert.assertEquals((double)1.0, (double)optimum.getPoint()[1], (double)1.0E-10);
        optimizer.optimize(100, (MultivariateDifferentiableVectorFunction)problem, problem.target, new double[]{1.0}, new double[]{0.0, 0.0});
    }

    @Test(expected=DimensionMismatchException.class)
    public void testInconsistentSizes2() {
        LinearProblem problem = new LinearProblem(new double[][]{{1.0, 0.0}, {0.0, 1.0}}, new double[]{-1.0, 1.0});
        AbstractLeastSquaresOptimizer optimizer = this.createOptimizer();
        PointVectorValuePair optimum = optimizer.optimize(100, (MultivariateDifferentiableVectorFunction)problem, problem.target, new double[]{1.0, 1.0}, new double[]{0.0, 0.0});
        Assert.assertEquals((double)0.0, (double)optimizer.getRMS(), (double)1.0E-10);
        Assert.assertEquals((double)-1.0, (double)optimum.getPoint()[0], (double)1.0E-10);
        Assert.assertEquals((double)1.0, (double)optimum.getPoint()[1], (double)1.0E-10);
        optimizer.optimize(100, (MultivariateDifferentiableVectorFunction)problem, new double[]{1.0}, new double[]{1.0}, new double[]{0.0, 0.0});
    }

    @Test
    public void testCircleFitting() {
        CircleVectorial circle = new CircleVectorial();
        circle.addPoint(30.0, 68.0);
        circle.addPoint(50.0, -6.0);
        circle.addPoint(110.0, -20.0);
        circle.addPoint(35.0, 15.0);
        circle.addPoint(45.0, 97.0);
        AbstractLeastSquaresOptimizer optimizer = this.createOptimizer();
        PointVectorValuePair optimum = optimizer.optimize(100, (MultivariateDifferentiableVectorFunction)circle, new double[]{0.0, 0.0, 0.0, 0.0, 0.0}, new double[]{1.0, 1.0, 1.0, 1.0, 1.0}, new double[]{98.68, 47.345});
        Assert.assertTrue((optimizer.getEvaluations() < 10 ? 1 : 0) != 0);
        Assert.assertTrue((optimizer.getJacobianEvaluations() < 10 ? 1 : 0) != 0);
        double rms = optimizer.getRMS();
        Assert.assertEquals((double)1.768262623567235, (double)(FastMath.sqrt((double)circle.getN()) * rms), (double)1.0E-10);
        Vector2D center = new Vector2D(optimum.getPointRef()[0], optimum.getPointRef()[1]);
        Assert.assertEquals((double)69.96016176931406, (double)circle.getRadius(center), (double)1.0E-6);
        Assert.assertEquals((double)96.07590211815305, (double)center.getX(), (double)1.0E-6);
        Assert.assertEquals((double)48.13516790438953, (double)center.getY(), (double)1.0E-6);
        double[][] cov = optimizer.computeCovariances(optimum.getPoint(), 1.0E-14);
        Assert.assertEquals((double)1.839, (double)cov[0][0], (double)0.001);
        Assert.assertEquals((double)0.731, (double)cov[0][1], (double)0.001);
        Assert.assertEquals((double)cov[0][1], (double)cov[1][0], (double)1.0E-14);
        Assert.assertEquals((double)0.786, (double)cov[1][1], (double)0.001);
        double r = circle.getRadius(center);
        for (double d = 0.0; d < Math.PI * 2; d += 0.01) {
            circle.addPoint(center.getX() + r * FastMath.cos((double)d), center.getY() + r * FastMath.sin((double)d));
        }
        double[] target = new double[circle.getN()];
        Arrays.fill(target, 0.0);
        double[] weights = new double[circle.getN()];
        Arrays.fill(weights, 2.0);
        optimum = optimizer.optimize(100, (MultivariateDifferentiableVectorFunction)circle, target, weights, new double[]{98.68, 47.345});
        cov = optimizer.computeCovariances(optimum.getPoint(), 1.0E-14);
        Assert.assertEquals((double)0.0016, (double)cov[0][0], (double)0.001);
        Assert.assertEquals((double)3.2E-7, (double)cov[0][1], (double)1.0E-9);
        Assert.assertEquals((double)cov[0][1], (double)cov[1][0], (double)1.0E-14);
        Assert.assertEquals((double)0.0016, (double)cov[1][1], (double)0.001);
    }

    @Test
    public void testCircleFittingBadInit() {
        CircleVectorial circle = new CircleVectorial();
        double[][] points = this.circlePoints;
        double[] target = new double[points.length];
        Arrays.fill(target, 0.0);
        double[] weights = new double[points.length];
        Arrays.fill(weights, 2.0);
        for (int i = 0; i < points.length; ++i) {
            circle.addPoint(points[i][0], points[i][1]);
        }
        AbstractLeastSquaresOptimizer optimizer = this.createOptimizer();
        PointVectorValuePair optimum = optimizer.optimize(100, (MultivariateDifferentiableVectorFunction)circle, target, weights, new double[]{-12.0, -12.0});
        Vector2D center = new Vector2D(optimum.getPointRef()[0], optimum.getPointRef()[1]);
        Assert.assertTrue((optimizer.getEvaluations() < 25 ? 1 : 0) != 0);
        Assert.assertTrue((optimizer.getJacobianEvaluations() < 20 ? 1 : 0) != 0);
        Assert.assertEquals((double)0.043, (double)optimizer.getRMS(), (double)0.001);
        Assert.assertEquals((double)0.292235, (double)circle.getRadius(center), (double)1.0E-6);
        Assert.assertEquals((double)-0.151738, (double)center.getX(), (double)1.0E-6);
        Assert.assertEquals((double)0.2075001, (double)center.getY(), (double)1.0E-6);
    }

    @Test
    public void testCircleFittingGoodInit() {
        CircleVectorial circle = new CircleVectorial();
        double[][] points = this.circlePoints;
        double[] target = new double[points.length];
        Arrays.fill(target, 0.0);
        double[] weights = new double[points.length];
        Arrays.fill(weights, 2.0);
        for (int i = 0; i < points.length; ++i) {
            circle.addPoint(points[i][0], points[i][1]);
        }
        AbstractLeastSquaresOptimizer optimizer = this.createOptimizer();
        PointVectorValuePair optimum = optimizer.optimize(100, (MultivariateDifferentiableVectorFunction)circle, target, weights, new double[]{0.0, 0.0});
        Assert.assertEquals((double)-0.1517383071957963, (double)optimum.getPointRef()[0], (double)1.0E-6);
        Assert.assertEquals((double)0.2074999736353867, (double)optimum.getPointRef()[1], (double)1.0E-6);
        Assert.assertEquals((double)0.04268731682389561, (double)optimizer.getRMS(), (double)1.0E-8);
    }

    public void doTestStRD(StatisticalReferenceDataset dataset, double errParams, double errParamsSd) {
        AbstractLeastSquaresOptimizer optimizer = this.createOptimizer();
        double[] w = new double[dataset.getNumObservations()];
        Arrays.fill(w, 1.0);
        double[][] data = dataset.getData();
        double[] initial = dataset.getStartingPoint(0);
        MultivariateDifferentiableVectorFunction problem = dataset.getLeastSquaresProblem();
        PointVectorValuePair optimum = optimizer.optimize(100, problem, data[1], w, initial);
        double[] actual = optimum.getPoint();
        for (int i = 0; i < actual.length; ++i) {
            double expected = dataset.getParameter(i);
            double delta = FastMath.abs((double)(errParams * expected));
            Assert.assertEquals((String)(dataset.getName() + ", param #" + i), (double)expected, (double)actual[i], (double)delta);
        }
    }

    @Test
    public void testKirby2() throws IOException {
        this.doTestStRD(StatisticalReferenceDatasetFactory.createKirby2(), 1.0E-7, 1.0E-7);
    }

    @Test
    public void testHahn1() throws IOException {
        this.doTestStRD(StatisticalReferenceDatasetFactory.createHahn1(), 1.0E-7, 1.0E-4);
    }

    static class LinearProblem
    implements MultivariateDifferentiableVectorFunction,
    Serializable {
        private static final long serialVersionUID = 703247177355019415L;
        final RealMatrix factors;
        final double[] target;

        public LinearProblem(double[][] factors, double[] target) {
            this.factors = new BlockRealMatrix(factors);
            this.target = target;
        }

        public double[] value(double[] variables) {
            return this.factors.operate(variables);
        }

        public DerivativeStructure[] value(DerivativeStructure[] variables) {
            DerivativeStructure[] value = new DerivativeStructure[this.factors.getRowDimension()];
            for (int i = 0; i < value.length; ++i) {
                value[i] = (DerivativeStructure)variables[0].getField().getZero();
                for (int j = 0; j < this.factors.getColumnDimension(); ++j) {
                    value[i] = value[i].add(variables[j].multiply(this.factors.getEntry(i, j)));
                }
            }
            return value;
        }
    }
}

