/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder;

import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BasicConfigurationBuilder;
import org.apache.commons.configuration2.builder.BuilderEventListenerImpl;
import org.apache.commons.configuration2.builder.ConfigurationBuilder;
import org.apache.commons.configuration2.builder.ConfigurationBuilderEvent;
import org.apache.commons.configuration2.builder.ConfigurationBuilderResultCreatedEvent;
import org.apache.commons.configuration2.event.Event;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.event.EventType;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBasicConfigurationBuilderEvents {
    @Test
    void testBuilderEventType() {
        EventType builderEventType = ConfigurationBuilderEvent.ANY;
        Assertions.assertEquals((Object)Event.ANY, (Object)builderEventType.getSuperType());
    }

    @Test
    void testBuilderResetEvent() {
        BuilderEventListenerImpl listener = new BuilderEventListenerImpl();
        BasicConfigurationBuilder builder = new BasicConfigurationBuilder(PropertiesConfiguration.class);
        builder.addEventListener(ConfigurationBuilderEvent.RESET, (EventListener)listener);
        builder.reset();
        builder.resetResult();
        Object event = listener.nextEvent(ConfigurationBuilderEvent.RESET);
        Assertions.assertSame((Object)builder, (Object)event.getSource());
        event = listener.nextEvent(ConfigurationBuilderEvent.RESET);
        Assertions.assertSame((Object)builder, (Object)event.getSource());
        listener.assertNoMoreEvents();
    }

    @Test
    void testBuilderResetEventType() {
        EventType builderResetType = ConfigurationBuilderEvent.RESET;
        Assertions.assertEquals((Object)ConfigurationBuilderEvent.ANY, (Object)builderResetType.getSuperType());
    }

    @Test
    void testConfigurationRequestEvent() throws ConfigurationException {
        BasicConfigurationBuilder builder = new BasicConfigurationBuilder(PropertiesConfiguration.class);
        builder.getConfiguration();
        BuilderEventListenerImpl listener = new BuilderEventListenerImpl();
        builder.addEventListener(ConfigurationBuilderEvent.ANY, (EventListener)listener);
        builder.getConfiguration();
        Object event = listener.nextEvent(ConfigurationBuilderEvent.CONFIGURATION_REQUEST);
        Assertions.assertSame((Object)builder, (Object)event.getSource());
        listener.assertNoMoreEvents();
    }

    @Test
    void testConfigurationRequestEventType() {
        EventType eventType = ConfigurationBuilderEvent.CONFIGURATION_REQUEST;
        Assertions.assertEquals((Object)ConfigurationBuilderEvent.ANY, (Object)eventType.getSuperType());
    }

    @Test
    void testRemoveEventListener() {
        BuilderEventListenerImpl listener = new BuilderEventListenerImpl();
        BasicConfigurationBuilder builder = new BasicConfigurationBuilder(PropertiesConfiguration.class);
        builder.addEventListener(ConfigurationBuilderEvent.RESET, (EventListener)listener);
        builder.reset();
        Assertions.assertTrue((boolean)builder.removeEventListener(ConfigurationBuilderEvent.RESET, (EventListener)listener));
        builder.resetResult();
        listener.nextEvent(ConfigurationBuilderEvent.RESET);
        listener.assertNoMoreEvents();
    }

    @Test
    void testRemoveEventListenerNotExisting() {
        BasicConfigurationBuilder builder = new BasicConfigurationBuilder(PropertiesConfiguration.class);
        BuilderEventListenerImpl listener = new BuilderEventListenerImpl();
        builder.addEventListener(ConfigurationBuilderEvent.RESET, (EventListener)listener);
        Assertions.assertFalse((boolean)builder.removeEventListener(ConfigurationBuilderEvent.CONFIGURATION_REQUEST, (EventListener)listener));
    }

    @Test
    void testResetOnConfigurationRequestEvent() throws ConfigurationException {
        BasicConfigurationBuilder builder = new BasicConfigurationBuilder(PropertiesConfiguration.class);
        PropertiesConfiguration configuration = (PropertiesConfiguration)builder.getConfiguration();
        BuilderEventListenerImpl listener = new BuilderEventListenerImpl();
        builder.addEventListener(ConfigurationBuilderEvent.RESET, (EventListener)listener);
        builder.addEventListener(ConfigurationBuilderEvent.CONFIGURATION_REQUEST, event -> builder.resetResult());
        PropertiesConfiguration configuration2 = (PropertiesConfiguration)builder.getConfiguration();
        Assertions.assertNotSame((Object)configuration, (Object)configuration2);
        listener.nextEvent(ConfigurationBuilderEvent.RESET);
        listener.assertNoMoreEvents();
    }

    @Test
    void testResultCreatedEvent() throws ConfigurationException {
        BasicConfigurationBuilder builder = new BasicConfigurationBuilder(PropertiesConfiguration.class);
        BuilderEventListenerImpl listener = new BuilderEventListenerImpl();
        builder.addEventListener(ConfigurationBuilderEvent.ANY, (EventListener)listener);
        PropertiesConfiguration configuration = (PropertiesConfiguration)builder.getConfiguration();
        listener.nextEvent(ConfigurationBuilderEvent.CONFIGURATION_REQUEST);
        ConfigurationBuilderResultCreatedEvent event = (ConfigurationBuilderResultCreatedEvent)listener.nextEvent(ConfigurationBuilderResultCreatedEvent.RESULT_CREATED);
        Assertions.assertSame((Object)builder, (Object)event.getSource());
        Assertions.assertSame((Object)configuration, (Object)event.getConfiguration());
    }

    @Test
    void testResultCreatedEventNoConfiguration() {
        BasicConfigurationBuilder builder = new BasicConfigurationBuilder(Configuration.class);
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ConfigurationBuilderResultCreatedEvent((ConfigurationBuilder)builder, ConfigurationBuilderResultCreatedEvent.RESULT_CREATED, null));
    }

    @Test
    void testResultCreatedEventType() {
        Assertions.assertEquals((Object)ConfigurationBuilderEvent.ANY, (Object)ConfigurationBuilderResultCreatedEvent.RESULT_CREATED.getSuperType());
    }
}

