/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.common.response;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.cassandra.sidecar.common.response.InstanceFileInfo;
import org.jetbrains.annotations.NotNull;

public class InstanceFilesListResponse {
    private final List<InstanceFileInfo> files;
    private final long totalSize;

    public InstanceFilesListResponse(@NotNull List<InstanceFileInfo> files) {
        this.files = Collections.unmodifiableList(files);
        long sum = 0L;
        for (InstanceFileInfo file : files) {
            if (!file.fileType.equals((Object)InstanceFileInfo.FileType.FILE)) continue;
            long size = file.size;
            sum += size;
        }
        this.totalSize = sum;
    }

    @JsonCreator
    public InstanceFilesListResponse(@JsonProperty(value="files") List<InstanceFileInfo> files, @JsonProperty(value="totalSize") long totalSize) {
        this.files = Collections.unmodifiableList(files);
        this.totalSize = totalSize;
    }

    public List<InstanceFileInfo> getFiles() {
        return this.files;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstanceFilesListResponse that = (InstanceFilesListResponse)o;
        return this.totalSize == that.totalSize && Objects.equals(this.files, that.files);
    }

    public int hashCode() {
        return Objects.hash(this.files, this.totalSize);
    }
}

