/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.restore;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.sidecar.exceptions.RestoreJobFatalException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.utils.ImmutableMap;

public class RestoreSliceManifest
extends HashMap<String, ManifestEntry> {
    public static final String MANIFEST_FILE_NAME = "manifest.json";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Logger LOGGER = LoggerFactory.getLogger(RestoreSliceManifest.class);

    public static RestoreSliceManifest read(File file) throws RestoreJobFatalException {
        if (!file.exists()) {
            throw new RestoreJobFatalException("Manifest file does not exist. file: " + file);
        }
        try {
            return (RestoreSliceManifest)MAPPER.readValue(file, RestoreSliceManifest.class);
        }
        catch (IOException e) {
            LOGGER.error("Failed to read restore slice manifest. file={}", (Object)file, (Object)e);
            throw new RestoreJobFatalException("Unable to read manifest", e);
        }
    }

    @NotNull
    public Map<String, String> mergeAllChecksums() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.values().forEach((? super T entry) -> entry.componentsChecksum().forEach((arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1)));
        return builder.build();
    }

    public static class ManifestEntry {
        private final Map<String, String> componentsChecksum;
        private final BigInteger startToken;
        private final BigInteger endToken;

        @JsonCreator
        public ManifestEntry(@JsonProperty(value="components_checksum") Map<String, String> componentsChecksum, @JsonProperty(value="start_token") BigInteger startToken, @JsonProperty(value="end_token") BigInteger endToken) {
            this.componentsChecksum = componentsChecksum;
            this.startToken = startToken;
            this.endToken = endToken;
        }

        @JsonProperty(value="components_checksum")
        public Map<String, String> componentsChecksum() {
            return this.componentsChecksum;
        }

        @JsonProperty(value="start_token")
        public BigInteger startToken() {
            return this.startToken;
        }

        @JsonProperty(value="end_token")
        public BigInteger endToken() {
            return this.endToken;
        }
    }
}

