/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.metrics.instance;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cassandra.sidecar.metrics.DeltaGauge;
import org.apache.cassandra.sidecar.metrics.NamedMetric;

public class StreamSSTableMetrics {
    public static final String DOMAIN = "Sidecar.CassInstance.StreamSSTable";
    protected final MetricRegistry metricRegistry;
    protected final Map<String, StreamSSTableComponentMetrics> streamComponentMetrics = new ConcurrentHashMap<String, StreamSSTableComponentMetrics>();
    public final NamedMetric<Meter> totalBytesStreamedRate;
    public final NamedMetric<DeltaGauge> throttled;

    public StreamSSTableMetrics(MetricRegistry metricRegistry) {
        this.metricRegistry = Objects.requireNonNull(metricRegistry, "Metric registry can not be null");
        this.totalBytesStreamedRate = NamedMetric.builder(arg_0 -> ((MetricRegistry)metricRegistry).meter(arg_0)).withDomain(DOMAIN).withName("TotalBytesStreamedRate").build();
        this.throttled = NamedMetric.builder(name -> (DeltaGauge)metricRegistry.gauge(name, DeltaGauge::new)).withDomain(DOMAIN).withName("Throttled").build();
    }

    public StreamSSTableComponentMetrics forComponent(String component) {
        return this.streamComponentMetrics.computeIfAbsent(component, sstableComponent -> new StreamSSTableComponentMetrics(this.metricRegistry, (String)sstableComponent));
    }

    public static class StreamSSTableComponentMetrics {
        protected final MetricRegistry metricRegistry;
        public final String sstableComponent;
        public final NamedMetric<Meter> bytesStreamedRate;

        public StreamSSTableComponentMetrics(MetricRegistry metricRegistry, String sstableComponent) {
            this.metricRegistry = Objects.requireNonNull(metricRegistry, "Metric registry can not be null");
            this.sstableComponent = Objects.requireNonNull(sstableComponent, "SSTable component required for component specific metrics capture");
            if (sstableComponent.isEmpty()) {
                throw new IllegalArgumentException("SSTableComponent required for component specific metrics capture");
            }
            NamedMetric.Tag componentTag = NamedMetric.Tag.of("component", sstableComponent);
            this.bytesStreamedRate = NamedMetric.builder(arg_0 -> ((MetricRegistry)metricRegistry).meter(arg_0)).withDomain(StreamSSTableMetrics.DOMAIN).withName("BytesStreamedRate").addTag(componentTag).build();
        }
    }
}

