/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.metrics;

import com.codahale.metrics.MetricRegistry;
import org.apache.cassandra.sidecar.exceptions.CassandraUnavailableException;
import org.apache.cassandra.sidecar.exceptions.NoSuchCassandraInstanceException;
import org.apache.cassandra.sidecar.metrics.MetricRegistryFactory;
import org.apache.cassandra.sidecar.metrics.SidecarMetrics;
import org.apache.cassandra.sidecar.metrics.instance.InstanceMetrics;
import org.apache.cassandra.sidecar.metrics.server.ServerMetrics;
import org.apache.cassandra.sidecar.metrics.server.ServerMetricsImpl;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;
import org.jetbrains.annotations.NotNull;

public class SidecarMetricsImpl
implements SidecarMetrics {
    protected final MetricRegistryFactory registryFactory;
    protected final InstanceMetadataFetcher instanceMetadataFetcher;
    protected final ServerMetrics serverMetrics;

    public SidecarMetricsImpl(MetricRegistryFactory registryFactory, InstanceMetadataFetcher instanceMetadataFetcher) {
        this.registryFactory = registryFactory;
        this.instanceMetadataFetcher = instanceMetadataFetcher;
        MetricRegistry globalMetricRegistry = registryFactory.getOrCreate();
        this.serverMetrics = new ServerMetricsImpl(globalMetricRegistry);
    }

    @Override
    public ServerMetrics server() {
        return this.serverMetrics;
    }

    @Override
    public InstanceMetrics instance(int instanceId) {
        return this.instanceMetadataFetcher.instance(instanceId).metrics();
    }

    @Override
    public InstanceMetrics instance(@NotNull String host) throws NoSuchCassandraInstanceException, CassandraUnavailableException {
        return this.instanceMetadataFetcher.instance(host).metrics();
    }
}

