/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.exceptions;

import org.apache.cassandra.sidecar.db.RestoreRange;
import org.apache.cassandra.sidecar.exceptions.RestoreJobException;
import org.apache.cassandra.sidecar.exceptions.RestoreJobFatalException;
import org.jetbrains.annotations.Nullable;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;

public class RestoreJobExceptions {
    private RestoreJobExceptions() {
    }

    public static RestoreJobException propagate(Throwable cause) {
        return RestoreJobExceptions.propagate(null, cause);
    }

    public static RestoreJobException propagate(@Nullable String message, Throwable cause) {
        String concatMessage = message;
        if (cause.getMessage() != null) {
            String string = concatMessage = concatMessage == null ? cause.getMessage() : concatMessage + ":" + cause.getMessage();
        }
        if (cause instanceof RestoreJobException) {
            RestoreJobException ex = (RestoreJobException)cause;
            return ex.retryable() ? new RestoreJobException(concatMessage, cause) : new RestoreJobFatalException(concatMessage, cause);
        }
        return new RestoreJobException(concatMessage, cause);
    }

    public static RestoreJobFatalException toFatal(Throwable cause) {
        if (cause instanceof RestoreJobFatalException) {
            return (RestoreJobFatalException)cause;
        }
        return new RestoreJobFatalException(cause.getMessage(), cause);
    }

    public static RestoreJobException of(String title, RestoreRange range, Throwable cause) {
        return new RestoreJobException(title + ". " + range.shortDescription(), cause);
    }

    public static RestoreJobException of(String title, RestoreRange range, AwsErrorDetails awsErrorDetails, Throwable cause) {
        return new RestoreJobException(title + ". " + range.shortDescription() + RestoreJobExceptions.toString(awsErrorDetails), cause);
    }

    public static RestoreJobFatalException ofFatal(String title, RestoreRange range, Throwable cause) {
        return new RestoreJobFatalException(title + ". " + range.shortDescription(), cause);
    }

    public static RestoreJobFatalException ofFatal(String title, RestoreRange range, AwsErrorDetails awsErrorDetails, Throwable cause) {
        return new RestoreJobFatalException(title + ". " + range.shortDescription() + RestoreJobExceptions.toString(awsErrorDetails), cause);
    }

    private static String toString(Object obj) {
        return obj == null ? "" : " " + obj;
    }
}

