/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.settings;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.PlainTextAuthProvider;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.ProtocolVersion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.stress.settings.ConnectionAPI;
import org.apache.cassandra.stress.settings.ConnectionStyle;
import org.apache.cassandra.stress.settings.GroupedOptions;
import org.apache.cassandra.stress.settings.Option;
import org.apache.cassandra.stress.settings.OptionSimple;
import org.apache.cassandra.stress.settings.SettingsCredentials;
import org.apache.cassandra.stress.util.ResultLogger;

public class SettingsMode
implements Serializable {
    public final ConnectionAPI api;
    public final ConnectionStyle style;
    public final ProtocolVersion protocolVersion;
    public final String username;
    public final String password;
    public final String authProviderClassname;
    public final AuthProvider authProvider;
    public final Integer maxPendingPerConnection;
    public final Integer connectionsPerHost;
    private final String compression;

    public SettingsMode(GroupedOptions options, SettingsCredentials credentials) {
        Cql3Options opts = (Cql3Options)options;
        if (opts.simplenative.setByUser()) {
            this.protocolVersion = ProtocolVersion.NEWEST_SUPPORTED;
            this.api = ConnectionAPI.SIMPLE_NATIVE;
            this.style = opts.usePrepared.setByUser() ? ConnectionStyle.CQL_PREPARED : ConnectionStyle.CQL;
            this.compression = ProtocolOptions.Compression.NONE.name();
            this.username = null;
            this.password = null;
            this.authProvider = null;
            this.authProviderClassname = null;
            this.maxPendingPerConnection = null;
            this.connectionsPerHost = null;
        } else {
            this.protocolVersion = "NEWEST_SUPPORTED".equals(opts.protocolVersion.value()) ? ProtocolVersion.NEWEST_SUPPORTED : ProtocolVersion.fromInt((int)Integer.parseInt(opts.protocolVersion.value()));
            this.api = ConnectionAPI.JAVA_DRIVER_NATIVE;
            this.style = opts.useUnPrepared.setByUser() ? ConnectionStyle.CQL : ConnectionStyle.CQL_PREPARED;
            this.compression = ProtocolOptions.Compression.valueOf((String)opts.useCompression.value().toUpperCase()).name();
            this.username = opts.user.setByUser() ? opts.user.value() : credentials.cqlUsername;
            this.password = opts.password.setByUser() ? opts.password.value() : credentials.cqlPassword;
            this.maxPendingPerConnection = opts.maxPendingPerConnection.value().isEmpty() ? null : Integer.valueOf(opts.maxPendingPerConnection.value());
            this.connectionsPerHost = opts.connectionsPerHost.value().isEmpty() ? null : Integer.valueOf(opts.connectionsPerHost.value());
            this.authProviderClassname = opts.authProvider.value();
            if (this.authProviderClassname != null) {
                try {
                    Class<?> clazz = Class.forName(this.authProviderClassname);
                    if (!AuthProvider.class.isAssignableFrom(clazz)) {
                        throw new IllegalArgumentException(clazz + " is not a valid auth provider");
                    }
                    if (PlainTextAuthProvider.class.equals(clazz)) {
                        this.authProvider = (AuthProvider)clazz.getConstructor(String.class, String.class).newInstance(this.username, this.password);
                    }
                    this.authProvider = (AuthProvider)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid auth provider class: " + opts.authProvider.value(), e);
                }
            } else {
                this.authProvider = null;
            }
        }
    }

    public ProtocolOptions.Compression compression() {
        return ProtocolOptions.Compression.valueOf((String)this.compression);
    }

    public void printSettings(ResultLogger out) {
        out.printf("  API: %s%n", new Object[]{this.api});
        out.printf("  Connection Style: %s%n", new Object[]{this.style});
        out.printf("  Protocol Version: %s%n", this.protocolVersion);
        out.printf("  Username: %s%n", this.username);
        out.printf("  Password: %s%n", this.password == null ? this.password : "*suppressed*");
        out.printf("  Auth Provide Class: %s%n", this.authProviderClassname);
        out.printf("  Max Pending Per Connection: %d%n", this.maxPendingPerConnection);
        out.printf("  Connections Per Host: %d%n", this.connectionsPerHost);
        out.printf("  Compression: %s%n", this.compression);
    }

    public static SettingsMode get(Map<String, String[]> clArgs, SettingsCredentials credentials) {
        String[] params = clArgs.remove("-mode");
        ArrayList<String> paramList = new ArrayList<String>();
        if (params == null) {
            Cql3Options opts = new Cql3Options();
            opts.accept("prepared");
            return new SettingsMode(opts, credentials);
        }
        for (String item : params) {
            if (item.equals("cql3") || item.equals("native")) {
                System.err.println("Warning: ignoring deprecated parameter: " + item);
                continue;
            }
            paramList.add(item);
        }
        if (paramList.contains("prepared") && paramList.contains("unprepared")) {
            System.err.println("Warning: can't specify both prepared and unprepared, using prepared");
            paramList.remove("unprepared");
        }
        String[] updated = paramList.toArray(new String[paramList.size()]);
        Cql3Options options = new Cql3Options();
        GroupedOptions.select((String[])updated, (GroupedOptions[])new GroupedOptions[]{options});
        return new SettingsMode(options, credentials);
    }

    public static void printHelp() {
        GroupedOptions.printOptions(System.out, "-mode", new Cql3Options());
    }

    public static Runnable helpPrinter() {
        return new Runnable(){

            @Override
            public void run() {
                SettingsMode.printHelp();
            }
        };
    }

    private static class Cql3Options
    extends GroupedOptions {
        final OptionSimple protocolVersion = new OptionSimple("protocolVersion=", "[2-5]+", "NEWEST_SUPPORTED", "CQL Protocol Version", false);
        final OptionSimple usePrepared = new OptionSimple("prepared", "", null, "Use prepared statements", false);
        final OptionSimple useUnPrepared = new OptionSimple("unprepared", "", null, "Use unprepared statements", false);
        final OptionSimple useCompression = new OptionSimple("compression=", "none|lz4|snappy", "none", "", false);
        final OptionSimple port = new OptionSimple("port=", "[0-9]+", "9046", "", false);
        final OptionSimple user = new OptionSimple("user=", ".+", null, String.format("CQL user, when specified, it will override the value in credentials file for key '%s'", "cql.username"), false);
        final OptionSimple password = new OptionSimple("password=", ".+", null, String.format("CQL password, when specified, it will override the value in credentials file for key '%s'", "cql.password"), false);
        final OptionSimple authProvider = new OptionSimple("auth-provider=", ".*", null, "Fully qualified implementation of com.datastax.driver.core.AuthProvider", false);
        final OptionSimple maxPendingPerConnection = new OptionSimple("maxPending=", "[0-9]+", "128", "Maximum pending requests per connection", false);
        final OptionSimple connectionsPerHost = new OptionSimple("connectionsPerHost=", "[0-9]+", "8", "Number of connections per host", false);
        final OptionSimple simplenative = new OptionSimple("simplenative", "", null, "", false);

        private Cql3Options() {
        }

        @Override
        public List<? extends Option> options() {
            return Arrays.asList(this.user, this.password, this.port, this.authProvider, this.maxPendingPerConnection, this.useCompression, this.connectionsPerHost, this.usePrepared, this.useUnPrepared, this.protocolVersion, this.simplenative);
        }
    }
}

