/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.util.VectorUtil;

public enum VectorSimilarityFunction {
    EUCLIDEAN{

        @Override
        public float compare(float[] v1, float[] v2) {
            return 1.0f / (1.0f + VectorUtil.squareDistance(v1, v2));
        }

        @Override
        public float compare(byte[] v1, byte[] v2) {
            return 1.0f / (1.0f + (float)VectorUtil.squareDistance(v1, v2));
        }
    }
    ,
    DOT_PRODUCT{

        @Override
        public float compare(float[] v1, float[] v2) {
            return (1.0f + VectorUtil.dotProduct(v1, v2)) / 2.0f;
        }

        @Override
        public float compare(byte[] v1, byte[] v2) {
            return VectorUtil.dotProductScore(v1, v2);
        }
    }
    ,
    COSINE{

        @Override
        public float compare(float[] v1, float[] v2) {
            return (1.0f + VectorUtil.cosine(v1, v2)) / 2.0f;
        }

        @Override
        public float compare(byte[] v1, byte[] v2) {
            return (1.0f + VectorUtil.cosine(v1, v2)) / 2.0f;
        }
    };


    public abstract float compare(float[] var1, float[] var2);

    public abstract float compare(byte[] var1, byte[] var2);
}

