/*
 * Decompiled with CFR 0.152.
 */
package ch.obermuhlner.math.big.stream;

import ch.obermuhlner.math.big.BigFloat;
import java.util.Comparator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class BigFloatStream {
    public static Stream<BigFloat> range(BigFloat startInclusive, BigFloat endExclusive, BigFloat step) {
        if (step.isZero()) {
            throw new IllegalArgumentException("invalid step: 0");
        }
        if (endExclusive.subtract(startInclusive).signum() != step.signum()) {
            return Stream.empty();
        }
        return StreamSupport.stream(new BigFloatSpliterator(startInclusive, endExclusive, false, step), false);
    }

    public static Stream<BigFloat> range(long startInclusive, long endExclusive, long step, BigFloat.Context context) {
        return BigFloatStream.range(context.valueOf(startInclusive), context.valueOf(endExclusive), context.valueOf(step));
    }

    public static Stream<BigFloat> range(double startInclusive, double endExclusive, double step, BigFloat.Context context) {
        return BigFloatStream.range(context.valueOf(startInclusive), context.valueOf(endExclusive), context.valueOf(step));
    }

    public static Stream<BigFloat> rangeClosed(BigFloat startInclusive, BigFloat endInclusive, BigFloat step) {
        if (step.isZero()) {
            throw new IllegalArgumentException("invalid step: 0");
        }
        if (endInclusive.subtract(startInclusive).signum() == -step.signum()) {
            return Stream.empty();
        }
        return StreamSupport.stream(new BigFloatSpliterator(startInclusive, endInclusive, true, step), false);
    }

    public static Stream<BigFloat> rangeClosed(long startInclusive, long endInclusive, long step, BigFloat.Context context) {
        return BigFloatStream.rangeClosed(context.valueOf(startInclusive), context.valueOf(endInclusive), context.valueOf(step));
    }

    public static Stream<BigFloat> rangeClosed(double startInclusive, double endInclusive, double step, BigFloat.Context context) {
        return BigFloatStream.rangeClosed(context.valueOf(startInclusive), context.valueOf(endInclusive), context.valueOf(step));
    }

    private static class BigFloatSpliterator
    extends Spliterators.AbstractSpliterator<BigFloat> {
        private BigFloat value;
        private BigFloat step;
        private long count;

        public BigFloatSpliterator(BigFloat startInclusive, BigFloat step, long count) {
            super(count, 17749);
            this.value = startInclusive;
            this.step = step;
            this.count = count;
        }

        public BigFloatSpliterator(BigFloat startInclusive, BigFloat end, boolean inclusive, BigFloat step) {
            this(startInclusive, step, BigFloatSpliterator.estimatedCount(startInclusive, end, inclusive, step));
        }

        private static long estimatedCount(BigFloat startInclusive, BigFloat end, boolean inclusive, BigFloat step) {
            BigFloat count = end.subtract(startInclusive).divide(step);
            long result = count.toLong();
            if (count.getFractionalPart().signum() != 0) {
                ++result;
            } else if (inclusive) {
                ++result;
            }
            return result;
        }

        @Override
        public Comparator<? super BigFloat> getComparator() {
            if (this.step.signum() < 0) {
                return Comparator.reverseOrder();
            }
            return null;
        }

        @Override
        public boolean tryAdvance(Consumer<? super BigFloat> action) {
            if (this.count == 0L) {
                return false;
            }
            action.accept(this.value);
            this.value = this.value.add(this.step);
            --this.count;
            return true;
        }

        @Override
        public void forEachRemaining(Consumer<? super BigFloat> action) {
            while (this.count > 0L) {
                action.accept(this.value);
                this.value = this.value.add(this.step);
                --this.count;
            }
        }

        @Override
        public Spliterator<BigFloat> trySplit() {
            long firstHalfCount = this.count / 2L;
            if (firstHalfCount == 0L) {
                return null;
            }
            long secondHalfCount = this.count - firstHalfCount;
            this.count = firstHalfCount;
            BigFloat startSecondHalf = this.value.add(this.step.multiply(firstHalfCount));
            return new BigFloatSpliterator(startSecondHalf, this.step, secondHalfCount);
        }
    }
}

