/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.vector;

import java.util.function.Function;

public enum OptimizeFor {
    LATENCY(limit -> 0.979 + 4.021 * Math.pow(limit.intValue(), -0.761)),
    RECALL(limit -> 0.509 + 9.491 * Math.pow(limit.intValue(), -0.402));

    private final Function<Integer, Double> limitMultiplier;

    private OptimizeFor(Function<Integer, Double> limitMultiplier) {
        this.limitMultiplier = limitMultiplier;
    }

    public int topKFor(int limit) {
        return (int)(this.limitMultiplier.apply(limit) * (double)limit);
    }

    public static OptimizeFor fromString(String value) {
        return OptimizeFor.valueOf(value.toUpperCase());
    }
}

