/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.ConfigurationLoader;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.ForwardingProperty;
import org.apache.cassandra.config.InheritingClass;
import org.apache.cassandra.config.Loader;
import org.apache.cassandra.config.ParameterizedClass;
import org.apache.cassandra.config.Properties;
import org.apache.cassandra.config.Replacement;
import org.apache.cassandra.config.Replacements;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.io.util.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.composer.Composer;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.CustomClassLoaderConstructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.introspector.MissingProperty;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.introspector.PropertyUtils;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.parser.Parser;
import org.yaml.snakeyaml.parser.ParserImpl;
import org.yaml.snakeyaml.resolver.Resolver;

public class YamlConfigurationLoader
implements ConfigurationLoader {
    private static final Logger logger = LoggerFactory.getLogger(YamlConfigurationLoader.class);
    static final String SYSTEM_PROPERTY_PREFIX = "cassandra.settings.";
    private static URL storageConfigURL;

    private static URL getStorageConfigURL() throws ConfigurationException {
        URL url;
        block3: {
            String configUrl = CassandraRelevantProperties.CASSANDRA_CONFIG.getString();
            try {
                url = new URL(configUrl);
                url.openStream().close();
            }
            catch (Exception e) {
                ClassLoader loader = DatabaseDescriptor.class.getClassLoader();
                url = loader.getResource(configUrl);
                if (url != null) break block3;
                String required = "file:" + File.pathSeparator() + File.pathSeparator();
                if (!configUrl.startsWith(required)) {
                    throw new ConfigurationException(String.format("Expecting URI in variable: [cassandra.config]. Found[%s]. Please prefix the file with [%s%s] for local files and [%s<server>%s] for remote files. If you are executing this from an external tool, it needs to set Config.setClientMode(true) to avoid loading configuration.", configUrl, required, File.pathSeparator(), required, File.pathSeparator()));
                }
                throw new ConfigurationException("Cannot locate " + configUrl + ".  If this is a local file, please confirm you've provided " + required + File.pathSeparator() + " as a URI prefix.");
            }
        }
        logger.info("Configuration location: {}", (Object)url);
        return url;
    }

    @Override
    public Config loadConfig() throws ConfigurationException {
        if (storageConfigURL == null) {
            storageConfigURL = YamlConfigurationLoader.getStorageConfigURL();
        }
        return this.loadConfig(storageConfigURL);
    }

    public Config loadConfig(URL url) throws ConfigurationException {
        try {
            byte[] configBytes;
            logger.debug("Loading settings from {}", (Object)url);
            try (InputStream is = url.openStream();){
                configBytes = ByteStreams.toByteArray((InputStream)is);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            CustomConstructor constructor = new CustomConstructor(Config.class, Yaml.class.getClassLoader());
            Map<Class<?>, Map<String, Replacement>> replacements = Replacements.getNameReplacements(Config.class);
            YamlConfigurationLoader.verifyReplacements(replacements, configBytes);
            PropertiesChecker propertiesChecker = new PropertiesChecker(replacements);
            constructor.setPropertyUtils(propertiesChecker);
            Yaml yaml = new Yaml((BaseConstructor)constructor);
            Config result = YamlConfigurationLoader.loadConfig(yaml, configBytes);
            propertiesChecker.check();
            YamlConfigurationLoader.maybeAddSystemProperties(result);
            return result;
        }
        catch (YAMLException e) {
            throw new ConfigurationException("Invalid yaml: " + url, e);
        }
    }

    private static void maybeAddSystemProperties(Object obj) {
        if (CassandraRelevantProperties.CONFIG_ALLOW_SYSTEM_PROPERTIES.getBoolean()) {
            java.util.Properties props = System.getProperties();
            HashMap<String, String> map = new HashMap<String, String>();
            for (String name : props.stringPropertyNames()) {
                String value;
                if (!name.startsWith(SYSTEM_PROPERTY_PREFIX) || (value = props.getProperty(name)) == null) continue;
                map.put(name.replace(SYSTEM_PROPERTY_PREFIX, ""), value);
            }
            if (!map.isEmpty()) {
                YamlConfigurationLoader.updateFromMap(map, false, obj);
            }
        }
    }

    private static void verifyReplacements(Map<Class<?>, Map<String, Replacement>> replacements, Map<String, ?> rawConfig) {
        ArrayList<String> duplicates = new ArrayList<String>();
        for (Map.Entry<Class<?>, Map<String, Replacement>> outerEntry : replacements.entrySet()) {
            for (Map.Entry<String, Replacement> entry : outerEntry.getValue().entrySet()) {
                Replacement r = entry.getValue();
                if (r.isValueFormatReplacement() || !rawConfig.containsKey(r.oldName) || !rawConfig.containsKey(r.newName)) continue;
                String msg = String.format("[%s -> %s]", r.oldName, r.newName);
                duplicates.add(msg);
            }
        }
        if (!duplicates.isEmpty()) {
            String msg = String.format("Config contains both old and new keys for the same configuration parameters, migrate old -> new: %s", String.join((CharSequence)", ", duplicates));
            if (!CassandraRelevantProperties.ALLOW_NEW_OLD_CONFIG_KEYS.getBoolean()) {
                throw new ConfigurationException(msg);
            }
            logger.warn(msg);
        }
    }

    private static void verifyReplacements(Map<Class<?>, Map<String, Replacement>> replacements, byte[] configBytes) {
        LoaderOptions loaderOptions = YamlConfigurationLoader.getDefaultLoaderOptions();
        loaderOptions.setAllowDuplicateKeys(CassandraRelevantProperties.ALLOW_DUPLICATE_CONFIG_KEYS.getBoolean());
        Yaml rawYaml = new Yaml(loaderOptions);
        HashMap rawConfig = (HashMap)rawYaml.load((InputStream)new ByteArrayInputStream(configBytes));
        if (rawConfig == null) {
            rawConfig = new HashMap();
        }
        YamlConfigurationLoader.verifyReplacements(replacements, rawConfig);
    }

    @VisibleForTesting
    public static <T> T fromMap(Map<String, Object> map, Class<T> klass) {
        return YamlConfigurationLoader.fromMap(map, true, klass);
    }

    public static <T> T fromMap(Map<String, Object> map, boolean shouldCheck, Class<T> klass) {
        CustomConstructor constructor = new CustomConstructor(klass, klass.getClassLoader());
        Map<Class<?>, Map<String, Replacement>> replacements = Replacements.getNameReplacements(Config.class);
        YamlConfigurationLoader.verifyReplacements(replacements, map);
        PropertiesChecker propertiesChecker = new PropertiesChecker(replacements);
        constructor.setPropertyUtils(propertiesChecker);
        Yaml yaml = new Yaml((BaseConstructor)constructor);
        Node node = yaml.represent(map);
        constructor.setComposer(YamlConfigurationLoader.getDefaultComposer(node));
        Object value = constructor.getSingleData(klass);
        if (shouldCheck) {
            propertiesChecker.check();
        }
        YamlConfigurationLoader.maybeAddSystemProperties(value);
        return (T)value;
    }

    public static <T> T updateFromMap(Map<String, ?> map, boolean shouldCheck, final T obj) {
        Class<?> klass = obj.getClass();
        CustomConstructor constructor = new CustomConstructor(klass, klass.getClassLoader()){

            protected Object newInstance(Node node) {
                if (node.getType() == obj.getClass()) {
                    return obj;
                }
                return super.newInstance(node);
            }
        };
        Map<Class<?>, Map<String, Replacement>> replacements = Replacements.getNameReplacements(Config.class);
        YamlConfigurationLoader.verifyReplacements(replacements, map);
        PropertiesChecker propertiesChecker = new PropertiesChecker(replacements);
        constructor.setPropertyUtils(propertiesChecker);
        Yaml yaml = new Yaml((BaseConstructor)constructor);
        Node node = yaml.represent(map);
        constructor.setComposer(YamlConfigurationLoader.getDefaultComposer(node));
        Object value = constructor.getSingleData(klass);
        if (shouldCheck) {
            propertiesChecker.check();
        }
        return (T)value;
    }

    private static Composer getDefaultComposer(final Node node) {
        return new Composer((Parser)new ParserImpl(null), new Resolver(), YamlConfigurationLoader.getDefaultLoaderOptions()){

            public Node getSingleNode() {
                return node;
            }
        };
    }

    private static Config loadConfig(Yaml yaml, byte[] configBytes) {
        Config config = (Config)yaml.loadAs((InputStream)new ByteArrayInputStream(configBytes), Config.class);
        return config == null ? new Config() : config;
    }

    public static LoaderOptions getDefaultLoaderOptions() {
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setCodePointLimit(0x4000000);
        return loaderOptions;
    }

    @VisibleForTesting
    private static class PropertiesChecker
    extends PropertyUtils {
        private final Loader loader = Properties.defaultLoader();
        private final Set<String> missingProperties = new HashSet<String>();
        private final Set<String> nullProperties = new HashSet<String>();
        private final Set<String> deprecationWarnings = new HashSet<String>();
        private final Map<Class<?>, Map<String, Replacement>> replacements;

        PropertiesChecker(Map<Class<?>, Map<String, Replacement>> replacements) {
            this.replacements = Objects.requireNonNull(replacements, "Replacements should not be null");
            this.setSkipMissingProperties(true);
        }

        public Property getProperty(Class<?> type, String name) {
            Property result;
            Map typeReplacements = this.replacements.getOrDefault(type, Collections.emptyMap());
            if (typeReplacements.containsKey(name)) {
                Replacement replacement = (Replacement)typeReplacements.get(name);
                result = replacement.toProperty(this.getProperty0(type, replacement.newName));
                if (replacement.deprecated) {
                    this.deprecationWarnings.add(replacement.oldName);
                }
            } else {
                result = this.getProperty0(type, name);
            }
            if (result instanceof MissingProperty) {
                this.missingProperties.add(result.getName());
            } else if (result.getAnnotation(Deprecated.class) != null) {
                this.deprecationWarnings.add(result.getName());
            }
            return new ForwardingProperty(result.getName(), result){
                boolean allowsNull;
                {
                    super(name, property);
                    this.allowsNull = result.getAnnotation(Nullable.class) != null;
                }

                @Override
                public void set(Object object, Object value) throws Exception {
                    if (value == null && this.get(object) != null && !this.allowsNull) {
                        nullProperties.add(this.getName());
                    }
                    result.set(object, value);
                }

                @Override
                public Object get(Object object) {
                    return result.get(object);
                }
            };
        }

        private Property getProperty0(Class<? extends Object> type, String name) {
            if (name.contains(".")) {
                return this.getNestedProperty(type, name);
            }
            return this.getFlatProperty(type, name);
        }

        private Property getFlatProperty(Class<?> type, String name) {
            Property prop = this.loader.getProperties(type).get(name);
            return prop == null ? new MissingProperty(name) : prop;
        }

        private Property getNestedProperty(Class<?> type, String name) {
            MissingProperty root = null;
            for (String s : name.split("\\.")) {
                Property prop = this.getFlatProperty(type, s);
                if (prop instanceof MissingProperty) {
                    root = null;
                    break;
                }
                root = root == null ? prop : Properties.andThen((Property)root, prop);
                type = root.getType();
            }
            return root != null ? root : new MissingProperty(name);
        }

        public void check() throws ConfigurationException {
            if (!this.nullProperties.isEmpty()) {
                throw new ConfigurationException("Invalid yaml. Those properties " + this.nullProperties + " are not valid", false);
            }
            if (!this.missingProperties.isEmpty()) {
                throw new ConfigurationException("Invalid yaml. Please remove properties " + this.missingProperties + " from your cassandra.yaml", false);
            }
            if (!this.deprecationWarnings.isEmpty()) {
                logger.warn("{} parameters have been deprecated. They have new names and/or value format; For more information, please refer to NEWS.txt", this.deprecationWarnings);
            }
        }
    }

    @VisibleForTesting
    static class CustomConstructor
    extends CustomClassLoaderConstructor {
        CustomConstructor(Class<?> theRoot, ClassLoader classLoader) {
            super(theRoot, classLoader, YamlConfigurationLoader.getDefaultLoaderOptions());
            TypeDescription seedDesc = new TypeDescription(ParameterizedClass.class);
            seedDesc.putMapPropertyType("parameters", String.class, String.class);
            this.addTypeDescription(seedDesc);
            TypeDescription memtableDesc = new TypeDescription(Config.MemtableOptions.class);
            memtableDesc.addPropertyParameters("configurations", new Class[]{String.class, InheritingClass.class});
            this.addTypeDescription(memtableDesc);
        }

        protected List<Object> createDefaultList(int initSize) {
            return Lists.newCopyOnWriteArrayList();
        }

        protected Map<Object, Object> createDefaultMap(int initSize) {
            return Maps.newConcurrentMap();
        }

        protected Set<Object> createDefaultSet(int initSize) {
            return Sets.newConcurrentHashSet();
        }
    }
}

