/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.stress.StressAction;
import org.apache.cassandra.stress.StressGraph;
import org.apache.cassandra.stress.settings.StressSettings;
import org.apache.cassandra.stress.util.MultiResultLogger;
import org.apache.commons.lang3.exception.ExceptionUtils;

public final class Stress {
    public static void main(String[] arguments) throws Exception {
        System.exit(Stress.run(arguments));
    }

    private static int run(String[] arguments) {
        try {
            StressSettings settings;
            DatabaseDescriptor.clientInitialization();
            try {
                settings = StressSettings.parse(arguments);
                if (settings == null) {
                    return 0;
                }
            }
            catch (IllegalArgumentException e) {
                System.out.printf("%s%n", e.getMessage());
                Stress.printHelpMessage();
                return 1;
            }
            catch (Throwable e) {
                Throwable rc = ExceptionUtils.getRootCause((Throwable)e);
                if (rc instanceof FileNotFoundException) {
                    System.out.printf("File '%s' doesn't exist!%n", rc.getMessage());
                    Stress.printHelpMessage();
                    return 1;
                }
                throw e;
            }
            MultiResultLogger logout = settings.log.getOutput();
            if (!settings.log.noSettings) {
                settings.printSettings(logout);
            }
            if (settings.graph.inGraphMode()) {
                logout.addStream(new PrintStream(settings.graph.temporaryLogFile));
            }
            StressAction stressAction = new StressAction(settings, logout);
            stressAction.run();
            logout.flush();
            if (settings.graph.inGraphMode()) {
                new StressGraph(settings, arguments).generateGraph();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            return 1;
        }
        return 0;
    }

    public static void printHelpMessage() {
        StressSettings.printHelp();
    }
}

