/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// RegistrySpecApplyConfiguration represents a declarative configuration of the RegistrySpec type for use
// with apply.
type RegistrySpecApplyConfiguration struct {
	Insecure     *bool   `json:"insecure,omitempty"`
	Address      *string `json:"address,omitempty"`
	Secret       *string `json:"secret,omitempty"`
	CA           *string `json:"ca,omitempty"`
	Organization *string `json:"organization,omitempty"`
}

// RegistrySpecApplyConfiguration constructs a declarative configuration of the RegistrySpec type for use with
// apply.
func RegistrySpec() *RegistrySpecApplyConfiguration {
	return &RegistrySpecApplyConfiguration{}
}

// WithInsecure sets the Insecure field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Insecure field is set to the value of the last call.
func (b *RegistrySpecApplyConfiguration) WithInsecure(value bool) *RegistrySpecApplyConfiguration {
	b.Insecure = &value
	return b
}

// WithAddress sets the Address field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Address field is set to the value of the last call.
func (b *RegistrySpecApplyConfiguration) WithAddress(value string) *RegistrySpecApplyConfiguration {
	b.Address = &value
	return b
}

// WithSecret sets the Secret field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Secret field is set to the value of the last call.
func (b *RegistrySpecApplyConfiguration) WithSecret(value string) *RegistrySpecApplyConfiguration {
	b.Secret = &value
	return b
}

// WithCA sets the CA field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the CA field is set to the value of the last call.
func (b *RegistrySpecApplyConfiguration) WithCA(value string) *RegistrySpecApplyConfiguration {
	b.CA = &value
	return b
}

// WithOrganization sets the Organization field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Organization field is set to the value of the last call.
func (b *RegistrySpecApplyConfiguration) WithOrganization(value string) *RegistrySpecApplyConfiguration {
	b.Organization = &value
	return b
}
