/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.processing.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws2.s3vectors.AWS2S3VectorsComponent;

/**
 * Store and query vector embeddings using AWS S3 Vectors with similarity
 * search.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface Aws2S3VectorsComponentBuilderFactory {

    /**
     * AWS S3 Vectors (camel-aws2-s3-vectors)
     * Store and query vector embeddings using AWS S3 Vectors with similarity
     * search.
     * 
     * Category: cloud,ai
     * Since: 4.17
     * Maven coordinates: org.apache.camel:camel-aws2-s3-vectors
     * 
     * @return the dsl builder
     */
    static Aws2S3VectorsComponentBuilder aws2S3Vectors() {
        return new Aws2S3VectorsComponentBuilderImpl();
    }

    /**
     * Builder for the AWS S3 Vectors component.
     */
    interface Aws2S3VectorsComponentBuilder extends ComponentBuilder<AWS2S3VectorsComponent> {
    
        /**
         * The component configuration.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.aws2.s3vectors.AWS2S3VectorsConfiguration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default Aws2S3VectorsComponentBuilder configuration(org.apache.camel.component.aws2.s3vectors.AWS2S3VectorsConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
    
        
        /**
         * The data type of the vector. Options: float32, float16.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: float32
         * Group: common
         * 
         * @param dataType the value to set
         * @return the dsl builder
         */
        default Aws2S3VectorsComponentBuilder dataType(java.lang.String dataType) {
            doSetProperty("dataType", dataType);
            return this;
        }
    
        
        /**
         * The distance metric to use for similarity search. Options: cosine,
         * euclidean, dot-product.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: cosine
         * Group: common
         * 
         * @param distanceMetric the value to set
         * @return the dsl builder
         */
        default Aws2S3VectorsComponentBuilder distanceMetric(java.lang.String distanceMetric) {
            doSetProperty("distanceMetric", distanceMetric);
            return this;
        }
    
        
        /**
         * Set the need for overriding the endpoint. This option needs to be
         * used in combination with uriEndpointOverride option.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param overrideEndpoint the value to set
         * @return the dsl builder
         */
        default Aws2S3VectorsComponentBuilder overrideEndpoint(boolean overrideEndpoint) {
            doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }
    
        /**
         * The region in which S3 Vectors client needs to work. When using this
         * parameter, the configuration will expect the lowercase name of the
         * region (for example ap-east-1).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param region the value to set
         * @return the dsl builder
         */
        default Aws2S3VectorsComponentBuilder region(java.lang.String region) {
            doSetProperty("region", region);
            return this;
        }
    
        /**
         * The minimum similarity threshold for results.
         * 
         * The option is a: &lt;code&gt;java.lang.Float&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param similarityThreshold the value to set
         * @return the dsl builder
         */
        default Aws2S3VectorsComponentBuilder similarityThreshold(java.lang.Float similarityThreshold) {
            doSetProperty("similarityThreshold", similarityThreshold);
            return this;
        }
    
        
        /**
         * The number of top similar vectors to return in a query.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 10
         * Group: common
         * 
         * @param topK the value to set
         * @return the dsl builder
         */
        default Aws2S3VectorsComponentBuilder topK(java.lang.Integer topK) {
            doSetProperty("topK", topK);
            return this;
        }
    
        /**
         * Set the overriding uri endpoint. This option needs to be used in
         * combination with overrideEndpoint option.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param uriEndpointOverride the value to set
         * @return the dsl builder
         */
        default Aws2S3VectorsComponentBuilder uriEndpointOverride(java.lang.String uriEndpointOverride) {
            doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }
    
        
        /**
         * The dimensions of the vector embeddings (default: 1536, which is the
         * dimension for OpenAI text-embedding-3-small).
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 1536
         * Group: common
         * 
         * @param vectorDimensions the value to set
         * @return the dsl builder
         */
        default Aws2S3VectorsComponentBuilder vectorDimensions(java.lang.Integer vectorDimensions) {
            doSetProperty("vectorDimensions", vectorDimensions);
            return this;
        }
    
        /**
         * The name of the vector index.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param vectorIndexName the value to set
         * @return the dsl builder
         */
        default Aws2S3VectorsComponentBuilder vectorIndexName(java.lang.String vectorIndexName) {
            doSetProperty("vectorIndexName", vectorIndexName);
            return this;
        }
    
        
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default Aws2S3VectorsComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
    
        /**
         * Optional metadata filter for the consumer to filter vectors during
         * polling.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param consumerMetadataFilter the value to set
         * @return the dsl builder
         */
        default Aws2S3VectorsComponentBuilder consumerMetadataFilter(java.lang.String consumerMetadataFilter) {
            doSetProperty("consumerMetadataFilter", consumerMetadataFilter);
            return this;
        }
    
        /**
         * The query vector to use for the consumer to poll for similar vectors.
         * Specified as comma-separated float values (e.g., 0.1,0.2,0.3). If not
         * specified, the consumer will not poll.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param consumerQueryVector the value to set
         * @return the dsl builder
         */
        default Aws2S3VectorsComponentBuilder consumerQueryVector(java.lang.String consumerQueryVector) {
            doSetProperty("consumerQueryVector", consumerQueryVector);
            return this;
        }
    
        
        /**
         * Milliseconds before the next poll for the consumer.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: consumer
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default Aws2S3VectorsComponentBuilder delay(long delay) {
            doSetProperty("delay", delay);
            return this;
        }
    
        
        /**
         * Delete vectors after they have been consumed.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param deleteAfterRead the value to set
         * @return the dsl builder
         */
        default Aws2S3VectorsComponentBuilder deleteAfterRead(boolean deleteAfterRead) {
            doSetProperty("deleteAfterRead", deleteAfterRead);
            return this;
        }
    
        
        /**
         * The maximum number of messages to consume per poll for the consumer.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10
         * Group: consumer
         * 
         * @param maxMessagesPerPoll the value to set
         * @return the dsl builder
         */
        default Aws2S3VectorsComponentBuilder maxMessagesPerPoll(int maxMessagesPerPoll) {
            doSetProperty("maxMessagesPerPoll", maxMessagesPerPoll);
            return this;
        }
    
        
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default Aws2S3VectorsComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    
        /**
         * The operation to perform.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.aws2.s3vectors.AWS2S3VectorsOperations&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default Aws2S3VectorsComponentBuilder operation(org.apache.camel.component.aws2.s3vectors.AWS2S3VectorsOperations operation) {
            doSetProperty("operation", operation);
            return this;
        }
    
        
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default Aws2S3VectorsComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    
        /**
         * Reference to a
         * software.amazon.awssdk.services.s3vectors.S3VectorsClient in the
         * registry.
         * 
         * The option is a:
         * &lt;code&gt;software.amazon.awssdk.services.s3vectors.S3VectorsClient&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param s3VectorsClient the value to set
         * @return the dsl builder
         */
        default Aws2S3VectorsComponentBuilder s3VectorsClient(software.amazon.awssdk.services.s3vectors.S3VectorsClient s3VectorsClient) {
            doSetProperty("s3VectorsClient", s3VectorsClient);
            return this;
        }
    
        
        /**
         * Used for enabling or disabling all consumer based health checks from
         * this component.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: health
         * 
         * @param healthCheckConsumerEnabled the value to set
         * @return the dsl builder
         */
        default Aws2S3VectorsComponentBuilder healthCheckConsumerEnabled(boolean healthCheckConsumerEnabled) {
            doSetProperty("healthCheckConsumerEnabled", healthCheckConsumerEnabled);
            return this;
        }
    
        
        /**
         * Used for enabling or disabling all producer based health checks from
         * this component. Notice: Camel has by default disabled all producer
         * based health-checks. You can turn on producer checks globally by
         * setting camel.health.producersEnabled=true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: health
         * 
         * @param healthCheckProducerEnabled the value to set
         * @return the dsl builder
         */
        default Aws2S3VectorsComponentBuilder healthCheckProducerEnabled(boolean healthCheckProducerEnabled) {
            doSetProperty("healthCheckProducerEnabled", healthCheckProducerEnabled);
            return this;
        }
    
        /**
         * To define a proxy host when instantiating the S3 Vectors client.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyHost the value to set
         * @return the dsl builder
         */
        default Aws2S3VectorsComponentBuilder proxyHost(java.lang.String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
    
        /**
         * To define a proxy port when instantiating the S3 Vectors client.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default Aws2S3VectorsComponentBuilder proxyPort(java.lang.Integer proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
    
        
        /**
         * To define a proxy protocol when instantiating the S3 Vectors client.
         * 
         * The option is a:
         * &lt;code&gt;software.amazon.awssdk.core.Protocol&lt;/code&gt; type.
         * 
         * Default: HTTPS
         * Group: proxy
         * 
         * @param proxyProtocol the value to set
         * @return the dsl builder
         */
        default Aws2S3VectorsComponentBuilder proxyProtocol(software.amazon.awssdk.core.Protocol proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
    
        /**
         * Amazon AWS Access Key.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default Aws2S3VectorsComponentBuilder accessKey(java.lang.String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
    
        /**
         * If using a profile credentials provider, this parameter will set the
         * profile name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param profileCredentialsName the value to set
         * @return the dsl builder
         */
        default Aws2S3VectorsComponentBuilder profileCredentialsName(java.lang.String profileCredentialsName) {
            doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }
    
        /**
         * Amazon AWS Secret Key.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param secretKey the value to set
         * @return the dsl builder
         */
        default Aws2S3VectorsComponentBuilder secretKey(java.lang.String secretKey) {
            doSetProperty("secretKey", secretKey);
            return this;
        }
    
        /**
         * Amazon AWS Session Token used when the user needs to assume an IAM
         * role.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sessionToken the value to set
         * @return the dsl builder
         */
        default Aws2S3VectorsComponentBuilder sessionToken(java.lang.String sessionToken) {
            doSetProperty("sessionToken", sessionToken);
            return this;
        }
    
        
        /**
         * If we want to trust all certificates in case of overriding the
         * endpoint.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param trustAllCertificates the value to set
         * @return the dsl builder
         */
        default Aws2S3VectorsComponentBuilder trustAllCertificates(boolean trustAllCertificates) {
            doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }
    
        
        /**
         * Set whether the S3 Vectors client should expect to load credentials
         * through a default credentials provider.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useDefaultCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Aws2S3VectorsComponentBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }
    
        
        /**
         * Set whether the S3 Vectors client should expect to load credentials
         * through a profile credentials provider.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useProfileCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Aws2S3VectorsComponentBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
    
        
        /**
         * Set whether the S3 Vectors client should expect to use Session
         * Credentials. This is useful in a situation in which the user needs to
         * assume an IAM role for doing operations in S3 Vectors.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useSessionCredentials the value to set
         * @return the dsl builder
         */
        default Aws2S3VectorsComponentBuilder useSessionCredentials(boolean useSessionCredentials) {
            doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
    }

    class Aws2S3VectorsComponentBuilderImpl
            extends AbstractComponentBuilder<AWS2S3VectorsComponent>
            implements Aws2S3VectorsComponentBuilder {
        @Override
        protected AWS2S3VectorsComponent buildConcreteComponent() {
            return new AWS2S3VectorsComponent();
        }
        private org.apache.camel.component.aws2.s3vectors.AWS2S3VectorsConfiguration getOrCreateConfiguration(AWS2S3VectorsComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new org.apache.camel.component.aws2.s3vectors.AWS2S3VectorsConfiguration());
            }
            return component.getConfiguration();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "configuration": ((AWS2S3VectorsComponent) component).setConfiguration((org.apache.camel.component.aws2.s3vectors.AWS2S3VectorsConfiguration) value); return true;
            case "dataType": getOrCreateConfiguration((AWS2S3VectorsComponent) component).setDataType((java.lang.String) value); return true;
            case "distanceMetric": getOrCreateConfiguration((AWS2S3VectorsComponent) component).setDistanceMetric((java.lang.String) value); return true;
            case "overrideEndpoint": getOrCreateConfiguration((AWS2S3VectorsComponent) component).setOverrideEndpoint((boolean) value); return true;
            case "region": getOrCreateConfiguration((AWS2S3VectorsComponent) component).setRegion((java.lang.String) value); return true;
            case "similarityThreshold": getOrCreateConfiguration((AWS2S3VectorsComponent) component).setSimilarityThreshold((java.lang.Float) value); return true;
            case "topK": getOrCreateConfiguration((AWS2S3VectorsComponent) component).setTopK((java.lang.Integer) value); return true;
            case "uriEndpointOverride": getOrCreateConfiguration((AWS2S3VectorsComponent) component).setUriEndpointOverride((java.lang.String) value); return true;
            case "vectorDimensions": getOrCreateConfiguration((AWS2S3VectorsComponent) component).setVectorDimensions((java.lang.Integer) value); return true;
            case "vectorIndexName": getOrCreateConfiguration((AWS2S3VectorsComponent) component).setVectorIndexName((java.lang.String) value); return true;
            case "bridgeErrorHandler": ((AWS2S3VectorsComponent) component).setBridgeErrorHandler((boolean) value); return true;
            case "consumerMetadataFilter": getOrCreateConfiguration((AWS2S3VectorsComponent) component).setConsumerMetadataFilter((java.lang.String) value); return true;
            case "consumerQueryVector": getOrCreateConfiguration((AWS2S3VectorsComponent) component).setConsumerQueryVector((java.lang.String) value); return true;
            case "delay": getOrCreateConfiguration((AWS2S3VectorsComponent) component).setDelay((long) value); return true;
            case "deleteAfterRead": getOrCreateConfiguration((AWS2S3VectorsComponent) component).setDeleteAfterRead((boolean) value); return true;
            case "maxMessagesPerPoll": getOrCreateConfiguration((AWS2S3VectorsComponent) component).setMaxMessagesPerPoll((int) value); return true;
            case "lazyStartProducer": ((AWS2S3VectorsComponent) component).setLazyStartProducer((boolean) value); return true;
            case "operation": getOrCreateConfiguration((AWS2S3VectorsComponent) component).setOperation((org.apache.camel.component.aws2.s3vectors.AWS2S3VectorsOperations) value); return true;
            case "autowiredEnabled": ((AWS2S3VectorsComponent) component).setAutowiredEnabled((boolean) value); return true;
            case "s3VectorsClient": getOrCreateConfiguration((AWS2S3VectorsComponent) component).setS3VectorsClient((software.amazon.awssdk.services.s3vectors.S3VectorsClient) value); return true;
            case "healthCheckConsumerEnabled": ((AWS2S3VectorsComponent) component).setHealthCheckConsumerEnabled((boolean) value); return true;
            case "healthCheckProducerEnabled": ((AWS2S3VectorsComponent) component).setHealthCheckProducerEnabled((boolean) value); return true;
            case "proxyHost": getOrCreateConfiguration((AWS2S3VectorsComponent) component).setProxyHost((java.lang.String) value); return true;
            case "proxyPort": getOrCreateConfiguration((AWS2S3VectorsComponent) component).setProxyPort((java.lang.Integer) value); return true;
            case "proxyProtocol": getOrCreateConfiguration((AWS2S3VectorsComponent) component).setProxyProtocol((software.amazon.awssdk.core.Protocol) value); return true;
            case "accessKey": getOrCreateConfiguration((AWS2S3VectorsComponent) component).setAccessKey((java.lang.String) value); return true;
            case "profileCredentialsName": getOrCreateConfiguration((AWS2S3VectorsComponent) component).setProfileCredentialsName((java.lang.String) value); return true;
            case "secretKey": getOrCreateConfiguration((AWS2S3VectorsComponent) component).setSecretKey((java.lang.String) value); return true;
            case "sessionToken": getOrCreateConfiguration((AWS2S3VectorsComponent) component).setSessionToken((java.lang.String) value); return true;
            case "trustAllCertificates": getOrCreateConfiguration((AWS2S3VectorsComponent) component).setTrustAllCertificates((boolean) value); return true;
            case "useDefaultCredentialsProvider": getOrCreateConfiguration((AWS2S3VectorsComponent) component).setUseDefaultCredentialsProvider((boolean) value); return true;
            case "useProfileCredentialsProvider": getOrCreateConfiguration((AWS2S3VectorsComponent) component).setUseProfileCredentialsProvider((boolean) value); return true;
            case "useSessionCredentials": getOrCreateConfiguration((AWS2S3VectorsComponent) component).setUseSessionCredentials((boolean) value); return true;
            default: return false;
            }
        }
    }
}