/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.neethi.PolicyComponent;
import org.apache.ws.secpolicy.SP11Constants;
import org.apache.ws.secpolicy.SP12Constants;
import org.apache.ws.secpolicy.SPConstants;
import org.apache.ws.secpolicy.model.AbstractSecurityAssertion;
import org.apache.ws.secpolicy.model.Token;
import org.apache.ws.secpolicy.model.TokenWrapper;

public class RecipientToken
extends AbstractSecurityAssertion
implements TokenWrapper {
    private Token receipientToken;

    public RecipientToken(int version) {
        this.setVersion(version);
    }

    public Token getReceipientToken() {
        return this.receipientToken;
    }

    public void setReceipientToken(Token receipientToken) {
        this.receipientToken = receipientToken;
    }

    @Override
    public void setToken(Token tok) {
        this.setReceipientToken(tok);
    }

    public QName getName() {
        if (this.version == 2) {
            return SP12Constants.RECIPIENT_TOKEN;
        }
        return SP11Constants.RECIPIENT_TOKEN;
    }

    @Override
    public PolicyComponent normalize() {
        throw new UnsupportedOperationException();
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        RecipientToken.writeStartElement(writer, this.getName());
        RecipientToken.writeStartElement(writer, SPConstants.POLICY);
        Token token = this.getReceipientToken();
        if (token == null) {
            throw new RuntimeException("RecipientToken doesn't contain any token assertions");
        }
        token.serialize(writer);
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

