/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util.time;

import org.apache.accumulo.server.util.time.ProvidesTime;

public class BaseRelativeTime
implements ProvidesTime {
    private long diff = 0L;
    private long lastReportedTime = 0L;
    ProvidesTime local;

    BaseRelativeTime(ProvidesTime real, long lastReportedTime) {
        this.local = real;
        this.lastReportedTime = lastReportedTime;
    }

    BaseRelativeTime(ProvidesTime real) {
        this(real, 0L);
    }

    @Override
    public synchronized long currentTime() {
        long localNow = this.local.currentTime();
        long result = localNow + this.diff;
        if (result < this.lastReportedTime) {
            return this.lastReportedTime;
        }
        this.lastReportedTime = result;
        return result;
    }

    public synchronized void updateTime(long advice) {
        long localNow = this.local.currentTime();
        long diff = advice - localNow;
        this.diff = this.diff * 4L / 5L + diff / 5L;
    }
}

