/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.InstanceOperations;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.fate.AdminUtil;
import org.apache.accumulo.core.fate.FateTxId;
import org.apache.accumulo.core.fate.ReadOnlyTStore;
import org.apache.accumulo.core.fate.TStore;
import org.apache.accumulo.core.fate.ZooStore;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.fate.zookeeper.ZooCache;
import org.apache.accumulo.core.fate.zookeeper.ZooReader;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.manager.thrift.FateService;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.process.thrift.ServerProcessService;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.NamespacePermission;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.singletons.SingletonManager;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.AddressUtil;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.tables.TableMap;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.cli.ServerUtilOpts;
import org.apache.accumulo.server.security.SecurityUtil;
import org.apache.accumulo.server.util.ChangeSecret;
import org.apache.accumulo.server.util.DeleteZooInstance;
import org.apache.accumulo.server.util.FindOfflineTablets;
import org.apache.accumulo.server.util.ListInstances;
import org.apache.accumulo.server.util.ListVolumesUsed;
import org.apache.accumulo.server.util.RemoveEntriesForMissingFiles;
import org.apache.accumulo.server.util.RestoreZookeeper;
import org.apache.accumulo.server.util.ServiceStatusCmd;
import org.apache.accumulo.server.util.TabletServerLocks;
import org.apache.accumulo.server.util.VerifyTabletAssignments;
import org.apache.accumulo.server.util.ZooZap;
import org.apache.accumulo.server.util.fateCommand.FateSummaryReport;
import org.apache.accumulo.start.spi.KeywordExecutable;
import org.apache.thrift.TException;
import org.apache.thrift.TServiceClient;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={KeywordExecutable.class})
public class Admin
implements KeywordExecutable {
    private static final Logger log = LoggerFactory.getLogger(Admin.class);
    private static final String RV_DEPRECATION_MSG = "Randomizing tablet directories is deprecated and now does nothing. Accumulo now always calls the volume chooser for each file created by a tablet, so its no longer necessary.";
    private static final String ACCUMULO_SITE_BACKUP_FILE = "accumulo.properties.bak";
    private static final String NS_FILE_SUFFIX = "_ns.cfg";
    private static final String USER_FILE_SUFFIX = "_user.cfg";
    private static final MessageFormat configFormat = new MessageFormat("config -t {0} -s {1}\n");
    private static final MessageFormat createNsFormat = new MessageFormat("createnamespace {0}\n");
    private static final MessageFormat createTableFormat = new MessageFormat("createtable {0}\n");
    private static final MessageFormat createUserFormat = new MessageFormat("createuser {0}\n");
    private static final MessageFormat nsConfigFormat = new MessageFormat("config -ns {0} -s {1}\n");
    private static final MessageFormat sysPermFormat = new MessageFormat("grant System.{0} -s -u {1}\n");
    private static final MessageFormat nsPermFormat = new MessageFormat("grant Namespace.{0} -ns {1} -u {2}\n");
    private static final MessageFormat tablePermFormat = new MessageFormat("grant Table.{0} -t {1} -u {2}\n");
    private static final MessageFormat userAuthsFormat = new MessageFormat("setauths -u {0} -s {1}\n");
    private DefaultConfiguration defaultConfig;
    private Map<String, String> siteConfig;
    private Map<String, String> systemConfig;
    private List<String> localUsers;

    public static void main(String[] args) {
        new Admin().execute(args);
    }

    public String keyword() {
        return "admin";
    }

    public KeywordExecutable.UsageGroup usageGroup() {
        return KeywordExecutable.UsageGroup.CORE;
    }

    public String description() {
        return "Executes administrative commands";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"DM_EXIT"}, justification="System.exit okay for CLI tool")
    public void execute(String[] args) {
        ServerUtilOpts opts = new ServerUtilOpts();
        JCommander cl = new JCommander((Object)opts);
        cl.setProgramName("accumulo admin");
        ServiceStatusCmdOpts serviceStatusCommandOpts = new ServiceStatusCmdOpts();
        cl.addCommand("serviceStatus", (Object)serviceStatusCommandOpts);
        ChangeSecretCommand changeSecretCommand = new ChangeSecretCommand();
        cl.addCommand("changeSecret", (Object)changeSecretCommand);
        CheckTabletsCommand checkTabletsCommand = new CheckTabletsCommand();
        cl.addCommand("checkTablets", (Object)checkTabletsCommand);
        DeleteZooInstanceCommand deleteZooInstOpts = new DeleteZooInstanceCommand();
        cl.addCommand("deleteZooInstance", (Object)deleteZooInstOpts);
        DumpConfigCommand dumpConfigCommand = new DumpConfigCommand();
        cl.addCommand("dumpConfig", (Object)dumpConfigCommand);
        FateOpsCommand fateOpsCommand = new FateOpsCommand();
        cl.addCommand("fate", (Object)fateOpsCommand);
        ListInstancesCommand listInstancesOpts = new ListInstancesCommand();
        cl.addCommand("listInstances", (Object)listInstancesOpts);
        TabletServerLocksCommand tServerLocksOpts = new TabletServerLocksCommand();
        cl.addCommand("locks", (Object)tServerLocksOpts);
        PingCommand pingCommand = new PingCommand();
        cl.addCommand("ping", (Object)pingCommand);
        RestoreZooCommand restoreZooOpts = new RestoreZooCommand();
        cl.addCommand("restoreZoo", (Object)restoreZooOpts);
        RandomizeVolumesCommand randomizeVolumesOpts = new RandomizeVolumesCommand();
        cl.addCommand("randomizeVolumes", (Object)randomizeVolumesOpts);
        StopCommand stopOpts = new StopCommand();
        cl.addCommand("stop", (Object)stopOpts);
        StopAllCommand stopAllOpts = new StopAllCommand();
        cl.addCommand("stopAll", (Object)stopAllOpts);
        StopManagerCommand stopManagerOpts = new StopManagerCommand();
        cl.addCommand("stopManager", (Object)stopManagerOpts);
        StopMasterCommand stopMasterOpts = new StopMasterCommand();
        cl.addCommand("stopMaster", (Object)stopMasterOpts);
        VerifyTabletAssignmentsCommand verifyTabletAssignmentsOpts = new VerifyTabletAssignmentsCommand();
        cl.addCommand("verifyTabletAssigns", (Object)verifyTabletAssignmentsOpts);
        VolumesCommand volumesCommand = new VolumesCommand();
        cl.addCommand("volumes", (Object)volumesCommand);
        cl.parse(args);
        if (cl.getParsedCommand() == null) {
            cl.usage();
            return;
        }
        for (Map.Entry command : cl.getCommands().entrySet()) {
            List objects = ((JCommander)command.getValue()).getObjects();
            for (Object obj : objects) {
                if (!(obj instanceof SubCommandOpts) || !((SubCommandOpts)obj).help) continue;
                ((JCommander)command.getValue()).usage();
                return;
            }
        }
        ServerContext context = opts.getServerContext();
        AccumuloConfiguration conf = context.getConfiguration();
        if (conf.getBoolean(Property.INSTANCE_RPC_SASL_ENABLED)) {
            SecurityUtil.serverLogin(conf);
        }
        try {
            int rc = 0;
            if (cl.getParsedCommand().equals("listInstances")) {
                ListInstances.listInstances(context.getZooKeepers(), listInstancesOpts.printAll, listInstancesOpts.printErrors);
            } else if (cl.getParsedCommand().equals("ping")) {
                if (Admin.ping(context, pingCommand.args) != 0) {
                    rc = 4;
                }
            } else if (cl.getParsedCommand().equals("checkTablets")) {
                System.out.println("\n*** Looking for offline tablets ***\n");
                if (FindOfflineTablets.findOffline(context, checkTabletsCommand.tableName) != 0) {
                    rc = 5;
                }
                System.out.println("\n*** Looking for missing files ***\n");
                if (checkTabletsCommand.tableName == null) {
                    if (RemoveEntriesForMissingFiles.checkAllTables(context, checkTabletsCommand.fixFiles) != 0) {
                        rc = 6;
                    }
                } else if (RemoveEntriesForMissingFiles.checkTable(context, checkTabletsCommand.tableName, checkTabletsCommand.fixFiles) != 0) {
                    rc = 6;
                }
            } else if (cl.getParsedCommand().equals("stop")) {
                Admin.stopServers(context, stopOpts.args, stopOpts.force);
            } else if (cl.getParsedCommand().equals("dumpConfig")) {
                this.printConfig(context, dumpConfigCommand);
            } else if (cl.getParsedCommand().equals("volumes")) {
                ListVolumesUsed.listVolumes(context);
            } else if (cl.getParsedCommand().equals("randomizeVolumes")) {
                System.out.println(RV_DEPRECATION_MSG);
            } else if (cl.getParsedCommand().equals("verifyTabletAssigns")) {
                VerifyTabletAssignments.execute(opts.getClientProps(), verifyTabletAssignmentsOpts.verbose);
            } else if (cl.getParsedCommand().equals("changeSecret")) {
                ChangeSecret.execute(context, conf);
            } else if (cl.getParsedCommand().equals("deleteZooInstance")) {
                DeleteZooInstance.execute(context, deleteZooInstOpts.clean, deleteZooInstOpts.instance, deleteZooInstOpts.auth);
            } else if (cl.getParsedCommand().equals("restoreZoo")) {
                RestoreZookeeper.execute(conf, restoreZooOpts.file, restoreZooOpts.overwrite);
            } else if (cl.getParsedCommand().equals("locks")) {
                TabletServerLocks.execute(context, args.length > 2 ? args[2] : null, tServerLocksOpts.delete);
            } else if (cl.getParsedCommand().equals("fate")) {
                this.executeFateOpsCommand(context, fateOpsCommand);
            } else if (cl.getParsedCommand().equals("serviceStatus")) {
                ServiceStatusCmd ssc = new ServiceStatusCmd();
                ssc.execute(context, serviceStatusCommandOpts.json, serviceStatusCommandOpts.showHosts);
            } else if (cl.getParsedCommand().equals("stopManager") || cl.getParsedCommand().equals("stopAll")) {
                boolean everything = cl.getParsedCommand().equals("stopAll");
                if (everything) {
                    Admin.flushAll(context);
                }
                Admin.stopServer(context, everything);
            } else {
                cl.usage();
            }
            if (rc != 0) {
                System.exit(rc);
            }
        }
        catch (AccumuloException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            System.exit(1);
        }
        catch (AccumuloSecurityException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            System.exit(2);
        }
        catch (Exception e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            System.exit(3);
        }
        finally {
            SingletonManager.setMode((SingletonManager.Mode)SingletonManager.Mode.CLOSED);
        }
    }

    private static int ping(ClientContext context, List<String> args) {
        InstanceOperations io = context.instanceOperations();
        if (args.isEmpty()) {
            args = io.getTabletServers();
        }
        int unreachable = 0;
        for (String tserver : args) {
            try {
                io.ping(tserver);
                System.out.println(tserver + " OK");
            }
            catch (AccumuloException ae) {
                System.out.println(tserver + " FAILED (" + ae.getMessage() + ")");
                ++unreachable;
            }
        }
        System.out.printf("\n%d of %d tablet servers unreachable\n\n", unreachable, args.size());
        return unreachable;
    }

    private static void flushAll(ClientContext context) {
        AtomicInteger flushesStarted = new AtomicInteger(0);
        Runnable flushTask = () -> {
            try {
                Set tables = context.tableOperations().tableIdMap().keySet();
                for (String table : tables) {
                    if (table.equals(MetadataTable.NAME)) continue;
                    try {
                        context.tableOperations().flush(table, null, null, false);
                        flushesStarted.incrementAndGet();
                    }
                    catch (TableNotFoundException tableNotFoundException) {}
                }
            }
            catch (Exception e) {
                log.warn("Failed to initiate flush {}", (Object)e.getMessage());
            }
        };
        Thread flusher = new Thread(flushTask);
        flusher.setDaemon(true);
        flusher.start();
        long start = System.currentTimeMillis();
        try {
            flusher.join(3000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("Interrupted while waiting to join Flush thread", (Throwable)e);
        }
        while (flusher.isAlive() && System.currentTimeMillis() - start < 15000L) {
            int flushCount = flushesStarted.get();
            try {
                flusher.join(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.warn("Interrupted while waiting to join Flush thread", (Throwable)e);
            }
            if (flushCount != flushesStarted.get()) continue;
            break;
        }
        flusher.interrupt();
        try {
            flusher.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("Interrupted while waiting to join Flush thread", (Throwable)e);
        }
    }

    private static void stopServer(ClientContext context, boolean tabletServersToo) throws AccumuloException, AccumuloSecurityException {
        ThriftClientTypes.MANAGER.executeVoid(context, client -> client.shutdown(TraceUtil.traceInfo(), context.rpcCreds(), tabletServersToo));
    }

    private static void stopServers(ServerContext context, List<String> servers, boolean force) throws AccumuloException, AccumuloSecurityException, InterruptedException, KeeperException {
        ArrayList<String> hostOnly = new ArrayList<String>();
        TreeSet<HostAndPort> hostAndPort = new TreeSet<HostAndPort>();
        for (String string : servers) {
            if (string.contains(":")) {
                hostAndPort.add(HostAndPort.fromString((String)string));
                continue;
            }
            hostOnly.add(string);
        }
        if (!hostOnly.isEmpty()) {
            Admin.stopTabletServer(context, hostOnly, force);
        }
        if (!hostAndPort.isEmpty()) {
            if (force) {
                ZooZap.Opts opts = new ZooZap.Opts();
                ZooReaderWriter zooReaderWriter = context.getZooReaderWriter();
                InstanceId iid = context.getInstanceID();
                String tserversPath = "/accumulo/" + String.valueOf(iid) + "/tservers";
                ZooZap.removeLocks(zooReaderWriter, tserversPath, hostAndPort::contains, opts);
                String compactorsBasepath = "/accumulo/" + String.valueOf(iid) + "/compactors";
                ZooZap.removeGroupedLocks(zooReaderWriter, compactorsBasepath, rg -> true, hostAndPort::contains, opts);
                String sserversPath = "/accumulo/" + String.valueOf(iid) + "/sservers";
                ZooZap.removeGroupedLocks(zooReaderWriter, sserversPath, rg -> true, hostAndPort::contains, opts);
                String managerLockPath = "/accumulo/" + String.valueOf(iid) + "/managers/lock";
                ZooZap.removeSingletonLock(zooReaderWriter, managerLockPath, hostAndPort::contains, opts);
                String gcLockPath = "/accumulo/" + String.valueOf(iid) + "/gc/lock";
                ZooZap.removeSingletonLock(zooReaderWriter, gcLockPath, hostAndPort::contains, opts);
                String monitorLockPath = "/accumulo/" + String.valueOf(iid) + "/monitor/lock";
                ZooZap.removeSingletonLock(zooReaderWriter, monitorLockPath, hostAndPort::contains, opts);
            } else {
                for (HostAndPort hostAndPort2 : hostAndPort) {
                    Admin.signalGracefulShutdown(context, hostAndPort2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void signalGracefulShutdown(ClientContext context, HostAndPort hp) {
        ServerProcessService.Client client;
        block5: {
            Objects.requireNonNull(hp, "address not set");
            client = null;
            client = ThriftClientTypes.SERVER_PROCESS.getServerProcessConnection(context, log, hp.getHost(), hp.getPort());
            if (client != null) break block5;
            log.warn("Failed to initiate shutdown for {}", (Object)hp);
            if (client == null) return;
            ThriftUtil.returnClient((TServiceClient)client, (ClientContext)context);
            return;
        }
        try {
            client.gracefulShutdown(context.rpcCreds());
            log.info("Initiated shutdown for {}", (Object)hp);
            if (client == null) return;
        }
        catch (TException e) {
            try {
                log.warn("Failed to initiate shutdown for {}", (Object)hp, (Object)e);
                if (client == null) return;
            }
            catch (Throwable throwable) {
                if (client == null) throw throwable;
                ThriftUtil.returnClient(client, (ClientContext)context);
                throw throwable;
            }
            ThriftUtil.returnClient((TServiceClient)client, (ClientContext)context);
            return;
        }
        ThriftUtil.returnClient((TServiceClient)client, (ClientContext)context);
        return;
    }

    private static void stopTabletServer(ClientContext context, List<String> servers, boolean force) throws AccumuloException, AccumuloSecurityException {
        if (context.getManagerLocations().isEmpty()) {
            log.info("No managers running. Not attempting safe unload of tserver.");
            return;
        }
        if (servers.isEmpty()) {
            log.error("No tablet servers provided.");
            return;
        }
        String zTServerRoot = Admin.getTServersZkPath(context);
        ZooCache zc = context.getZooCache();
        for (String server : servers) {
            List runningServers = context.instanceOperations().getTabletServers();
            if (runningServers.size() == 1 && !force) {
                log.info("Only 1 tablet server running. Not attempting shutdown of {}", (Object)server);
                return;
            }
            for (int port : context.getConfiguration().getPort(Property.TSERV_CLIENTPORT)) {
                HostAndPort address = AddressUtil.parseAddress((String)server, (int)port);
                String finalServer = Admin.qualifyWithZooKeeperSessionId(zTServerRoot, zc, address.toString());
                log.info("Stopping server {}", (Object)finalServer);
                ThriftClientTypes.MANAGER.executeVoid(context, client -> client.shutdownTabletServer(TraceUtil.traceInfo(), context.rpcCreds(), finalServer, force));
            }
        }
    }

    static String getTServersZkPath(ClientContext context) {
        Objects.requireNonNull(context);
        return context.getZooKeeperRoot() + "/tservers";
    }

    static String qualifyWithZooKeeperSessionId(String zTServerRoot, ZooCache zooCache, String hostAndPort) {
        ServiceLock.ServiceLockPath zLockPath = ServiceLock.path((String)(zTServerRoot + "/" + hostAndPort));
        long sessionId = ServiceLock.getSessionId((ZooCache)zooCache, (ServiceLock.ServiceLockPath)zLockPath);
        if (sessionId == 0L) {
            return hostAndPort;
        }
        return hostAndPort + "[" + Long.toHexString(sessionId) + "]";
    }

    public void printConfig(ClientContext context, DumpConfigCommand opts) throws Exception {
        block11: {
            File outputDirectory;
            block10: {
                outputDirectory = Admin.getOutputDirectory(opts.directory);
                this.defaultConfig = DefaultConfiguration.getInstance();
                this.siteConfig = context.instanceOperations().getSiteConfiguration();
                this.systemConfig = context.instanceOperations().getSystemConfiguration();
                if (opts.allConfiguration || opts.users) {
                    this.localUsers = Lists.newArrayList((Iterable)context.securityOperations().listLocalUsers());
                    Collections.sort(this.localUsers);
                }
                if (!opts.allConfiguration) break block10;
                this.printSystemConfiguration(outputDirectory);
                for (Iterator<String> namespace : context.namespaceOperations().list()) {
                    this.printNameSpaceConfiguration((AccumuloClient)context, (String)((Object)namespace), outputDirectory);
                }
                SortedSet tableNames = context.tableOperations().list();
                for (String tableName : tableNames) {
                    this.printTableConfiguration((AccumuloClient)context, tableName, outputDirectory);
                }
                for (String user : this.localUsers) {
                    Admin.printUserConfiguration((AccumuloClient)context, user, outputDirectory);
                }
                break block11;
            }
            if (opts.systemConfiguration) {
                this.printSystemConfiguration(outputDirectory);
            }
            if (opts.namespaceConfiguration) {
                for (String namespace : context.namespaceOperations().list()) {
                    this.printNameSpaceConfiguration((AccumuloClient)context, namespace, outputDirectory);
                }
            }
            if (!opts.tables.isEmpty()) {
                for (String tableName : opts.tables) {
                    this.printTableConfiguration((AccumuloClient)context, tableName, outputDirectory);
                }
            }
            if (!opts.users) break block11;
            for (String user : this.localUsers) {
                Admin.printUserConfiguration((AccumuloClient)context, user, outputDirectory);
            }
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="app is run in same security context as user providing the filename")
    private static File getOutputDirectory(String directory) {
        File outputDirectory = null;
        if (directory != null) {
            outputDirectory = new File(directory);
            if (!outputDirectory.isDirectory()) {
                throw new IllegalArgumentException(directory + " does not exist on the local filesystem.");
            }
            if (!outputDirectory.canWrite()) {
                throw new IllegalArgumentException(directory + " is not writable");
            }
        }
        return outputDirectory;
    }

    private String getDefaultConfigValue(String key) {
        if (key == null) {
            return null;
        }
        String defaultValue = null;
        try {
            Property p = Property.getPropertyByKey((String)key);
            if (p == null) {
                return defaultValue;
            }
            defaultValue = this.defaultConfig.get(p);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return defaultValue;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="code runs in same security context as user who provided input")
    private void printNameSpaceConfiguration(AccumuloClient accumuloClient, String namespace, File outputDirectory) throws IOException, AccumuloException, AccumuloSecurityException, NamespaceNotFoundException {
        File namespaceScript = new File(outputDirectory, namespace + NS_FILE_SUFFIX);
        try (BufferedWriter nsWriter = new BufferedWriter(new FileWriter(namespaceScript, StandardCharsets.UTF_8));){
            nsWriter.write(createNsFormat.format(new String[]{namespace}));
            ImmutableSortedMap props = ImmutableSortedMap.copyOf((Map)accumuloClient.namespaceOperations().getConfiguration(namespace));
            for (Map.Entry entry : props.entrySet()) {
                String defaultValue = this.getDefaultConfigValue((String)entry.getKey());
                if (defaultValue != null && defaultValue.equals(entry.getValue()) || ((String)entry.getValue()).equals(this.siteConfig.get(entry.getKey())) || ((String)entry.getValue()).equals(this.systemConfig.get(entry.getKey()))) continue;
                nsWriter.write(nsConfigFormat.format(new String[]{namespace, (String)entry.getKey() + "=" + (String)entry.getValue()}));
            }
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="code runs in same security context as user who provided input")
    private static void printUserConfiguration(AccumuloClient accumuloClient, String user, File outputDirectory) throws IOException, AccumuloException, AccumuloSecurityException {
        File userScript = new File(outputDirectory, user + USER_FILE_SUFFIX);
        try (BufferedWriter userWriter = new BufferedWriter(new FileWriter(userScript, StandardCharsets.UTF_8));){
            userWriter.write(createUserFormat.format(new String[]{user}));
            Authorizations auths = accumuloClient.securityOperations().getUserAuthorizations(user);
            userWriter.write(userAuthsFormat.format(new String[]{user, auths.toString()}));
            for (SystemPermission sp : SystemPermission.values()) {
                if (!accumuloClient.securityOperations().hasSystemPermission(user, sp)) continue;
                userWriter.write(sysPermFormat.format(new String[]{sp.name(), user}));
            }
            for (String namespace : accumuloClient.namespaceOperations().list()) {
                NamespacePermission[] namespacePermissionArray = NamespacePermission.values();
                int n = namespacePermissionArray.length;
                for (int i = 0; i < n; ++i) {
                    NamespacePermission np = namespacePermissionArray[i];
                    if (!accumuloClient.securityOperations().hasNamespacePermission(user, namespace, np)) continue;
                    userWriter.write(nsPermFormat.format(new String[]{np.name(), namespace, user}));
                }
            }
            for (String tableName : accumuloClient.tableOperations().list()) {
                for (TablePermission perm : TablePermission.values()) {
                    if (!accumuloClient.securityOperations().hasTablePermission(user, tableName, perm)) continue;
                    userWriter.write(tablePermFormat.format(new String[]{perm.name(), tableName, user}));
                }
            }
        }
    }

    private void printSystemConfiguration(File outputDirectory) throws IOException {
        TreeMap<String, String> conf = new TreeMap<String, String>();
        TreeMap<String, String> site = new TreeMap<String, String>(this.siteConfig);
        for (Map.Entry<String, String> entry : site.entrySet()) {
            String string = this.getDefaultConfigValue(entry.getKey());
            if (entry.getValue().equals(string) || this.systemConfig.containsKey(entry.getKey())) continue;
            conf.put(entry.getKey(), entry.getValue());
        }
        TreeMap<String, String> system = new TreeMap<String, String>(this.systemConfig);
        for (Map.Entry<String, String> entry : system.entrySet()) {
            String defaultValue = this.getDefaultConfigValue(entry.getKey());
            if (entry.getValue().equals(defaultValue)) continue;
            conf.put(entry.getKey(), entry.getValue());
        }
        File file = new File(outputDirectory, ACCUMULO_SITE_BACKUP_FILE);
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file, StandardCharsets.UTF_8));){
            for (Map.Entry prop : conf.entrySet()) {
                bufferedWriter.write((String)prop.getKey() + "=" + (String)prop.getValue() + "\n");
            }
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="code runs in same security context as user who provided input")
    private void printTableConfiguration(AccumuloClient accumuloClient, String tableName, File outputDirectory) throws AccumuloSecurityException, AccumuloException, TableNotFoundException, IOException {
        File tableBackup = new File(outputDirectory, tableName + ".cfg");
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(tableBackup, StandardCharsets.UTF_8));){
            writer.write(createTableFormat.format(new String[]{tableName}));
            ImmutableSortedMap props = ImmutableSortedMap.copyOf((Map)accumuloClient.tableOperations().getConfiguration(tableName));
            for (Map.Entry prop : props.entrySet()) {
                String defaultValue;
                if (!((String)prop.getKey()).startsWith(Property.TABLE_PREFIX.getKey()) || (defaultValue = this.getDefaultConfigValue((String)prop.getKey())) != null && defaultValue.equals(prop.getValue()) || ((String)prop.getValue()).equals(this.siteConfig.get(prop.getKey())) || ((String)prop.getValue()).equals(this.systemConfig.get(prop.getKey()))) continue;
                writer.write(configFormat.format(new String[]{tableName, (String)prop.getKey() + "=" + (String)prop.getValue()}));
            }
        }
    }

    private void executeFateOpsCommand(ServerContext context, FateOpsCommand fateOpsCommand) throws AccumuloException, AccumuloSecurityException, InterruptedException, KeeperException {
        this.validateFateUserInput(fateOpsCommand);
        AdminUtil admin = new AdminUtil(true);
        String zkRoot = context.getZooKeeperRoot();
        ServiceLock.ServiceLockPath zLockManagerPath = ServiceLock.path((String)(zkRoot + "/managers/lock"));
        ServiceLock.ServiceLockPath zTableLocksPath = ServiceLock.path((String)(zkRoot + "/table_locks"));
        String fateZkPath = zkRoot + "/fate";
        ZooReaderWriter zk = context.getZooReaderWriter();
        ZooStore zs = new ZooStore(fateZkPath, zk, context.getZooCache());
        if (fateOpsCommand.cancel) {
            this.cancelSubmittedFateTxs(context, fateOpsCommand.txList);
        } else if (fateOpsCommand.fail) {
            for (String txid : fateOpsCommand.txList) {
                if (admin.prepFail((TStore)zs, zk, zLockManagerPath, txid)) continue;
                throw new AccumuloException("Could not fail transaction: " + txid);
            }
        } else if (fateOpsCommand.delete) {
            for (String txid : fateOpsCommand.txList) {
                if (!admin.prepDelete((TStore)zs, zk, zLockManagerPath, txid)) {
                    throw new AccumuloException("Could not delete transaction: " + txid);
                }
                admin.deleteLocks(zk, zTableLocksPath, txid);
            }
        }
        if (fateOpsCommand.print) {
            TreeSet sortedTxs = new TreeSet();
            fateOpsCommand.txList.forEach(s -> sortedTxs.add(FateTxId.parseTidFromUserInput((String)s)));
            EnumSet<ReadOnlyTStore.TStatus> statusFilter = this.getCmdLineStatusFilters(fateOpsCommand.states);
            admin.print((ReadOnlyTStore)zs, (ZooReader)zk, zTableLocksPath, new Formatter(System.out), sortedTxs, statusFilter);
            System.out.println();
        }
        if (fateOpsCommand.summarize) {
            this.summarizeFateTx(context, fateOpsCommand, (AdminUtil<Admin>)admin, (ReadOnlyTStore<Admin>)zs, zTableLocksPath);
        }
    }

    private void validateFateUserInput(FateOpsCommand cmd) {
        if (cmd.cancel && cmd.fail || cmd.cancel && cmd.delete || cmd.fail && cmd.delete) {
            throw new IllegalArgumentException("Can only perform one of the following at a time: cancel, fail or delete.");
        }
        if ((cmd.cancel || cmd.fail || cmd.delete) && cmd.txList.isEmpty()) {
            throw new IllegalArgumentException("At least one txId required when using cancel, fail or delete");
        }
    }

    private void cancelSubmittedFateTxs(ServerContext context, List<String> txList) throws AccumuloException {
        for (String txStr : txList) {
            long txid = Long.parseLong(txStr, 16);
            boolean cancelled = this.cancelFateOperation(context, txid);
            if (cancelled) {
                System.out.println("FaTE transaction " + FateTxId.formatTid((long)txid) + " was cancelled or already completed.");
                continue;
            }
            System.out.println("FaTE transaction " + FateTxId.formatTid((long)txid) + " was not cancelled, status may have changed.");
        }
    }

    private boolean cancelFateOperation(ClientContext context, long txid) throws AccumuloException {
        FateService.Client client = null;
        try {
            client = (FateService.Client)ThriftClientTypes.FATE.getConnectionWithRetry(context);
            boolean bl = client.cancelFateOperation(TraceUtil.traceInfo(), context.rpcCreds(), txid);
            return bl;
        }
        catch (Exception e) {
            throw new AccumuloException((Throwable)e);
        }
        finally {
            if (client != null) {
                ThriftUtil.close((TServiceClient)client, (ClientContext)context);
            }
        }
    }

    private void summarizeFateTx(ServerContext context, FateOpsCommand cmd, AdminUtil<Admin> admin, ReadOnlyTStore<Admin> zs, ServiceLock.ServiceLockPath tableLocksPath) throws InterruptedException, AccumuloException, AccumuloSecurityException, KeeperException {
        ZooReaderWriter zk = context.getZooReaderWriter();
        AdminUtil.FateStatus transactions = admin.getStatus(zs, (ZooReader)zk, tableLocksPath, null, null);
        Map tidToNameMap = new TableMap((ClientContext)context).getIdtoNameMap();
        HashMap<String, String> idsToNameMap = new HashMap<String, String>(tidToNameMap.size() * 2);
        tidToNameMap.forEach((tid, name) -> idsToNameMap.put(tid.canonical(), "t:" + name));
        context.namespaceOperations().namespaceIdMap().forEach((name, nsid) -> {
            String prev = (String)((Object)idsToNameMap.put((String)nsid, "ns:" + name));
            if (prev != null) {
                log.warn("duplicate id found for table / namespace id. table name: {}, namespace name: {}", (Object)prev, name);
            }
        });
        EnumSet<ReadOnlyTStore.TStatus> statusFilter = this.getCmdLineStatusFilters(cmd.states);
        FateSummaryReport report = new FateSummaryReport(idsToNameMap, statusFilter);
        transactions.getTransactions().forEach(report::gatherTxnStatus);
        if (cmd.printJson) {
            this.printLines(Collections.singletonList(report.toJson()));
        } else {
            this.printLines(report.formatLines());
        }
    }

    private void printLines(List<String> lines) {
        for (String nextLine : lines) {
            if (nextLine == null) continue;
            System.out.println(nextLine);
        }
    }

    private EnumSet<ReadOnlyTStore.TStatus> getCmdLineStatusFilters(List<String> states) {
        EnumSet<ReadOnlyTStore.TStatus> statusFilter = null;
        if (!states.isEmpty()) {
            statusFilter = EnumSet.noneOf(ReadOnlyTStore.TStatus.class);
            for (String element : states) {
                statusFilter.add(ReadOnlyTStore.TStatus.valueOf((String)element));
            }
        }
        return statusFilter;
    }

    @Parameters(commandDescription="show service status")
    public static class ServiceStatusCmdOpts
    extends SubCommandOpts {
        @Parameter(names={"--json"}, description="provide output in json format")
        boolean json = false;
        @Parameter(names={"--showHosts"}, description="provide a summary of service counts with host details")
        boolean showHosts = false;
    }

    @Parameters(commandDescription="Changes the unique secret given to the instance that all servers must know.")
    static class ChangeSecretCommand {
        ChangeSecretCommand() {
        }
    }

    @Parameters(commandDescription="print tablets that are offline in online tables")
    static class CheckTabletsCommand
    extends SubCommandOpts {
        @Parameter(names={"--fixFiles"}, description="Remove dangling file pointers")
        boolean fixFiles = false;
        @Parameter(names={"-t", "--table"}, description="Table to check, if not set checks all tables")
        String tableName = null;

        CheckTabletsCommand() {
        }
    }

    @Parameters(commandDescription="Deletes specific instance name or id from zookeeper or cleans up all old instances.")
    static class DeleteZooInstanceCommand
    extends SubCommandOpts {
        @Parameter(names={"-i", "--instance"}, description="the instance name or id to delete")
        String instance;
        @Parameter(names={"-c", "--clean"}, description="Cleans Zookeeper by deleting all old instances. This will not delete the instance pointed to by the local accumulo.properties file")
        boolean clean = false;
        @Parameter(names={"--password"}, description="The system secret, if different than instance.secret in accumulo.properties", password=true)
        String auth;

        DeleteZooInstanceCommand() {
        }
    }

    @Parameters(commandDescription="print out non-default configuration settings")
    static class DumpConfigCommand
    extends SubCommandOpts {
        @Parameter(names={"-a", "--all"}, description="print the system and all table configurations")
        boolean allConfiguration = false;
        @Parameter(names={"-d", "--directory"}, description="directory to place config files")
        String directory = null;
        @Parameter(names={"-s", "--system"}, description="print the system configuration")
        boolean systemConfiguration = false;
        @Parameter(names={"-n", "--namespaces"}, description="print the namespace configuration")
        boolean namespaceConfiguration = false;
        @Parameter(names={"-t", "--tables"}, description="print per-table configuration")
        List<String> tables = new ArrayList<String>();
        @Parameter(names={"-u", "--users"}, description="print users and their authorizations and permissions")
        boolean users = false;

        DumpConfigCommand() {
        }
    }

    @Parameters(commandNames={"fate"}, commandDescription="Operations performed on the Manager FaTE system.")
    static class FateOpsCommand
    extends SubCommandOpts {
        @Parameter(description="[<txId>...]")
        List<String> txList = new ArrayList<String>();
        @Parameter(names={"-c", "--cancel"}, description="<txId>... Cancel new or submitted FaTE transactions")
        boolean cancel;
        @Parameter(names={"-f", "--fail"}, description="<txId>... Transition FaTE transaction status to FAILED_IN_PROGRESS (requires Manager to be down)")
        boolean fail;
        @Parameter(names={"-d", "--delete"}, description="<txId>... Delete FaTE transaction and its associated table locks (requires Manager to be down)")
        boolean delete;
        @Parameter(names={"-p", "--print", "-print", "-l", "--list", "-list"}, description="[<txId>...] Print information about FaTE transactions. Print only the 'txId's specified or print all transactions if empty. Use -s to only print certain states.")
        boolean print;
        @Parameter(names={"--summary"}, description="Print a summary of all FaTE transactions")
        boolean summarize;
        @Parameter(names={"-j", "--json"}, description="Print transactions in json")
        boolean printJson;
        @Parameter(names={"-s", "--state"}, description="<state>... Print transactions in the state(s) {NEW, IN_PROGRESS, FAILED_IN_PROGRESS, FAILED, SUCCESSFUL}")
        List<String> states = new ArrayList<String>();

        FateOpsCommand() {
        }
    }

    @Parameters(commandDescription="list Accumulo instances in zookeeper")
    static class ListInstancesCommand
    extends SubCommandOpts {
        @Parameter(names={"--print-errors"}, description="display errors while listing instances")
        boolean printErrors = false;
        @Parameter(names={"--print-all"}, description="print information for all instances, not just those with names")
        boolean printAll = false;

        ListInstancesCommand() {
        }
    }

    @Parameters(commandDescription="List or delete Tablet Server locks. Default with no arguments is to list the locks.")
    static class TabletServerLocksCommand
    extends SubCommandOpts {
        @Parameter(names={"-delete"}, description="specify a tablet server lock to delete")
        String delete = null;

        TabletServerLocksCommand() {
        }
    }

    @Parameters(commandDescription="Ping tablet servers.  If no arguments, pings all.")
    static class PingCommand
    extends SubCommandOpts {
        @Parameter(description="{<host> ... }")
        List<String> args = new ArrayList<String>();

        PingCommand() {
        }
    }

    @Parameters(commandDescription="Restore Zookeeper data from a file.")
    static class RestoreZooCommand
    extends SubCommandOpts {
        @Parameter(names={"--overwrite"})
        boolean overwrite = false;
        @Parameter(names={"--file"})
        String file;

        RestoreZooCommand() {
        }
    }

    @Parameters(commandDescription="Randomizing tablet directories is deprecated and now does nothing. Accumulo now always calls the volume chooser for each file created by a tablet, so its no longer necessary.")
    static class RandomizeVolumesCommand
    extends SubCommandOpts {
        @Parameter(names={"-t"}, description="table to update", required=true)
        String tableName = null;

        RandomizeVolumesCommand() {
        }
    }

    @Parameters(commandDescription="Stop the servers at the given addresses allowing them to complete current task but not start new task.  When no port is specified uses ports from tserver.port.client property.")
    static class StopCommand
    extends SubCommandOpts {
        @Parameter(names={"-f", "--force"}, description="force the given server to stop immediately by removing its lock.  Does not wait for any task the server is currently working.")
        boolean force = false;
        @Parameter(description="<host[:port]> {<host[:port]> ... }")
        List<String> args = new ArrayList<String>();

        StopCommand() {
        }
    }

    @Parameters(commandDescription="stop all tablet servers and the manager")
    static class StopAllCommand
    extends SubCommandOpts {
        StopAllCommand() {
        }
    }

    @Parameters(commandDescription="stop the manager")
    static class StopManagerCommand
    extends SubCommandOpts {
        StopManagerCommand() {
        }
    }

    @Deprecated(since="2.1.0")
    @Parameters(commandDescription="stop the master (DEPRECATED -- use stopManager instead)")
    static class StopMasterCommand {
        StopMasterCommand() {
        }
    }

    @Parameters(commandDescription="Verify all Tablets are assigned to tablet servers")
    static class VerifyTabletAssignmentsCommand
    extends SubCommandOpts {
        @Parameter(names={"-v", "--verbose"}, description="verbose mode (prints locations of tablets)")
        boolean verbose = false;

        VerifyTabletAssignmentsCommand() {
        }
    }

    @Parameters(commandDescription="Accumulo volume utility")
    static class VolumesCommand
    extends SubCommandOpts {
        @Parameter(names={"-l", "--list"}, description="list volumes currently in use")
        boolean printErrors = false;

        VolumesCommand() {
        }
    }

    private static class SubCommandOpts {
        @Parameter(names={"-h", "-?", "--help", "-help"}, help=true)
        public boolean help = false;

        private SubCommandOpts() {
        }
    }
}

