/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Suppliers;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigCheckUtil;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.core.util.threads.Threads;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.NamespaceConfiguration;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.server.conf.SystemConfiguration;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.conf.ZooBasedConfiguration;
import org.apache.accumulo.server.conf.store.NamespacePropKey;
import org.apache.accumulo.server.conf.store.PropChangeListener;
import org.apache.accumulo.server.conf.store.PropStore;
import org.apache.accumulo.server.conf.store.PropStoreKey;
import org.apache.accumulo.server.conf.store.SystemPropKey;
import org.apache.accumulo.server.conf.store.TablePropKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerConfigurationFactory
extends ServerConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ServerConfigurationFactory.class);
    private static final int CACHE_EXPIRATION_HRS = 1;
    private final Supplier<SystemConfiguration> systemConfig;
    private final Cache<TableId, NamespaceConfiguration> tableParentConfigs;
    private final Cache<TableId, TableConfiguration> tableConfigs;
    private final Cache<NamespaceId, NamespaceConfiguration> namespaceConfigs;
    private final ServerContext context;
    private final SiteConfiguration siteConfig;
    private final ChangeWatcher changeWatcher = new ChangeWatcher();
    private static final int REFRESH_PERIOD_MINUTES = 15;
    private final ConfigRefreshRunner refresher;

    public ServerConfigurationFactory(ServerContext context, SiteConfiguration siteConfig) {
        this.context = context;
        this.siteConfig = siteConfig;
        this.systemConfig = Suppliers.memoize(() -> {
            SystemConfiguration sysConf = new SystemConfiguration(context, SystemPropKey.of(context.getInstanceID()), (AccumuloConfiguration)siteConfig);
            ConfigCheckUtil.validate((Iterable)((Object)sysConf), (String)"system config");
            return sysConf;
        });
        this.tableParentConfigs = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();
        this.tableConfigs = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();
        this.namespaceConfigs = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();
        this.refresher = new ConfigRefreshRunner();
        Runtime.getRuntime().addShutdownHook(Threads.createNonCriticalThread((String)"config-refresh-shutdownHook", this.refresher::shutdown));
    }

    public ServerContext getServerContext() {
        return this.context;
    }

    public SiteConfiguration getSiteConfiguration() {
        return this.siteConfig;
    }

    public DefaultConfiguration getDefaultConfiguration() {
        return DefaultConfiguration.getInstance();
    }

    @Override
    public AccumuloConfiguration getSystemConfiguration() {
        return this.systemConfig.get();
    }

    @Override
    public TableConfiguration getTableConfiguration(TableId tableId) {
        return (TableConfiguration)((Object)this.tableConfigs.get((Object)tableId, key -> {
            if (this.context.tableNodeExists(tableId)) {
                this.context.getPropStore().registerAsListener(TablePropKey.of(this.context, tableId), this.changeWatcher);
                TableConfiguration conf = new TableConfiguration(this.context, tableId, this.getNamespaceConfigurationForTable(tableId));
                ConfigCheckUtil.validate((Iterable)((Object)conf), (String)("table id: " + tableId.toString()));
                return conf;
            }
            return null;
        }));
    }

    public NamespaceConfiguration getNamespaceConfigurationForTable(TableId tableId) {
        NamespaceId namespaceId;
        try {
            namespaceId = this.context.getNamespaceId(tableId);
        }
        catch (TableNotFoundException e) {
            throw new RuntimeException(e);
        }
        return (NamespaceConfiguration)((Object)this.tableParentConfigs.get((Object)tableId, key -> this.getNamespaceConfiguration(namespaceId)));
    }

    @Override
    public NamespaceConfiguration getNamespaceConfiguration(NamespaceId namespaceId) {
        return (NamespaceConfiguration)((Object)this.namespaceConfigs.get((Object)namespaceId, key -> {
            this.context.getPropStore().registerAsListener(NamespacePropKey.of(this.context, namespaceId), this.changeWatcher);
            NamespaceConfiguration conf = new NamespaceConfiguration(this.context, namespaceId, this.getSystemConfiguration());
            ConfigCheckUtil.validate((Iterable)((Object)conf), (String)("namespace id: " + namespaceId.toString()));
            return conf;
        }));
    }

    private class ChangeWatcher
    implements PropChangeListener {
        private ChangeWatcher() {
        }

        @Override
        public void zkChangeEvent(PropStoreKey<?> propStoreKey) {
            this.clearLocalOnEvent(propStoreKey);
        }

        @Override
        public void cacheChangeEvent(PropStoreKey<?> propStoreKey) {
            this.clearLocalOnEvent(propStoreKey);
        }

        @Override
        public void deleteEvent(PropStoreKey<?> propStoreKey) {
            this.clearLocalOnEvent(propStoreKey);
        }

        private void clearLocalOnEvent(PropStoreKey<?> propStoreKey) {
            if (propStoreKey instanceof NamespacePropKey) {
                log.trace("configuration snapshot refresh: Handle namespace change for {}", propStoreKey);
                ServerConfigurationFactory.this.namespaceConfigs.invalidate((Object)((NamespaceId)((NamespacePropKey)propStoreKey).getId()));
                return;
            }
            if (propStoreKey instanceof TablePropKey) {
                log.trace("configuration snapshot refresh: Handle table change for {}", propStoreKey);
                ServerConfigurationFactory.this.tableConfigs.invalidate((Object)((TableId)((TablePropKey)propStoreKey).getId()));
                ServerConfigurationFactory.this.tableParentConfigs.invalidate((Object)((TableId)((TablePropKey)propStoreKey).getId()));
            }
        }

        @Override
        public void connectionEvent() {
        }
    }

    private class ConfigRefreshRunner {
        private static final long MIN_JITTER_DELAY = 1L;
        private static final long MAX_JITTER_DELAY = 23L;
        private final ScheduledFuture<?> refreshTaskFuture;

        ConfigRefreshRunner() {
            Runnable refreshTask = this::verifySnapshotVersions;
            ScheduledThreadPoolExecutor executor = ThreadPools.getServerThreadPools().createScheduledExecutorService(1, "config-refresh");
            long randDelay = this.jitter(3L, 15L);
            this.refreshTaskFuture = executor.scheduleWithFixedDelay(refreshTask, randDelay, 15L, TimeUnit.MINUTES);
        }

        private void verifySnapshotVersions() {
            long refreshStart = System.nanoTime();
            int keyCount = 0;
            int keyChangedCount = 0;
            PropStore propStore = ServerConfigurationFactory.this.context.getPropStore();
            ++keyCount;
            propStore.validateDataVersion(SystemPropKey.of(ServerConfigurationFactory.this.context), ((ZooBasedConfiguration)ServerConfigurationFactory.this.getSystemConfiguration()).getDataVersion());
            this.jitterDelay();
            for (Map.Entry entry : ServerConfigurationFactory.this.namespaceConfigs.asMap().entrySet()) {
                ++keyCount;
                NamespacePropKey propKey = NamespacePropKey.of(ServerConfigurationFactory.this.context, (NamespaceId)entry.getKey());
                if (!propStore.validateDataVersion(propKey, ((NamespaceConfiguration)((Object)entry.getValue())).getDataVersion())) {
                    ++keyChangedCount;
                    ServerConfigurationFactory.this.namespaceConfigs.invalidate((Object)((NamespaceId)entry.getKey()));
                }
                this.jitterDelay();
            }
            for (Map.Entry entry : ServerConfigurationFactory.this.tableConfigs.asMap().entrySet()) {
                ++keyCount;
                TableId tid = (TableId)entry.getKey();
                TablePropKey propKey = TablePropKey.of(ServerConfigurationFactory.this.context, tid);
                if (!propStore.validateDataVersion(propKey, ((TableConfiguration)((Object)entry.getValue())).getDataVersion())) {
                    ++keyChangedCount;
                    ServerConfigurationFactory.this.tableConfigs.invalidate((Object)tid);
                    ServerConfigurationFactory.this.tableParentConfigs.invalidate((Object)tid);
                    log.debug("data version sync: difference found. forcing configuration update for {}}", (Object)propKey);
                }
                this.jitterDelay();
            }
            log.debug("data version sync: Total runtime {} ms for {} entries, changes detected: {}", new Object[]{TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - refreshStart), keyCount, keyChangedCount});
        }

        @SuppressFBWarnings(value={"PREDICTABLE_RANDOM"}, justification="random number not used in secure context")
        private long jitter(long min, long max) {
            return ThreadLocalRandom.current().nextLong(min, max);
        }

        private void jitterDelay() {
            try {
                Thread.sleep(this.jitter(1L, 23L));
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(ex);
            }
        }

        public void shutdown() {
            this.refreshTaskFuture.cancel(true);
        }
    }
}

