/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.compaction;

import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.accumulo.core.clientImpl.Namespace;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.spi.compaction.CompactionJob;
import org.apache.accumulo.core.spi.compaction.CompactionKind;
import org.apache.accumulo.core.util.Pair;
import org.apache.commons.lang3.Range;

public class CompactionJobPrioritizer {
    public static final Comparator<CompactionJob> JOB_COMPARATOR = Comparator.comparingInt(CompactionJob::getPriority).thenComparingInt(job -> job.getFiles().size()).reversed();
    private static final Map<Pair<TableId, CompactionKind>, Range<Short>> SYSTEM_TABLE_RANGES = new HashMap<Pair<TableId, CompactionKind>, Range<Short>>();
    private static final Map<Pair<NamespaceId, CompactionKind>, Range<Short>> ACCUMULO_NAMESPACE_RANGES = new HashMap<Pair<NamespaceId, CompactionKind>, Range<Short>>();
    static final Range<Short> ROOT_TABLE_USER = Range.of((Comparable)Short.valueOf((short)30768), (Comparable)Short.valueOf((short)Short.MAX_VALUE));
    static final Range<Short> ROOT_TABLE_SYSTEM = Range.of((Comparable)Short.valueOf((short)28768), (Comparable)Short.valueOf((short)30767));
    static final Range<Short> METADATA_TABLE_USER = Range.of((Comparable)Short.valueOf((short)26768), (Comparable)Short.valueOf((short)28767));
    static final Range<Short> METADATA_TABLE_SYSTEM = Range.of((Comparable)Short.valueOf((short)24768), (Comparable)Short.valueOf((short)26767));
    static final Range<Short> SYSTEM_NS_USER = Range.of((Comparable)Short.valueOf((short)22768), (Comparable)Short.valueOf((short)24767));
    static final Range<Short> SYSTEM_NS_SYSTEM = Range.of((Comparable)Short.valueOf((short)20768), (Comparable)Short.valueOf((short)22767));
    static final Range<Short> TABLE_OVER_SIZE = Range.of((Comparable)Short.valueOf((short)18768), (Comparable)Short.valueOf((short)20767));
    static final Range<Short> USER_TABLE_USER = Range.of((Comparable)Short.valueOf((short)1), (Comparable)Short.valueOf((short)18767));
    static final Range<Short> USER_TABLE_SYSTEM = Range.of((Comparable)Short.valueOf((short)Short.MIN_VALUE), (Comparable)Short.valueOf((short)0));

    public static short createPriority(NamespaceId nsId, TableId tableId, CompactionKind kind, final int totalFiles, final int compactingFiles, final int maxFilesPerTablet) {
        Objects.requireNonNull(nsId, "nsId cannot be null");
        Objects.requireNonNull(tableId, "tableId cannot be null");
        Preconditions.checkArgument((totalFiles >= 0 ? 1 : 0) != 0, (String)"totalFiles is negative %s", (int)totalFiles);
        Preconditions.checkArgument((compactingFiles >= 0 ? 1 : 0) != 0, (String)"compactingFiles is negative %s", (int)compactingFiles);
        Function<Range<Short>, Short> normalPriorityFunction = new Function<Range<Short>, Short>(){

            @Override
            public Short apply(Range<Short> f) {
                return (short)Math.min(((Short)f.getMaximum()).shortValue(), (Short)f.getMinimum() + totalFiles + compactingFiles);
            }
        };
        Function<Range<Short>, Short> tabletOverSizeFunction = new Function<Range<Short>, Short>(){

            @Override
            public Short apply(Range<Short> f) {
                return (short)Math.min(((Short)f.getMaximum()).shortValue(), (Short)f.getMinimum() + compactingFiles + (totalFiles - maxFilesPerTablet));
            }
        };
        CompactionKind calculationKind = kind;
        if (kind == CompactionKind.CHOP) {
            calculationKind = CompactionKind.USER;
        } else if (kind == CompactionKind.SELECTOR) {
            calculationKind = CompactionKind.SYSTEM;
        }
        Range<Short> range = null;
        Function<Range<Short>, Short> func = normalPriorityFunction;
        if (Namespace.ACCUMULO.id() == nsId) {
            range = SYSTEM_TABLE_RANGES.get(new Pair<TableId, CompactionKind>(tableId, calculationKind));
            if (range == null) {
                range = ACCUMULO_NAMESPACE_RANGES.get(new Pair<NamespaceId, CompactionKind>(nsId, calculationKind));
            }
        } else if (totalFiles > maxFilesPerTablet && calculationKind == CompactionKind.SYSTEM) {
            range = TABLE_OVER_SIZE;
            func = tabletOverSizeFunction;
        } else {
            range = calculationKind == CompactionKind.SYSTEM ? USER_TABLE_SYSTEM : USER_TABLE_USER;
        }
        if (range == null) {
            throw new IllegalStateException("Error calculating compaction priority for table: " + String.valueOf(tableId));
        }
        return func.apply(range);
    }

    static {
        SYSTEM_TABLE_RANGES.put(new Pair<TableId, CompactionKind>(RootTable.ID, CompactionKind.USER), ROOT_TABLE_USER);
        SYSTEM_TABLE_RANGES.put(new Pair<TableId, CompactionKind>(RootTable.ID, CompactionKind.SYSTEM), ROOT_TABLE_SYSTEM);
        SYSTEM_TABLE_RANGES.put(new Pair<TableId, CompactionKind>(MetadataTable.ID, CompactionKind.USER), METADATA_TABLE_USER);
        SYSTEM_TABLE_RANGES.put(new Pair<TableId, CompactionKind>(MetadataTable.ID, CompactionKind.SYSTEM), METADATA_TABLE_SYSTEM);
        ACCUMULO_NAMESPACE_RANGES.put(new Pair<NamespaceId, CompactionKind>(Namespace.ACCUMULO.id(), CompactionKind.USER), SYSTEM_NS_USER);
        ACCUMULO_NAMESPACE_RANGES.put(new Pair<NamespaceId, CompactionKind>(Namespace.ACCUMULO.id(), CompactionKind.SYSTEM), SYSTEM_NS_SYSTEM);
    }
}

