/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import org.apache.accumulo.core.spi.common.Stats;
import org.apache.commons.math3.stat.descriptive.moment.Mean;

public class Stat
implements Stats {
    long min;
    long max;
    long sum;
    Mean mean = new Mean();

    public Stat() {
        this.clear();
    }

    public void addStat(long stat) {
        this.min = Math.min(this.min, stat);
        this.max = Math.max(this.max, stat);
        this.sum += stat;
        this.mean.increment((double)stat);
    }

    @Override
    public long min() {
        return this.num() == 0L ? 0L : this.min;
    }

    @Override
    public long max() {
        return this.num() == 0L ? 0L : this.max;
    }

    @Override
    public long sum() {
        return this.sum;
    }

    @Override
    public double mean() {
        return this.mean.getResult();
    }

    public String toString() {
        return String.format("%,d %,d %,.2f %,d", this.min(), this.max(), this.mean(), this.mean.getN());
    }

    public void clear() {
        this.min = Long.MAX_VALUE;
        this.max = Long.MIN_VALUE;
        this.sum = 0L;
        this.mean.clear();
    }

    @Override
    public long num() {
        return this.mean.getN();
    }

    public Stat copy() {
        Stat stat = new Stat();
        stat.min = this.min;
        stat.max = this.max;
        stat.sum = this.sum;
        stat.mean = this.mean.copy();
        return stat;
    }
}

