/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.user;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.OptionDescriber;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.WrappingIterator;

public class VersioningIterator
extends WrappingIterator
implements OptionDescriber {
    private final int maxCount = 10;
    private final Key currentKey = new Key();
    private int numVersions;
    protected int maxVersions;
    private Range range;
    private Collection<ByteSequence> columnFamilies;
    private boolean inclusive;
    private static final String MAXVERSIONS_OPT = "maxVersions";

    public VersioningIterator deepCopy(IteratorEnvironment env) {
        VersioningIterator copy = new VersioningIterator();
        copy.setSource(this.getSource().deepCopy(env));
        copy.maxVersions = this.maxVersions;
        return copy;
    }

    @Override
    public void next() throws IOException {
        if (this.numVersions >= this.maxVersions) {
            this.skipRowColumn();
            this.resetVersionCount();
            return;
        }
        super.next();
        if (this.getSource().hasTop()) {
            if (this.getSource().getTopKey().equals(this.currentKey, PartialKey.ROW_COLFAM_COLQUAL_COLVIS)) {
                ++this.numVersions;
            } else {
                this.resetVersionCount();
            }
        }
    }

    @Override
    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        Range seekRange;
        this.range = seekRange = IteratorUtil.maximizeStartKeyTimeStamp(range);
        this.columnFamilies = columnFamilies;
        this.inclusive = inclusive;
        super.seek(seekRange, columnFamilies, inclusive);
        this.resetVersionCount();
        if (range.getStartKey() != null) {
            while (this.hasTop() && range.beforeStartKey(this.getTopKey())) {
                this.next();
            }
        }
    }

    private void resetVersionCount() {
        if (super.hasTop()) {
            this.currentKey.set(this.getSource().getTopKey());
        }
        this.numVersions = 1;
    }

    private void skipRowColumn() throws IOException {
        Key keyToSkip = this.currentKey;
        super.next();
        int count = 0;
        SortedKeyValueIterator<Key, Value> source = this.getSource();
        while (source.hasTop() && source.getTopKey().equals(keyToSkip, PartialKey.ROW_COLFAM_COLQUAL_COLVIS)) {
            if (count < 10) {
                source.next();
                ++count;
                continue;
            }
            this.reseek(keyToSkip.followingKey(PartialKey.ROW_COLFAM_COLQUAL_COLVIS));
            count = 0;
        }
    }

    protected void reseek(Key key) throws IOException {
        if (key == null) {
            return;
        }
        if (this.range.afterEndKey(key)) {
            this.range = new Range(this.range.getEndKey(), true, this.range.getEndKey(), this.range.isEndKeyInclusive());
            this.getSource().seek(this.range, this.columnFamilies, this.inclusive);
        } else {
            this.range = new Range(key, true, this.range.getEndKey(), this.range.isEndKeyInclusive());
            this.getSource().seek(this.range, this.columnFamilies, this.inclusive);
        }
    }

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        this.numVersions = 0;
        String maxVerString = options.get(MAXVERSIONS_OPT);
        this.maxVersions = maxVerString != null ? Integer.parseInt(maxVerString) : 1;
        if (this.maxVersions < 1) {
            throw new IllegalArgumentException("maxVersions for versioning iterator must be >= 1");
        }
    }

    @Override
    public OptionDescriber.IteratorOptions describeOptions() {
        return new OptionDescriber.IteratorOptions("vers", "The VersioningIterator keeps a fixed number of versions for each key", Collections.singletonMap(MAXVERSIONS_OPT, "number of versions to keep for a particular key (with differing timestamps)"), null);
    }

    @Override
    public boolean validateOptions(Map<String, String> options) {
        int i;
        try {
            i = Integer.parseInt(options.get(MAXVERSIONS_OPT));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("bad integer maxVersions:" + options.get(MAXVERSIONS_OPT));
        }
        if (i < 1) {
            throw new IllegalArgumentException("maxVersions for versioning iterator must be >= 1");
        }
        return true;
    }

    public static void setMaxVersions(IteratorSetting cfg, int maxVersions) {
        if (maxVersions < 1) {
            throw new IllegalArgumentException("maxVersions for versioning iterator must be >= 1");
        }
        cfg.addOption(MAXVERSIONS_OPT, Integer.toString(maxVersions));
    }
}

