/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.OptionDescriber;
import org.apache.accumulo.core.iterators.SkippingIterator;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.hadoop.io.Text;

public class FirstEntryInRowIterator
extends SkippingIterator
implements OptionDescriber {
    static final String NUM_SCANS_STRING_NAME = "scansBeforeSeek";
    private Range latestRange;
    private Collection<ByteSequence> latestColumnFamilies;
    private boolean latestInclusive;
    private Text lastRowFound;
    private int numscans;
    private boolean finished = true;

    public static void setNumScansBeforeSeek(IteratorSetting cfg, int num) {
        cfg.addOption(NUM_SCANS_STRING_NAME, Integer.toString(num));
    }

    public FirstEntryInRowIterator() {
    }

    public FirstEntryInRowIterator(FirstEntryInRowIterator other, IteratorEnvironment env) {
        this.setSource(other.getSource().deepCopy(env));
    }

    @Override
    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        return new FirstEntryInRowIterator(this, env);
    }

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        String o = options.get(NUM_SCANS_STRING_NAME);
        this.numscans = o == null ? 10 : Integer.parseInt(o);
    }

    @Override
    protected void consume() throws IOException {
        if (this.finished || this.lastRowFound == null) {
            return;
        }
        int count = 0;
        SortedKeyValueIterator<Key, Value> source = this.getSource();
        while (source.hasTop() && this.lastRowFound.equals((Object)source.getTopKey().getRow())) {
            if (count < this.numscans) {
                ++count;
                source.next();
                continue;
            }
            count = 0;
            Key nextKey = source.getTopKey().followingKey(PartialKey.ROW);
            if (this.latestRange.afterEndKey(nextKey)) {
                this.finished = true;
                break;
            }
            source.seek(new Range(nextKey, true, this.latestRange.getEndKey(), this.latestRange.isEndKeyInclusive()), this.latestColumnFamilies, this.latestInclusive);
        }
        this.lastRowFound = source.hasTop() ? source.getTopKey().getRow(this.lastRowFound) : null;
    }

    @Override
    public boolean hasTop() {
        return !this.finished && this.getSource().hasTop();
    }

    @Override
    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        this.latestRange = range;
        this.latestColumnFamilies = columnFamilies;
        this.latestInclusive = inclusive;
        this.lastRowFound = null;
        Key startKey = range.getStartKey();
        Range seekRange = new Range(startKey == null ? null : new Key(startKey.getRow()), true, range.getEndKey(), range.isEndKeyInclusive());
        super.seek(seekRange, columnFamilies, inclusive);
        this.finished = false;
        if (this.getSource().hasTop()) {
            this.lastRowFound = this.getSource().getTopKey().getRow();
            if (range.beforeStartKey(this.getSource().getTopKey())) {
                this.consume();
            }
        }
    }

    @Override
    public OptionDescriber.IteratorOptions describeOptions() {
        String name = "firstEntry";
        String desc = "Only allows iteration over the first entry per row";
        HashMap<String, String> namedOptions = new HashMap<String, String>();
        namedOptions.put(NUM_SCANS_STRING_NAME, "Number of scans to try before seeking [10]");
        return new OptionDescriber.IteratorOptions(name, desc, namedOptions, null);
    }

    @Override
    public boolean validateOptions(Map<String, String> options) {
        String o = options.get(NUM_SCANS_STRING_NAME);
        if (o != null && !NumberUtils.isParsable((String)o)) {
            throw new IllegalArgumentException("bad integer scansBeforeSeek:" + options.get(NUM_SCANS_STRING_NAME));
        }
        return true;
    }
}

