/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.rest.logs;

import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.List;
import org.apache.accumulo.monitor.Monitor;
import org.apache.accumulo.monitor.rest.logs.SanitizedLogEvent;
import org.apache.accumulo.monitor.rest.logs.SingleLogEvent;

@Path(value="/logs")
@Produces(value={"application/json", "application/xml"})
public class LogResource {
    @Inject
    private Monitor monitor;

    @GET
    public List<SanitizedLogEvent> getRecentLogs() {
        return this.monitor.recentLogs().getSanitizedEvents();
    }

    @POST
    @Path(value="clear")
    public void clearLogs() {
        this.monitor.recentLogs().clearEvents();
    }

    @POST
    @Path(value="append")
    @Consumes(value={"application/json"})
    public void append(SingleLogEvent event) {
        this.monitor.recentLogs().addEvent(event);
    }
}

