/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.classloader.ClassLoaderUtil;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.SampleNotPresentException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.conf.ConfigurationTypeHelper;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.format.Formatter;
import org.apache.accumulo.core.util.format.FormatterConfig;
import org.apache.accumulo.core.util.interpret.DefaultScanInterpreter;
import org.apache.accumulo.core.util.interpret.ScanInterpreter;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.ShellCommandException;
import org.apache.accumulo.shell.ShellUtil;
import org.apache.accumulo.shell.commands.EGrepCommand;
import org.apache.accumulo.shell.commands.GrepCommand;
import org.apache.accumulo.shell.commands.InterpreterCommand;
import org.apache.accumulo.shell.commands.OptUtil;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.hadoop.io.Text;

public class ScanCommand
extends Shell.Command {
    private Option scanOptAuths;
    private Option scanOptRow;
    private Option scanOptColumns;
    private Option disablePaginationOpt;
    private Option formatterOpt;
    private Option interpreterOpt;
    private Option formatterInterpreterOpt;
    private Option outputFileOpt;
    private Option scanOptCf;
    private Option scanOptCq;
    protected Option showFewOpt;
    protected Option timestampOpt;
    protected Option profileOpt;
    private Option optStartRowExclusive;
    private Option optStartRowInclusive;
    private Option optEndRowExclusive;
    private Option timeoutOption;
    private Option sampleOpt;
    private Option contextOpt;
    private Option executionHintsOpt;
    private Option scanServerOpt;

    protected void setupSampling(String tableName, CommandLine cl, Shell shellState, ScannerBase scanner) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
        if (this.getUseSample(cl)) {
            SamplerConfiguration samplerConfig = shellState.getAccumuloClient().tableOperations().getSamplerConfiguration(tableName);
            if (samplerConfig == null) {
                throw new SampleNotPresentException("Table " + tableName + " does not have sampling configured");
            }
            Shell.log.debug("Using sampling configuration : {}", (Object)samplerConfig);
            scanner.setSamplerConfiguration(samplerConfig);
        }
    }

    protected ScannerBase.ConsistencyLevel getConsistency(CommandLine cl) {
        if (cl.hasOption(this.scanServerOpt.getOpt())) {
            String arg = cl.getOptionValue(this.scanServerOpt.getOpt());
            return ScannerBase.ConsistencyLevel.valueOf((String)arg.toUpperCase());
        }
        return ScannerBase.ConsistencyLevel.IMMEDIATE;
    }

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        try (Shell.PrintFile printFile = this.getOutputFile(cl);){
            String tableName = OptUtil.getTableOpt(cl, shellState);
            Class<? extends Formatter> formatter = this.getFormatter(cl, tableName, shellState);
            ScanInterpreter interpreter = this.getInterpreter(cl, tableName, shellState);
            String classLoaderContext = null;
            if (cl.hasOption(this.contextOpt.getOpt())) {
                classLoaderContext = cl.getOptionValue(this.contextOpt.getOpt());
            }
            Authorizations auths = this.getAuths(cl, shellState);
            Scanner scanner = shellState.getAccumuloClient().createScanner(tableName, auths);
            if (classLoaderContext != null) {
                scanner.setClassLoaderContext(classLoaderContext);
            }
            this.addScanIterators(shellState, cl, (ScannerBase)scanner, tableName);
            scanner.setRange(this.getRange(cl, interpreter));
            this.fetchColumns(cl, (ScannerBase)scanner, interpreter);
            scanner.setTimeout(this.getTimeout(cl), TimeUnit.MILLISECONDS);
            this.setupSampling(tableName, cl, shellState, (ScannerBase)scanner);
            scanner.setExecutionHints(ShellUtil.parseMapOpt(cl, this.executionHintsOpt));
            try {
                scanner.setConsistencyLevel(this.getConsistency(cl));
            }
            catch (IllegalArgumentException e) {
                Shell.log.error("Consistency Level argument must be immediate or eventual", (Throwable)e);
            }
            FormatterConfig config = new FormatterConfig();
            config.setPrintTimestamps(cl.hasOption(this.timestampOpt.getOpt()));
            if (cl.hasOption(this.showFewOpt.getOpt())) {
                String showLength = cl.getOptionValue(this.showFewOpt.getOpt());
                try {
                    int length = Integer.parseInt(showLength);
                    config.setShownLength(length);
                }
                catch (NumberFormatException nfe) {
                    Shell.log.error("Arg must be an integer.", (Throwable)nfe);
                }
                catch (IllegalArgumentException iae) {
                    Shell.log.error("Invalid length argument", (Throwable)iae);
                }
            }
            this.printRecords(cl, shellState, config, (Iterable<Map.Entry<Key, Value>>)scanner, formatter, printFile);
        }
        return 0;
    }

    protected boolean getUseSample(CommandLine cl) {
        return cl.hasOption(this.sampleOpt.getLongOpt());
    }

    protected long getTimeout(CommandLine cl) {
        if (cl.hasOption(this.timeoutOption.getLongOpt())) {
            return ConfigurationTypeHelper.getTimeInMillis((String)cl.getOptionValue(this.timeoutOption.getLongOpt()));
        }
        return Long.MAX_VALUE;
    }

    static void ensureTserversCanLoadIterator(Shell shellState, String tableName, String classname) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, ShellCommandException {
        if (!shellState.getAccumuloClient().tableOperations().testClassLoad(tableName, classname, SortedKeyValueIterator.class.getName())) {
            throw new ShellCommandException(ShellCommandException.ErrorCode.INITIALIZATION_FAILURE, "Servers are unable to load " + classname + " as type " + SortedKeyValueIterator.class.getName());
        }
    }

    protected void addScanIterators(Shell shellState, CommandLine cl, ScannerBase scanner, String tableName) throws Exception {
        List<IteratorSetting> tableScanIterators;
        if (cl.hasOption(this.profileOpt.getOpt())) {
            String profile = cl.getOptionValue(this.profileOpt.getOpt());
            tableScanIterators = shellState.iteratorProfiles.get(profile);
            if (tableScanIterators == null) {
                throw new IllegalArgumentException("Profile " + profile + " does not exist");
            }
            for (IteratorSetting iteratorSetting : tableScanIterators) {
                ScanCommand.ensureTserversCanLoadIterator(shellState, tableName, iteratorSetting.getIteratorClass());
            }
        } else {
            tableScanIterators = shellState.scanIteratorOptions.get(tableName);
            if (tableScanIterators == null) {
                Shell.log.debug("Found no scan iterators to set");
                return;
            }
        }
        Shell.log.debug("Found {} scan iterators to set", (Object)tableScanIterators.size());
        for (IteratorSetting setting : tableScanIterators) {
            Shell.log.debug("Setting scan iterator {} at priority {} using class name {}", new Object[]{setting.getName(), setting.getPriority(), setting.getIteratorClass()});
            for (Map.Entry option : setting.getOptions().entrySet()) {
                Shell.log.debug("Setting option for {}: {}={}", new Object[]{setting.getName(), option.getKey(), option.getValue()});
            }
            scanner.addScanIterator(setting);
        }
    }

    protected void printRecords(CommandLine cl, Shell shellState, FormatterConfig config, Iterable<Map.Entry<Key, Value>> scanner, Class<? extends Formatter> formatter, Shell.PrintFile outFile) throws IOException {
        if (outFile == null) {
            shellState.printRecords(scanner, config, !cl.hasOption(this.disablePaginationOpt.getOpt()), formatter);
        } else {
            shellState.printRecords(scanner, config, !cl.hasOption(this.disablePaginationOpt.getOpt()), formatter, outFile);
        }
    }

    @Deprecated(since="2.1.0")
    protected ScanInterpreter getInterpreter(CommandLine cl, String tableName, Shell shellState) throws Exception {
        Class clazz = null;
        try {
            if (cl.hasOption(this.interpreterOpt.getOpt())) {
                Shell.log.warn("Scan Interpreter option is deprecated and will be removed in a future version.");
                clazz = ClassLoaderUtil.loadClass((String)cl.getOptionValue(this.interpreterOpt.getOpt()), ScanInterpreter.class);
            } else if (cl.hasOption(this.formatterInterpreterOpt.getOpt())) {
                Shell.log.warn("Scan Interpreter option is deprecated and will be removed in a future version.");
                clazz = ClassLoaderUtil.loadClass((String)cl.getOptionValue(this.formatterInterpreterOpt.getOpt()), ScanInterpreter.class);
            }
        }
        catch (ClassNotFoundException e) {
            Shell.log.error("Interpreter class could not be loaded.", (Throwable)e);
        }
        if (clazz == null) {
            clazz = InterpreterCommand.getCurrentInterpreter(tableName, shellState);
        }
        if (clazz == null) {
            clazz = DefaultScanInterpreter.class;
        }
        return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    protected Class<? extends Formatter> getFormatter(CommandLine cl, String tableName, Shell shellState) throws IOException {
        try {
            if (cl.hasOption(this.formatterOpt.getOpt())) {
                Shell.log.warn("Formatter option is deprecated and will be removed in a future version.");
                return shellState.getClassLoader(cl, shellState).loadClass(cl.getOptionValue(this.formatterOpt.getOpt())).asSubclass(Formatter.class);
            }
            if (cl.hasOption(this.formatterInterpreterOpt.getOpt())) {
                Shell.log.warn("Formatter option is deprecated and will be removed in a future version.");
                return shellState.getClassLoader(cl, shellState).loadClass(cl.getOptionValue(this.formatterInterpreterOpt.getOpt())).asSubclass(Formatter.class);
            }
        }
        catch (Exception e) {
            Shell.log.error("Formatter class could not be loaded.", (Throwable)e);
        }
        return shellState.getFormatter(tableName);
    }

    protected void fetchColumns(CommandLine cl, ScannerBase scanner, ScanInterpreter interpreter) throws UnsupportedEncodingException {
        block7: {
            block5: {
                String cf;
                block6: {
                    if (!cl.hasOption(this.scanOptCf.getOpt()) && !cl.hasOption(this.scanOptCq.getOpt())) break block5;
                    if (cl.hasOption(this.scanOptColumns.getOpt())) {
                        String formattedString = String.format("Option -%s is mutually exclusive with options -%s and -%s.", this.scanOptColumns.getOpt(), this.scanOptCf.getOpt(), this.scanOptCq.getOpt());
                        throw new IllegalArgumentException(formattedString);
                    }
                    cf = cl.getOptionValue(this.scanOptCf.getOpt(), "");
                    String cq = cl.getOptionValue(this.scanOptCq.getOpt(), "");
                    if (cq.isEmpty()) break block6;
                    if (cf.isEmpty()) {
                        String formattedString = String.format("Option -%s is required when using -%s.", this.scanOptCf.getOpt(), this.scanOptCq.getOpt());
                        throw new IllegalArgumentException(formattedString);
                    }
                    Text interprettedCF = interpreter.interpretColumnFamily(new Text(cf.getBytes(Shell.CHARSET)));
                    Text interprettedCQ = interpreter.interpretColumnQualifier(new Text(cq.getBytes(Shell.CHARSET)));
                    scanner.fetchColumn(interprettedCF, interprettedCQ);
                    break block7;
                }
                if (cf.isEmpty()) break block7;
                Text interprettedCF = interpreter.interpretColumnFamily(new Text(cf.getBytes(Shell.CHARSET)));
                scanner.fetchColumnFamily(interprettedCF);
                break block7;
            }
            if (cl.hasOption(this.scanOptColumns.getOpt())) {
                for (String a : cl.getOptionValue(this.scanOptColumns.getOpt()).split(",")) {
                    Text interprettedCF;
                    String[] sa = a.split(":", 2);
                    if (sa.length == 1) {
                        interprettedCF = interpreter.interpretColumnFamily(new Text(a.getBytes(Shell.CHARSET)));
                        scanner.fetchColumnFamily(interprettedCF);
                        continue;
                    }
                    interprettedCF = interpreter.interpretColumnFamily(new Text(sa[0].getBytes(Shell.CHARSET)));
                    Text interprettedCQ = interpreter.interpretColumnQualifier(new Text(sa[1].getBytes(Shell.CHARSET)));
                    scanner.fetchColumn(interprettedCF, interprettedCQ);
                }
            }
        }
    }

    protected Range getRange(CommandLine cl, ScanInterpreter formatter) throws UnsupportedEncodingException {
        Text endRow;
        if ((cl.hasOption("b") || cl.hasOption("e")) && cl.hasOption(this.scanOptRow.getOpt())) {
            throw new IllegalArgumentException("Options -" + this.scanOptRow.getOpt() + " AND (-b OR -e) are mutually exclusive ");
        }
        if (cl.hasOption(this.scanOptRow.getOpt())) {
            Text interprettedRow = formatter.interpretRow(new Text(cl.getOptionValue(this.scanOptRow.getOpt()).getBytes(Shell.CHARSET)));
            return new Range(interprettedRow);
        }
        Text startRow = OptUtil.getStartRow(cl);
        if (startRow != null) {
            Text interprettedBeginRow;
            startRow = interprettedBeginRow = formatter.interpretBeginRow(startRow);
        }
        if ((endRow = OptUtil.getEndRow(cl)) != null) {
            Text interprettedEndRow;
            endRow = interprettedEndRow = formatter.interpretEndRow(endRow);
        }
        boolean startInclusive = !cl.hasOption(this.optStartRowExclusive.getOpt());
        boolean endInclusive = !cl.hasOption(this.optEndRowExclusive.getOpt());
        return new Range(startRow, startInclusive, endRow, endInclusive);
    }

    protected Authorizations getAuths(CommandLine cl, Shell shellState) throws AccumuloSecurityException, AccumuloException {
        String user = shellState.getAccumuloClient().whoami();
        Authorizations auths = shellState.getAccumuloClient().securityOperations().getUserAuthorizations(user);
        if (cl.hasOption(this.scanOptAuths.getOpt())) {
            auths = ScanCommand.parseAuthorizations(cl.getOptionValue(this.scanOptAuths.getOpt()));
        }
        return auths;
    }

    static Authorizations parseAuthorizations(String field) {
        if (field == null || field.isEmpty()) {
            return Authorizations.EMPTY;
        }
        return new Authorizations(field.split(","));
    }

    @Override
    public String description() {
        return "scans the table, and displays the resulting records";
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        this.scanOptAuths = new Option("s", "scan-authorizations", true, "scan authorizations (all user auths are used if this argument is not specified)");
        this.optStartRowExclusive = new Option("be", "begin-exclusive", false, "make start row exclusive (by default it's inclusive)");
        this.optStartRowExclusive.setArgName("begin-exclusive");
        this.optEndRowExclusive = new Option("ee", "end-exclusive", false, "make end row exclusive (by default it's inclusive)");
        this.optEndRowExclusive.setArgName("end-exclusive");
        this.scanOptRow = new Option("r", "row", true, "row to scan");
        this.scanOptColumns = new Option("c", "columns", true, "comma-separated columns. This option is mutually exclusive with cf and cq");
        this.scanOptCf = new Option("cf", "column-family", true, "column family to scan.");
        this.scanOptCq = new Option("cq", "column-qualifier", true, "column qualifier to scan");
        this.timestampOpt = new Option("st", "show-timestamps", false, "display timestamps");
        this.disablePaginationOpt = new Option("np", "no-pagination", false, "disable pagination of output");
        this.showFewOpt = new Option("f", "show-few", true, "show only a specified number of characters");
        this.formatterOpt = new Option("fm", "formatter", true, "fully qualified name of the formatter class to use");
        this.interpreterOpt = new Option("i", "interpreter", true, "fully qualified name of the interpreter class to use");
        this.formatterInterpreterOpt = new Option("fi", "fmt-interpreter", true, "fully qualified name of a class that is a formatter and interpreter");
        this.timeoutOption = new Option(null, "timeout", true, "time before scan should fail if no data is returned. If no unit is given assumes seconds. Units d,h,m,s,and ms are supported. e.g. 30s or 100ms");
        this.outputFileOpt = new Option("o", "output", true, "local file to write the scan output to");
        this.sampleOpt = new Option(null, "sample", false, "Show sample");
        this.contextOpt = new Option("cc", "context", true, "name of the classloader context");
        this.executionHintsOpt = new Option(null, "execution-hints", true, "Execution hints map");
        this.scanServerOpt = new Option("cl", "consistency-level", true, "set consistency level (experimental)");
        this.scanOptAuths.setArgName("comma-separated-authorizations");
        this.scanOptRow.setArgName("row");
        this.scanOptColumns.setArgName("<columnfamily>[:<columnqualifier>]{,<columnfamily>[:<columnqualifier>]}");
        this.scanOptCf.setArgName("column-family");
        this.scanOptCq.setArgName("column-qualifier");
        this.showFewOpt.setRequired(false);
        this.showFewOpt.setArgName("int");
        this.formatterOpt.setArgName("className");
        this.timeoutOption.setArgName("timeout");
        this.outputFileOpt.setArgName("file");
        this.contextOpt.setArgName("context");
        this.executionHintsOpt.setArgName("<key>=<value>{,<key>=<value>}");
        this.scanServerOpt.setArgName("immediate|eventual");
        this.profileOpt = new Option("pn", "profile", true, "iterator profile name");
        this.profileOpt.setArgName("profile");
        o.addOption(this.scanOptAuths);
        o.addOption(this.scanOptRow);
        this.optStartRowInclusive = new Option("b", "begin-row", true, "begin row (inclusive)");
        this.optStartRowInclusive.setArgName("begin-row");
        o.addOption(this.optStartRowInclusive);
        o.addOption(OptUtil.endRowOpt());
        o.addOption(this.optStartRowExclusive);
        o.addOption(this.optEndRowExclusive);
        o.addOption(this.scanOptColumns);
        o.addOption(this.scanOptCf);
        o.addOption(this.scanOptCq);
        o.addOption(this.timestampOpt);
        o.addOption(this.disablePaginationOpt);
        o.addOption(OptUtil.tableOpt("table to be scanned"));
        o.addOption(this.formatterOpt);
        o.addOption(this.interpreterOpt);
        o.addOption(this.formatterInterpreterOpt);
        o.addOption(this.timeoutOption);
        if (Arrays.asList(ScanCommand.class.getName(), GrepCommand.class.getName(), EGrepCommand.class.getName()).contains(this.getClass().getName())) {
            o.addOption(this.outputFileOpt);
            o.addOption(this.showFewOpt);
        }
        o.addOption(this.profileOpt);
        o.addOption(this.sampleOpt);
        o.addOption(this.contextOpt);
        o.addOption(this.executionHintsOpt);
        o.addOption(this.scanServerOpt);
        return o;
    }

    @Override
    public int numArgs() {
        return 0;
    }

    protected Shell.PrintFile getOutputFile(CommandLine cl) throws FileNotFoundException {
        String outputFile = cl.getOptionValue(this.outputFileOpt.getOpt());
        return outputFile == null ? null : new Shell.PrintFile(outputFile);
    }
}

