/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.accumulo.core.manager.thrift.ManagerMonitorInfo;
import org.apache.accumulo.core.master.thrift.BulkImportStatus;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.util.DurationFormat;

public class BulkImportListIterator
implements Iterator<String> {
    private final Iterator<String> iter;

    public BulkImportListIterator(List<String> tservers, ManagerMonitorInfo stats) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (BulkImportStatus status : stats.getBulkImports()) {
            result.add(this.format(status));
        }
        if (!tservers.isEmpty()) {
            for (TabletServerStatus tserver : stats.getTServerInfo()) {
                if (!tservers.contains(tserver.name)) continue;
                result.add(tserver.name + ":");
                for (BulkImportStatus status : tserver.bulkImports) {
                    result.add(this.format(status));
                }
            }
        }
        this.iter = result.iterator();
    }

    private String format(BulkImportStatus status) {
        long diff = System.currentTimeMillis() - status.startTime;
        DurationFormat dur = new DurationFormat(diff, " ");
        return String.format("%25s | %4s | %s", status.filename, dur, status.state);
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public String next() {
        return this.iter.next();
    }

    @Override
    public void remove() {
        this.iter.remove();
    }
}

