/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.properties.css3.CssGridAutoRows;
import org.w3c.css.properties.css3.CssGridTemplateAreas;
import org.w3c.css.properties.css3.CssGridTemplateColumns;
import org.w3c.css.properties.css3.CssGridTemplateRows;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssBracket;
import org.w3c.css.values.CssCheckableValue;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssFunction;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssGridTemplate
extends org.w3c.css.properties.css.CssGridTemplate {
    public static final CssIdent[] allowed_repeat_values;
    public static final String repeat_func = "repeat";
    private CssGridTemplateAreas cssGridTemplateAreas;
    private CssGridTemplateColumns cssGridTemplateColumns;
    private CssGridTemplateRows cssGridTemplateRows;

    public CssGridTemplate() {
        this.value = initial;
        this.cssGridTemplateAreas = new CssGridTemplateAreas();
        this.cssGridTemplateColumns = new CssGridTemplateColumns();
        this.cssGridTemplateRows = new CssGridTemplateRows();
    }

    public CssGridTemplate(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        this.setByUser();
        this.cssGridTemplateAreas = new CssGridTemplateAreas();
        this.cssGridTemplateColumns = new CssGridTemplateColumns();
        this.cssGridTemplateRows = new CssGridTemplateRows();
        this.value = CssGridTemplate.parseGridTemplate(ac, expression, this, this.cssGridTemplateAreas, this.cssGridTemplateColumns, this.cssGridTemplateRows);
    }

    protected static CssValue parseGridTemplate(ApplContext ac, CssExpression expression, CssProperty caller, CssGridTemplateAreas areas, CssGridTemplateColumns columns, CssGridTemplateRows rows) throws InvalidParamException {
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        ArrayList<CssValue> areaValues = new ArrayList<CssValue>();
        ArrayList<CssValue> columnValues = new ArrayList<CssValue>();
        ArrayList<CssValue> rowValues = new ArrayList<CssValue>();
        CssValue val = null;
        if (expression.getCount() == 1) {
            val = expression.getValue();
            if (val.getType() != 0) {
                throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
            }
            CssIdent id = val.getIdent();
            if (!none.equals(id) && !CssIdent.isCssWide(id)) {
                throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
            }
            values.add(val);
            areaValues.add(val);
            columnValues.add(val);
            rowValues.add(val);
            expression.next();
        } else {
            boolean got_string = false;
            while (!expression.end() && !got_string) {
                val = expression.getValue();
                got_string = val.getType() == 1;
                expression.next();
            }
            expression.starts();
            if (!got_string) {
                char op;
                CssExpression nex = new CssExpression();
                boolean got_slash = false;
                while (!got_slash && !expression.end()) {
                    val = expression.getValue();
                    op = expression.getOperator();
                    boolean bl = got_slash = val.getType() == 14;
                    if (got_slash) {
                        if (op != ' ') {
                            throw new InvalidParamException("operator", Character.valueOf(op), caller.getPropertyName(), ac);
                        }
                    } else {
                        nex.addValue(val);
                        nex.setOperator(op);
                    }
                    expression.next();
                }
                if (!got_slash) {
                    throw new InvalidParamException("unrecognize", ac);
                }
                CssValue v = CssGridTemplate.parseTemplateRows(ac, nex, caller);
                rowValues.add(v);
                values.add(v);
                values.add(val);
                nex = new CssExpression();
                while (!expression.end()) {
                    val = expression.getValue();
                    op = expression.getOperator();
                    nex.addValue(val);
                    nex.setOperator(op);
                    expression.next();
                }
                v = CssGridTemplate.parseTemplateRows(ac, nex, caller);
                columnValues.add(v);
                values.add(v);
                areaValues.add(none);
            } else {
                CssValue v;
                char op;
                boolean got_slash = false;
                CssExpression nex = new CssExpression();
                boolean in_line_names = false;
                int got_line_names = 1;
                while (!got_slash && !expression.end()) {
                    val = expression.getValue();
                    op = expression.getOperator();
                    switch (val.getType()) {
                        case 1: {
                            if (in_line_names) {
                                throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
                            }
                            got_line_names = 0;
                            areaValues.add(val);
                            values.add(val);
                            break;
                        }
                        case 22: {
                            CssBracket bracket = (CssBracket)val;
                            if (bracket.isLeft()) {
                                if (in_line_names || got_line_names > 2) {
                                    throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
                                }
                                in_line_names = true;
                            } else {
                                if (!in_line_names) {
                                    throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
                                }
                                ++got_line_names;
                                in_line_names = false;
                            }
                            values.add(val);
                            rowValues.add(val);
                            break;
                        }
                        case 14: {
                            got_slash = true;
                            values.add(val);
                            break;
                        }
                        case 0: {
                            if (in_line_names) {
                                values.add(val);
                                rowValues.add(val);
                                break;
                            }
                        }
                        default: {
                            v = CssGridAutoRows.parseTrackSize(ac, val, caller);
                            values.add(v);
                            rowValues.add(v);
                        }
                    }
                    if (op != ' ') {
                        throw new InvalidParamException("operator", Character.valueOf(op), caller.getPropertyName(), ac);
                    }
                    expression.next();
                }
                if (got_slash) {
                    while (!expression.end()) {
                        val = expression.getValue();
                        op = expression.getOperator();
                        nex.addValue(val);
                        nex.setOperator(op);
                        expression.next();
                    }
                    v = CssGridTemplate.parseExplicitTrackList(ac, nex, caller);
                    columnValues.add(v);
                    values.add(v);
                } else {
                    columnValues.add(none);
                }
            }
        }
        if (areas != null) {
            CssValue cssValue = areas.value = areaValues.size() == 1 ? (CssValue)areaValues.get(0) : new CssValueList(areaValues);
        }
        if (columns != null) {
            CssValue cssValue = columns.value = columnValues.size() == 1 ? (CssValue)columnValues.get(0) : new CssValueList(columnValues);
        }
        if (rows != null) {
            rows.value = rowValues.size() == 1 ? (CssValue)rowValues.get(0) : new CssValueList(rowValues);
        }
        return values.size() == 1 ? (CssValue)values.get(0) : new CssValueList(values);
    }

    public CssGridTemplate(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public static CssIdent getAllowedRepeatIdent(CssIdent ident) {
        for (CssIdent id : allowed_repeat_values) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    protected static CssValue parseTemplateRows(ApplContext ac, CssExpression exp, CssProperty caller) throws InvalidParamException {
        CssValue val;
        if (exp.getCount() == 1 && (val = exp.getValue()).getType() == 0 && none.equals(val.getIdent())) {
            exp.next();
            return val;
        }
        exp.mark();
        try {
            return CssGridTemplate.parseTrackList(ac, exp, caller);
        }
        catch (InvalidParamException ex) {
            exp.reset();
            return CssGridTemplate.parseAutoTrackList(ac, exp, caller);
        }
    }

    protected static CssValue parseTrackList(ApplContext ac, CssExpression exp, CssProperty caller) throws InvalidParamException {
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        boolean in_line_names = false;
        boolean got_line_names = false;
        boolean got_size = false;
        while (!exp.end()) {
            CssValue val = exp.getValue();
            char op = exp.getOperator();
            switch (val.getType()) {
                case 22: {
                    CssBracket bracket = (CssBracket)val;
                    if (bracket.isLeft()) {
                        if (in_line_names || got_line_names) {
                            throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
                        }
                        in_line_names = true;
                    } else {
                        if (!in_line_names) {
                            throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
                        }
                        got_line_names = true;
                        in_line_names = false;
                    }
                    values.add(val);
                    break;
                }
                case 0: {
                    if (in_line_names) {
                        values.add(val);
                        break;
                    }
                    values.add(CssGridAutoRows.parseTrackSize(ac, val, caller));
                    got_line_names = false;
                    got_size = true;
                    break;
                }
                case 11: {
                    CssFunction function = val.getFunction();
                    if (repeat_func.equals(function.getName())) {
                        CssGridTemplate.parseRepeatFunction(ac, function, RepeatType.TRACK_REPEAT, caller);
                        values.add(val);
                        got_line_names = false;
                        got_size = true;
                        break;
                    }
                }
                default: {
                    values.add(CssGridAutoRows.parseTrackSize(ac, val, caller));
                    got_size = true;
                    got_line_names = false;
                }
            }
            if (op != ' ') {
                throw new InvalidParamException("operator", Character.valueOf(op), caller.getPropertyName(), ac);
            }
            exp.next();
        }
        if (values.isEmpty() || !got_size) {
            throw new InvalidParamException("unrecognize", ac);
        }
        return values.size() == 1 ? (CssValue)values.get(0) : new CssValueList(values);
    }

    protected static CssValue parseExplicitTrackList(ApplContext ac, CssExpression exp, CssProperty caller) throws InvalidParamException {
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        boolean in_line_names = false;
        boolean got_line_names = false;
        boolean got_size = false;
        while (!exp.end()) {
            CssValue val = exp.getValue();
            char op = exp.getOperator();
            switch (val.getType()) {
                case 22: {
                    CssBracket bracket = (CssBracket)val;
                    if (bracket.isLeft()) {
                        if (in_line_names || got_line_names) {
                            throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
                        }
                        in_line_names = true;
                    } else {
                        if (!in_line_names) {
                            throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
                        }
                        got_line_names = true;
                        in_line_names = false;
                    }
                    values.add(val);
                    break;
                }
                case 0: {
                    if (in_line_names) {
                        values.add(val);
                        break;
                    }
                }
                default: {
                    values.add(CssGridAutoRows.parseTrackSize(ac, val, caller));
                    got_size = true;
                    got_line_names = false;
                }
            }
            if (op != ' ') {
                throw new InvalidParamException("operator", Character.valueOf(op), caller.getPropertyName(), ac);
            }
            exp.next();
        }
        if (values.isEmpty() || !got_size) {
            throw new InvalidParamException("unrecognize", ac);
        }
        return values.size() == 1 ? (CssValue)values.get(0) : new CssValueList(values);
    }

    protected static CssValue parseAutoTrackList(ApplContext ac, CssExpression exp, CssProperty caller) throws InvalidParamException {
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        boolean in_line_names = false;
        boolean got_line_names = false;
        boolean got_auto = false;
        while (!exp.end()) {
            CssValue val = exp.getValue();
            char op = exp.getOperator();
            switch (val.getType()) {
                case 22: {
                    CssBracket bracket = (CssBracket)val;
                    if (bracket.isLeft()) {
                        if (in_line_names || got_line_names) {
                            throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
                        }
                        in_line_names = true;
                    } else {
                        if (!in_line_names) {
                            throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
                        }
                        got_line_names = true;
                        in_line_names = false;
                    }
                    values.add(val);
                    break;
                }
                case 0: {
                    if (in_line_names) {
                        values.add(val);
                        break;
                    }
                    throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
                }
                case 11: {
                    CssFunction function = val.getFunction();
                    if (repeat_func.equals(function.getName())) {
                        if (exp.getRemainingCount() == 1) {
                            CssGridTemplate.parseRepeatFunction(ac, function, RepeatType.AUTO_REPEAT, caller);
                            values.add(val);
                            got_auto = true;
                        } else {
                            CssGridTemplate.parseRepeatFunction(ac, function, RepeatType.FIXED_REPEAT, caller);
                            values.add(val);
                        }
                        got_line_names = false;
                        break;
                    }
                }
                default: {
                    values.add(CssGridAutoRows.parseTrackSize(ac, val, caller));
                    got_line_names = false;
                }
            }
            if (op != ' ') {
                throw new InvalidParamException("operator", Character.valueOf(op), caller.getPropertyName(), ac);
            }
            exp.next();
        }
        if (values.isEmpty() || !got_auto) {
            throw new InvalidParamException("unrecognize", ac);
        }
        return values.size() == 1 ? (CssValue)values.get(0) : new CssValueList(values);
    }

    protected static CssFunction parseRepeatFunction(ApplContext ac, CssFunction func, RepeatType type, CssProperty caller) throws InvalidParamException {
        CssExpression exp = func.getParameters();
        if (exp.getCount() < 2) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssExpression nex = new CssExpression();
        CssValue val = exp.getValue();
        char op = exp.getOperator();
        switch (val.getType()) {
            case 0: {
                if (CssGridTemplate.getAllowedRepeatIdent(val.getIdent()) != null && type == RepeatType.AUTO_REPEAT) break;
                throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
            }
            case 5: {
                if (type != RepeatType.TRACK_REPEAT && type != RepeatType.FIXED_REPEAT) {
                    throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
                }
                CssCheckableValue v = val.getCheckableValue();
                v.checkInteger(ac, caller);
                v.checkPositiveness(ac, caller);
                break;
            }
            default: {
                throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
            }
        }
        if (op != ',') {
            throw new InvalidParamException("operator", Character.valueOf(op), caller.getPropertyName(), ac);
        }
        exp.next();
        boolean got_line_names = false;
        boolean in_line_names = false;
        while (!exp.end()) {
            val = exp.getValue();
            op = exp.getOperator();
            switch (val.getType()) {
                case 22: {
                    CssBracket bracket = (CssBracket)val;
                    if (bracket.isLeft()) {
                        if (in_line_names || got_line_names) {
                            throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
                        }
                        in_line_names = true;
                        break;
                    }
                    if (!in_line_names) {
                        throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
                    }
                    got_line_names = true;
                    in_line_names = false;
                    break;
                }
                case 0: {
                    if (in_line_names) break;
                }
                case 21: {
                    if (type != RepeatType.TRACK_REPEAT) break;
                    CssGridAutoRows.parseTrackSize(ac, val, caller);
                    got_line_names = false;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 11: {
                    switch (type) {
                        case AUTO_REPEAT: 
                        case FIXED_REPEAT: {
                            CssGridAutoRows.parseFixedSize(ac, val, caller);
                            break;
                        }
                        case TRACK_REPEAT: {
                            CssGridAutoRows.parseTrackSize(ac, val, caller);
                            break;
                        }
                        default: {
                            throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
                        }
                    }
                    got_line_names = false;
                    break;
                }
                default: {
                    throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
                }
            }
            if (op != ' ') {
                throw new InvalidParamException("operator", Character.valueOf(op), caller.getPropertyName(), ac);
            }
            exp.next();
        }
        exp.starts();
        if (in_line_names) {
            throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
        }
        return func;
    }

    @Override
    public void addToStyle(ApplContext ac, CssStyle style) {
        super.addToStyle(ac, style);
        this.cssGridTemplateAreas.addToStyle(ac, style);
        this.cssGridTemplateColumns.addToStyle(ac, style);
        this.cssGridTemplateRows.addToStyle(ac, style);
    }

    static {
        String[] _allowed_repeat_values = new String[]{"auto-fill", "auto-fit"};
        allowed_repeat_values = new CssIdent[_allowed_repeat_values.length];
        int i = 0;
        for (String s : _allowed_repeat_values) {
            CssGridTemplate.allowed_repeat_values[i++] = CssIdent.getIdent(s);
        }
    }

    protected static enum RepeatType {
        TRACK_REPEAT,
        AUTO_REPEAT,
        FIXED_REPEAT;

    }
}

