/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;

class ExecBridge
implements ActionListener,
PropertyChangeListener {
    private Node node;
    private AbstractButton button;
    private static Class execCookieClass = null;

    private static synchronized Class getExecCookieClass() {
        if (execCookieClass == null) {
            try {
                execCookieClass = Class.forName("org.openide.cookies.ExecCookie", true, (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class));
            }
            catch (ClassNotFoundException classNotFoundException) {
                execCookieClass = ExecBridge.class;
            }
        }
        if (execCookieClass == ExecBridge.class) {
            return null;
        }
        return execCookieClass;
    }

    private ExecBridge(Node node, AbstractButton abstractButton) {
        this.node = node;
        this.button = abstractButton;
        abstractButton.addActionListener(this);
        node.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)node));
        this.updateState();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Class clazz = ExecBridge.getExecCookieClass();
        if (clazz == null) {
            return;
        }
        Node.Cookie cookie = this.node.getCookie(clazz);
        if (cookie != null) {
            try {
                Method method = ExecBridge.getExecCookieClass().getMethod("start", new Class[0]);
                method.invoke((Object)cookie, new Object[0]);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("cookie".equals(propertyChangeEvent.getPropertyName())) {
            this.updateState();
        }
        if ("displayName".equals(propertyChangeEvent.getPropertyName())) {
            this.updateState();
        }
        if ("icon".equals(propertyChangeEvent.getPropertyName())) {
            this.updateState();
        }
    }

    private void updateState() {
        this.button.setText(this.node.getDisplayName());
        ImageIcon imageIcon = new ImageIcon(this.node.getIcon(1));
        this.button.setIcon(imageIcon);
        Class clazz = ExecBridge.getExecCookieClass();
        this.button.setEnabled(clazz != null && this.node.getCookie(clazz) != null);
    }

    public static JMenuItem createMenuItem(DataObject dataObject) {
        if (!dataObject.isValid()) {
            return null;
        }
        Node node = dataObject.getNodeDelegate();
        Class clazz = ExecBridge.getExecCookieClass();
        if (clazz == null || node.getCookie(clazz) == null) {
            return null;
        }
        JMenuItem jMenuItem = new JMenuItem();
        new ExecBridge(node, jMenuItem);
        return jMenuItem;
    }

    public static JButton createButton(DataObject dataObject) {
        if (!dataObject.isValid()) {
            return null;
        }
        Node node = dataObject.getNodeDelegate();
        Class clazz = ExecBridge.getExecCookieClass();
        if (clazz == null || node.getCookie(clazz) == null) {
            return null;
        }
        JButton jButton = new JButton();
        new ExecBridge(node, jButton);
        return jButton;
    }
}

