/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.AuthenticationJNI;
import com.microsoft.sqlserver.jdbc.DriverJDBCVersion;
import com.microsoft.sqlserver.jdbc.FailoverInfo;
import com.microsoft.sqlserver.jdbc.FailoverMapSingleton;
import com.microsoft.sqlserver.jdbc.ISQLServerConnection;
import com.microsoft.sqlserver.jdbc.Parameter;
import com.microsoft.sqlserver.jdbc.ParameterUtils;
import com.microsoft.sqlserver.jdbc.SQLCollation;
import com.microsoft.sqlserver.jdbc.SQLServerBlob;
import com.microsoft.sqlserver.jdbc.SQLServerCallableStatement;
import com.microsoft.sqlserver.jdbc.SQLServerClob;
import com.microsoft.sqlserver.jdbc.SQLServerConnectionPoolProxy;
import com.microsoft.sqlserver.jdbc.SQLServerDatabaseMetaData;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerNClob;
import com.microsoft.sqlserver.jdbc.SQLServerPooledConnection;
import com.microsoft.sqlserver.jdbc.SQLServerPreparedStatement;
import com.microsoft.sqlserver.jdbc.SQLServerSQLXML;
import com.microsoft.sqlserver.jdbc.SQLServerSavepoint;
import com.microsoft.sqlserver.jdbc.SQLServerStatement;
import com.microsoft.sqlserver.jdbc.ServerPortPlaceHolder;
import com.microsoft.sqlserver.jdbc.StreamLoginAck;
import com.microsoft.sqlserver.jdbc.StreamSSPI;
import com.microsoft.sqlserver.jdbc.TDS;
import com.microsoft.sqlserver.jdbc.TDSChannel;
import com.microsoft.sqlserver.jdbc.TDSCommand;
import com.microsoft.sqlserver.jdbc.TDSParser;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSReaderMark;
import com.microsoft.sqlserver.jdbc.TDSTokenHandler;
import com.microsoft.sqlserver.jdbc.TDSWriter;
import com.microsoft.sqlserver.jdbc.UninterruptableTDSCommand;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.XAConnection;

public class SQLServerConnection
implements ISQLServerConnection {
    private static final float TIMEOUTSTEP = 0.08f;
    private static final int DEFAULTTIMEOUT = 15;
    private boolean sendStringParametersAsUnicode = true;
    private boolean lastUpdateCount;
    private int nLockTimeout;
    private String selectMethod;
    private String responseBuffering;
    private boolean sendTimeAsDatetime = true;
    private byte requestedEncryptionLevel = (byte)-1;
    private static final String SYSTEM_JRE = System.getProperty("java.vendor") + " " + System.getProperty("java.version");
    private boolean trustServerCertificate;
    private byte negotiatedEncryptionLevel = (byte)-1;
    Properties activeConnectionProperties;
    private boolean integratedSecurity = false;
    ServerPortPlaceHolder currentConnectPlaceHolder = null;
    String sqlServerVersion;
    boolean xopenStates;
    private boolean databaseAutoCommitMode;
    private boolean inXATransaction = false;
    private byte[] transactionDescriptor = new byte[8];
    private boolean rolledBackTransaction;
    private boolean bIsOpen;
    static final int maxDecimalPrecision = 38;
    final String traceID;
    private int maxFieldSize;
    private int maxRows;
    private SQLCollation databaseCollation;
    private static int baseConnectionID = 0;
    private String sCatalog = "master";
    private String originalCatalog = "master";
    private int transactionIsolationLevel;
    private SQLServerPooledConnection pooledConnectionParent;
    private DatabaseMetaData databaseMetaData;
    private int nNextSavePointId = 10000;
    private static final Logger connectionlogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.SQLServerConnection");
    private static final Logger loggerExternal = Logger.getLogger("com.microsoft.sqlserver.jdbc.Connection");
    private final String loggingClassName;
    private String failoverPartnerServerProvided = null;
    private int holdability;
    private int tdsPacketSize = 4096;
    private int requestedPacketSize = 8000;
    private TDSChannel tdsChannel;
    private TDSCommand currentCommand = null;
    private int tdsVersion = 0;
    private int serverMajorVersion;
    private SQLServerConnectionPoolProxy proxy;
    static final int MAX_SQL_LOGIN_NAME_WCHARS = 128;
    static final int DEFAULTPORT = 1433;
    private final Object schedulerLock = new Object();
    volatile SQLWarning sqlWarnings;
    Integer warningSynchronization = new Integer(1);
    private static final int ENVCHANGE_DATABASE = 1;
    private static final int ENVCHANGE_LANGUAGE = 2;
    private static final int ENVCHANGE_CHARSET = 3;
    private static final int ENVCHANGE_PACKETSIZE = 4;
    private static final int ENVCHANGE_SORTLOCALEID = 5;
    private static final int ENVCHANGE_SORTFLAGS = 6;
    private static final int ENVCHANGE_SQLCOLLATION = 7;
    private static final int ENVCHANGE_XACT_BEGIN = 8;
    private static final int ENVCHANGE_XACT_COMMIT = 9;
    private static final int ENVCHANGE_XACT_ROLLBACK = 10;
    private static final int ENVCHANGE_DTC_ENLIST = 11;
    private static final int ENVCHANGE_DTC_DEFECT = 12;
    private static final int ENVCHANGE_CHANGE_MIRROR = 13;
    private static final int ENVCHANGE_UNUSED_14 = 14;
    private static final int ENVCHANGE_DTC_PROMOTE = 15;
    private static final int ENVCHANGE_DTC_MGR_ADDR = 16;
    private static final int ENVCHANGE_XACT_ENDED = 17;
    private static final int ENVCHANGE_RESET_COMPLETE = 18;
    private static final int ENVCHANGE_USER_INFO = 19;
    static final char[] OUT = new char[]{' ', 'O', 'U', 'T'};
    private static final int BROWSER_PORT = 1434;

    boolean sendStringParametersAsUnicode() {
        return this.sendStringParametersAsUnicode;
    }

    final boolean useLastUpdateCount() {
        return this.lastUpdateCount;
    }

    final String getSelectMethod() {
        return this.selectMethod;
    }

    final String getResponseBuffering() {
        return this.responseBuffering;
    }

    final boolean sendTimeAsDatetime() {
        return !this.isKatmaiOrLater() || this.sendTimeAsDatetime;
    }

    final int baseYear() {
        return this.sendTimeAsDatetime() ? 1970 : 1900;
    }

    final byte getRequestedEncryptionLevel() {
        assert (-1 != this.requestedEncryptionLevel);
        return this.requestedEncryptionLevel;
    }

    final boolean trustServerCertificate() {
        return this.trustServerCertificate;
    }

    final byte getNegotiatedEncryptionLevel() {
        assert (-1 != this.negotiatedEncryptionLevel);
        return this.negotiatedEncryptionLevel;
    }

    final boolean rolledBackTransaction() {
        return this.rolledBackTransaction;
    }

    final boolean isClosedInternal() {
        return !this.bIsOpen;
    }

    final void setMaxFieldSize(int n) throws SQLServerException {
        if (this.maxFieldSize != n) {
            this.connectionCommand("SET TEXTSIZE " + (0 == n ? Integer.MAX_VALUE : n), "setMaxFieldSize");
            this.maxFieldSize = n;
        }
    }

    final void initResettableValues() {
        this.rolledBackTransaction = false;
        this.transactionIsolationLevel = 2;
        this.maxFieldSize = 0;
        this.maxRows = 0;
        this.nLockTimeout = -1;
        this.databaseAutoCommitMode = true;
        this.holdability = 1;
        this.sqlWarnings = null;
        this.sCatalog = this.originalCatalog;
    }

    final void setMaxRows(int n) throws SQLServerException {
        if (this.maxRows != n) {
            this.connectionCommand("SET ROWCOUNT " + n, "setMaxRows");
            this.maxRows = n;
        }
    }

    final SQLCollation getDatabaseCollation() {
        return this.databaseCollation;
    }

    final int getHoldabilityInternal() {
        return this.holdability;
    }

    final int getTDSPacketSize() {
        return this.tdsPacketSize;
    }

    final boolean isYukonOrLater() {
        if (0 == this.tdsVersion) {
            assert (this.serverMajorVersion >= 8);
            return this.serverMajorVersion >= 9;
        }
        assert (this.tdsVersion >= 0x70100000);
        return this.tdsVersion >= 1913192450;
    }

    final boolean isKatmaiOrLater() {
        assert (0 != this.tdsVersion);
        assert (this.tdsVersion >= 0x70100000);
        return this.tdsVersion >= 1929576458;
    }

    SQLServerConnection(String string) {
        int n = SQLServerConnection.nextConnectionID();
        this.traceID = "ConnectionID:" + n;
        this.loggingClassName = "com.microsoft.sqlserver.jdbc.SQLServerConnection:" + n;
        if (connectionlogger.isLoggable(Level.FINE)) {
            connectionlogger.fine(this.toString() + " created by (" + string + ")");
        }
        this.initResettableValues();
    }

    void setFailoverPartnerServerProvided(String string) {
        this.failoverPartnerServerProvided = string;
    }

    final void setAssociatedProxy(SQLServerConnectionPoolProxy sQLServerConnectionPoolProxy) {
        this.proxy = sQLServerConnectionPoolProxy;
    }

    final Connection getConnection() {
        if (null != this.proxy) {
            return this.proxy;
        }
        return this;
    }

    final void resetPooledConnection() {
        this.tdsChannel.resetPooledConnection();
        this.initResettableValues();
    }

    private static synchronized int nextConnectionID() {
        return ++baseConnectionID;
    }

    Logger getConnectionLogger() {
        return connectionlogger;
    }

    String getClassNameLogging() {
        return this.loggingClassName;
    }

    public String toString() {
        return this.traceID;
    }

    void NotImplemented() throws SQLServerException {
        SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_notSupported"), null, false);
    }

    void checkClosed() throws SQLServerException {
        if (this.isClosedInternal()) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_connectionIsClosed"), null, false);
        }
    }

    private boolean booleanPropertyOn(String string, String string2) throws SQLServerException {
        if (null == string2) {
            return false;
        }
        String string3 = string2.toLowerCase(Locale.US);
        if (string3.equals("true")) {
            return true;
        }
        if (string3.equals("false")) {
            return false;
        }
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidBooleanValue"));
        Object[] objectArray = new Object[]{new String(string)};
        SQLServerException.makeFromDriverError(this, this, messageFormat.format(objectArray), null, false);
        return false;
    }

    void ValidateMaxSQLLoginName(String string, String string2) throws SQLServerException {
        if (string2 != null && string2.length() > 128) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_propertyMaximumExceedsChars"));
            Object[] objectArray = new Object[]{string, Integer.toString(128)};
            SQLServerException.makeFromDriverError(this, this, messageFormat.format(objectArray), null, false);
        }
    }

    Connection connect(Properties properties, SQLServerPooledConnection sQLServerPooledConnection) throws SQLServerException {
        Object[] objectArray;
        Object object;
        Object object2;
        MessageFormat messageFormat;
        Object object3;
        Object[] objectArray2;
        String string = "";
        this.activeConnectionProperties = (Properties)properties.clone();
        this.pooledConnectionParent = sQLServerPooledConnection;
        String string2 = null;
        String string3 = null;
        string2 = "user";
        string3 = this.activeConnectionProperties.getProperty(string2);
        if (string3 == null) {
            string3 = "";
            this.activeConnectionProperties.setProperty(string2, string3);
        }
        this.ValidateMaxSQLLoginName(string2, string3);
        string2 = "password";
        string3 = this.activeConnectionProperties.getProperty(string2);
        if (string3 == null) {
            string3 = "";
            this.activeConnectionProperties.setProperty(string2, string3);
        }
        this.ValidateMaxSQLLoginName(string2, string3);
        string2 = "databaseName";
        string3 = this.activeConnectionProperties.getProperty(string2);
        this.ValidateMaxSQLLoginName(string2, string3);
        int n = 15;
        string3 = this.activeConnectionProperties.getProperty("loginTimeout");
        if (null != string3 && string3.length() > 0) {
            try {
                n = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                objectArray2 = new MessageFormat(SQLServerException.getErrString("R_invalidTimeOut"));
                Object[] objectArray3 = new Object[]{string3};
                SQLServerException.makeFromDriverError(this, this, objectArray2.format(objectArray3), null, false);
            }
            if (n < 0 || n > 65535) {
                object3 = new MessageFormat(SQLServerException.getErrString("R_invalidTimeOut"));
                objectArray2 = new Object[]{string3};
                SQLServerException.makeFromDriverError(this, this, ((Format)object3).format(objectArray2), null, false);
            }
        }
        if ((string3 = this.activeConnectionProperties.getProperty(string2 = "serverName")) == null) {
            string3 = "localhost";
        }
        object3 = "portNumber";
        objectArray2 = this.activeConnectionProperties.getProperty((String)object3);
        int n2 = string3.indexOf(92);
        Object var10_12 = null;
        String string4 = null;
        if (n2 >= 0) {
            string4 = string3.substring(n2 + 1, string3.length());
            this.ValidateMaxSQLLoginName("instanceName", string4);
            string3 = string3.substring(0, n2);
        }
        this.activeConnectionProperties.setProperty(string2, string3);
        String string5 = this.activeConnectionProperties.getProperty("instanceName");
        if (null != string5) {
            string4 = string5;
        }
        if (string4 != null) {
            this.ValidateMaxSQLLoginName("instanceName", string4);
            this.activeConnectionProperties.setProperty("instanceName", string4);
        }
        if ((string3 = this.activeConnectionProperties.getProperty(string2 = "applicationName")) != null) {
            this.ValidateMaxSQLLoginName(string2, string3);
        } else {
            this.activeConnectionProperties.setProperty(string2, "Microsoft SQL Server JDBC Driver");
        }
        string2 = "lastUpdateCount";
        string3 = this.activeConnectionProperties.getProperty(string2);
        if (string3 == null) {
            string3 = "true";
            this.activeConnectionProperties.setProperty(string2, string3);
        }
        if ((string3 = this.activeConnectionProperties.getProperty(string2 = "encrypt")) == null) {
            string3 = "false";
            this.activeConnectionProperties.setProperty(string2, string3);
        }
        this.requestedEncryptionLevel = this.booleanPropertyOn("encrypt", string3) ? (byte)1 : 0;
        string2 = "trustServerCertificate";
        string3 = this.activeConnectionProperties.getProperty(string2);
        if (string3 == null) {
            string3 = "false";
            this.activeConnectionProperties.setProperty(string2, string3);
        }
        this.trustServerCertificate = this.booleanPropertyOn("trustServerCertificate", string3);
        string2 = "selectMethod";
        string3 = this.activeConnectionProperties.getProperty(string2);
        if (string3 == null) {
            string3 = "direct";
        }
        if (string3.equalsIgnoreCase("cursor") || string3.equalsIgnoreCase("direct")) {
            this.activeConnectionProperties.setProperty(string2, string3.toLowerCase());
        } else {
            messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidselectMethod"));
            object2 = new Object[]{new String(string3)};
            SQLServerException.makeFromDriverError(this, this, messageFormat.format(object2), null, false);
        }
        string2 = "responseBuffering";
        string3 = this.activeConnectionProperties.getProperty(string2);
        if (string3 == null) {
            string3 = "adaptive";
        }
        if (string3.equalsIgnoreCase("full") || string3.equalsIgnoreCase("adaptive")) {
            this.activeConnectionProperties.setProperty(string2, string3.toLowerCase());
        } else {
            messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidresponseBuffering"));
            object2 = new Object[]{new String(string3)};
            SQLServerException.makeFromDriverError(this, this, messageFormat.format(object2), null, false);
        }
        string2 = "sendTimeAsDatetime";
        string3 = this.activeConnectionProperties.getProperty(string2);
        if (string3 == null) {
            string3 = "true";
            this.activeConnectionProperties.setProperty(string2, string3);
        }
        this.sendTimeAsDatetime = this.booleanPropertyOn("sendTimeAsDatetime", string3);
        string2 = "disableStatementPooling";
        string3 = this.activeConnectionProperties.getProperty(string2);
        if (string3 != null && !this.booleanPropertyOn(string2, string3)) {
            messageFormat = new MessageFormat(SQLServerException.getErrString("R_invaliddisableStatementPooling"));
            object2 = new Object[]{new String(string3)};
            SQLServerException.makeFromDriverError(this, this, messageFormat.format(object2), null, false);
        }
        if ((string3 = this.activeConnectionProperties.getProperty(string2 = "integratedSecurity")) != null) {
            this.integratedSecurity = this.booleanPropertyOn(string2, string3);
        }
        string2 = "workstationID";
        string3 = this.activeConnectionProperties.getProperty(string2);
        this.ValidateMaxSQLLoginName(string2, string3);
        int n3 = 0;
        try {
            object2 = this.activeConnectionProperties.getProperty("portNumber");
            if (null != object2 && ((n3 = new Integer((String)object2).intValue()) < 0 || n3 > 65535)) {
                object = new MessageFormat(SQLServerException.getErrString("R_invalidPortNumber"));
                objectArray = new Object[]{Integer.toString(n3)};
                SQLServerException.makeFromDriverError(this, this, ((Format)object).format(objectArray), null, false);
            }
        }
        catch (NumberFormatException numberFormatException) {
            object = new MessageFormat(SQLServerException.getErrString("R_invalidPortNumber"));
            objectArray = new Object[]{this.activeConnectionProperties.getProperty("portNumber")};
            SQLServerException.makeFromDriverError(this, this, ((Format)object).format(objectArray), null, false);
        }
        string3 = this.activeConnectionProperties.getProperty("packetSize");
        if (null != string3 && string3.length() > 0) {
            try {
                this.requestedPacketSize = Integer.parseInt(string3);
                if (-1 == this.requestedPacketSize) {
                    this.requestedPacketSize = 0;
                } else if (0 == this.requestedPacketSize) {
                    this.requestedPacketSize = Short.MAX_VALUE;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.requestedPacketSize = -1;
            }
            if (0 != this.requestedPacketSize && (this.requestedPacketSize < 512 || this.requestedPacketSize > Short.MAX_VALUE)) {
                object2 = new MessageFormat(SQLServerException.getErrString("R_invalidPacketSize"));
                object = new Object[]{string3};
                SQLServerException.makeFromDriverError(this, this, ((Format)object2).format(object), null, false);
            }
        }
        this.sendStringParametersAsUnicode = null == this.activeConnectionProperties.getProperty("sendStringParametersAsUnicode") ? true : this.booleanPropertyOn("sendStringParametersAsUnicode", this.activeConnectionProperties.getProperty("sendStringParametersAsUnicode"));
        this.lastUpdateCount = this.booleanPropertyOn("lastUpdateCount", this.activeConnectionProperties.getProperty("lastUpdateCount"));
        this.xopenStates = this.booleanPropertyOn("xopenStates", this.activeConnectionProperties.getProperty("xopenStates"));
        this.selectMethod = null;
        if (this.activeConnectionProperties.getProperty("selectMethod") != null && this.activeConnectionProperties.getProperty("selectMethod").length() > 0) {
            this.selectMethod = this.activeConnectionProperties.getProperty("selectMethod");
        }
        this.responseBuffering = null;
        if (this.activeConnectionProperties.getProperty("responseBuffering") != null && this.activeConnectionProperties.getProperty("responseBuffering").length() > 0) {
            this.responseBuffering = this.activeConnectionProperties.getProperty("responseBuffering");
        }
        this.nLockTimeout = -1;
        if (this.activeConnectionProperties.getProperty("lockTimeout") != null && this.activeConnectionProperties.getProperty("lockTimeout").length() > 0) {
            try {
                int n4 = new Integer(this.activeConnectionProperties.getProperty("lockTimeout"));
                if (n4 >= -1) {
                    this.nLockTimeout = n4;
                } else {
                    object = new MessageFormat(SQLServerException.getErrString("R_invalidLockTimeOut"));
                    objectArray = new Object[]{this.activeConnectionProperties.getProperty("lockTimeout")};
                    SQLServerException.makeFromDriverError(this, this, ((Format)object).format(objectArray), null, false);
                }
            }
            catch (NumberFormatException numberFormatException) {
                object = new MessageFormat(SQLServerException.getErrString("R_invalidLockTimeOut"));
                objectArray = new Object[]{this.activeConnectionProperties.getProperty("lockTimeout")};
                SQLServerException.makeFromDriverError(this, this, ((Format)object).format(objectArray), null, false);
            }
        }
        FailoverInfo failoverInfo = null;
        if (null != this.activeConnectionProperties.getProperty("databaseName")) {
            failoverInfo = FailoverMapSingleton.getFailoverInfo(this, this.activeConnectionProperties.getProperty("serverName"), this.activeConnectionProperties.getProperty("instanceName"), this.activeConnectionProperties.getProperty("databaseName"));
        } else if (null != this.activeConnectionProperties.getProperty("failoverPartner")) {
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_failoverPartnerWithoutDB"), null, true);
        }
        object = null;
        if (null == failoverInfo) {
            object = this.activeConnectionProperties.getProperty("failoverPartner");
        }
        long l = System.currentTimeMillis();
        this.login(this.activeConnectionProperties.getProperty("serverName"), string4, n3, (String)object, failoverInfo, n, l);
        if (1 == this.negotiatedEncryptionLevel || 3 == this.negotiatedEncryptionLevel) {
            int n5;
            int n6 = n5 = SYSTEM_JRE.startsWith("IBM") ? 8192 : 16384;
            if (this.tdsPacketSize > n5) {
                connectionlogger.finer(this.toString() + " Negotiated tdsPacketSize " + this.tdsPacketSize + " is too large for SSL with JRE " + SYSTEM_JRE + " (max size is " + n5 + ")");
                MessageFormat messageFormat2 = new MessageFormat(SQLServerException.getErrString("R_packetSizeTooBigForSSL"));
                Object[] objectArray4 = new Object[]{Integer.toString(n5)};
                this.terminate(6, messageFormat2.format(objectArray4));
            }
        }
        this.bIsOpen = true;
        if (connectionlogger.isLoggable(Level.FINER)) {
            connectionlogger.finer(this.toString() + " End of connect");
        }
        return this;
    }

    private void login(String string, String string2, int n, String string3, FailoverInfo failoverInfo, int n2, long l) throws SQLServerException {
        boolean bl = null == string3 && null == failoverInfo;
        int n3 = 100;
        boolean bl2 = false;
        FailoverInfo failoverInfo2 = null;
        ServerPortPlaceHolder serverPortPlaceHolder = null;
        ServerPortPlaceHolder serverPortPlaceHolder2 = null;
        if (null != failoverInfo) {
            failoverInfo2 = failoverInfo;
            bl2 = failoverInfo.getUseFailoverPartner();
        } else if (!bl) {
            failoverInfo2 = new FailoverInfo(string3, this, false);
        }
        if (0 == n2) {
            n2 = 15;
        }
        long l2 = n2 * 1000;
        long l3 = l + l2;
        long l4 = (long)(0.08f * (float)l2);
        long l5 = l + l4;
        if (connectionlogger.isLoggable(Level.FINER)) {
            connectionlogger.finer(this.toString() + " Start time: " + l + " Time out time: " + l3 + " Timeout Unit Interval: " + l4);
        }
        int n4 = 0;
        while (true) {
            try {
                if (!bl && bl2) {
                    if (null == serverPortPlaceHolder) {
                        serverPortPlaceHolder = failoverInfo2.failoverPermissionCheck(this, this.integratedSecurity);
                    }
                    this.currentConnectPlaceHolder = serverPortPlaceHolder;
                } else {
                    if (null == serverPortPlaceHolder2) {
                        serverPortPlaceHolder2 = this.primaryPermissionCheck(string, string2, n);
                    }
                    this.currentConnectPlaceHolder = serverPortPlaceHolder2;
                }
                if (connectionlogger.isLoggable(Level.FINE)) {
                    connectionlogger.fine(this.toString() + " This attempt server name: " + this.currentConnectPlaceHolder.getServerName() + " port: " + this.currentConnectPlaceHolder.getPortNumber() + " InstanceName: " + this.currentConnectPlaceHolder.getInstanceName());
                    connectionlogger.fine(this.toString() + " This attempt endtime: " + l5);
                    connectionlogger.fine(this.toString() + " This attempt No: " + n4);
                }
                this.connectHelper(this.currentConnectPlaceHolder, SQLServerConnection.TimerRemaining(l5), n2);
            }
            catch (SQLServerException sQLServerException) {
                long l6;
                if (null != this.tdsChannel) {
                    this.tdsChannel.close();
                }
                if (18456 == sQLServerException.getErrorCode() || 18488 == sQLServerException.getErrorCode() || 4 == sQLServerException.getDriverErrorCode() || 5 == sQLServerException.getDriverErrorCode() || 6 == sQLServerException.getDriverErrorCode() || SQLServerConnection.timerHasExpired(l3)) {
                    throw sQLServerException;
                }
                if (1 == n4 % 2 && (l6 = (long)SQLServerConnection.TimerRemaining(l3)) <= (long)n3) {
                    throw sQLServerException;
                }
                if (1 == n4 % 2) {
                    if (connectionlogger.isLoggable(Level.FINE)) {
                        connectionlogger.fine(this.toString() + " sleeping milisec: " + n3);
                    }
                    try {
                        Thread.sleep(n3);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    int n5 = n3 = n3 < 500 ? n3 * 2 : 1000;
                }
                if ((l5 = System.currentTimeMillis() + l4 * (long)(++n4 / 2 + 1)) > l3) {
                    l5 = l3;
                }
                if (bl) continue;
                bl2 = !bl2;
                continue;
            }
            break;
        }
        if (bl2 && null == this.failoverPartnerServerProvided) {
            String string4 = this.currentConnectPlaceHolder.getServerName();
            if (null != serverPortPlaceHolder.getInstanceName()) {
                string4 = string4 + "\\";
                string4 = string4 + serverPortPlaceHolder.getInstanceName();
            }
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidPartnerConfiguration"));
            Object[] objectArray = new Object[]{new String(this.activeConnectionProperties.getProperty("databaseName")), string4};
            SQLServerException.makeFromDriverError(this, this, messageFormat.format(objectArray), null, false);
        }
        if (null != this.failoverPartnerServerProvided) {
            if (null == failoverInfo2) {
                failoverInfo2 = new FailoverInfo(this.failoverPartnerServerProvided, this, false);
            }
            if (null != failoverInfo) {
                failoverInfo.failoverAdd(this, bl2, this.failoverPartnerServerProvided);
            } else {
                if (connectionlogger.isLoggable(Level.FINE)) {
                    connectionlogger.fine(this.toString() + " adding new failover info server: " + this.activeConnectionProperties.getProperty("serverName") + " instance: " + this.activeConnectionProperties.getProperty("instanceName") + " database: " + this.activeConnectionProperties.getProperty("databaseName") + " server provided failover: " + this.failoverPartnerServerProvided);
                }
                failoverInfo2.failoverAdd(this, bl2, this.failoverPartnerServerProvided);
                FailoverMapSingleton.putFailoverInfo(this, string, this.activeConnectionProperties.getProperty("instanceName"), this.activeConnectionProperties.getProperty("databaseName"), failoverInfo2, bl2, this.failoverPartnerServerProvided);
            }
        }
    }

    ServerPortPlaceHolder primaryPermissionCheck(String string, String string2, int n) throws SQLServerException {
        block7: {
            if (0 == n) {
                if (null != string2) {
                    String string3 = this.getInstancePort(string, string2);
                    try {
                        if (null != string3) {
                            n = new Integer(string3);
                            if (n < 0 || n > 65535) {
                                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidPortNumber"));
                                Object[] objectArray = new Object[]{Integer.toString(n)};
                                SQLServerException.makeFromDriverError(this, this, messageFormat.format(objectArray), null, false);
                            }
                            break block7;
                        }
                        n = 1433;
                    }
                    catch (NumberFormatException numberFormatException) {
                        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidPortNumber"));
                        Object[] objectArray = new Object[]{n};
                        SQLServerException.makeFromDriverError(this, this, messageFormat.format(objectArray), null, false);
                    }
                } else {
                    n = 1433;
                }
            }
        }
        this.activeConnectionProperties.setProperty("portNumber", String.valueOf(n));
        return new ServerPortPlaceHolder(string, n, string2, this.integratedSecurity);
    }

    static boolean timerHasExpired(long l) {
        boolean bl = System.currentTimeMillis() > l;
        return bl;
    }

    static int TimerRemaining(long l) {
        long l2 = System.currentTimeMillis();
        long l3 = l - l2;
        if (l3 > Integer.MAX_VALUE) {
            l3 = Integer.MAX_VALUE;
        }
        if (l3 <= 0L) {
            l3 = 1L;
        }
        return (int)l3;
    }

    private void connectHelper(ServerPortPlaceHolder serverPortPlaceHolder, int n, int n2) throws SQLServerException {
        IOException iOException = null;
        try {
            if (connectionlogger.isLoggable(Level.FINE)) {
                connectionlogger.fine(this.toString() + " Connecting with server: " + serverPortPlaceHolder.getServerName() + " port: " + serverPortPlaceHolder.getPortNumber() + " Timeout slice: " + n + " Timeout Full: " + n2);
            }
            this.tdsChannel = new TDSChannel(this);
            if (0 == n2) {
                this.tdsChannel.open(serverPortPlaceHolder.getServerName(), serverPortPlaceHolder.getPortNumber(), 0);
            } else {
                this.tdsChannel.open(serverPortPlaceHolder.getServerName(), serverPortPlaceHolder.getPortNumber(), n);
            }
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        if (iOException != null) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_tcpOpenFailed"));
            Object[] objectArray = new Object[]{iOException.getMessage()};
            MessageFormat messageFormat2 = new MessageFormat(SQLServerException.getErrString("R_tcpipConnectionFailed"));
            Object[] objectArray2 = new Object[]{serverPortPlaceHolder.getServerName(), Integer.toString(serverPortPlaceHolder.getPortNumber()), messageFormat.format(objectArray)};
            String string = messageFormat2.format(objectArray2);
            SQLServerException.makeFromDriverError(this, this, string, "08001", false);
        }
        this.Prelogin(serverPortPlaceHolder.getServerName(), serverPortPlaceHolder.getPortNumber());
        if (2 != this.negotiatedEncryptionLevel) {
            this.tdsChannel.enableSSL(serverPortPlaceHolder.getServerName(), serverPortPlaceHolder.getPortNumber());
        }
        this.executeCommand(new LogonCommand());
    }

    void Prelogin(String string, int n) throws SQLServerException {
        int n2;
        byte[] byArray = new byte[]{18, 1, 0, 26, 0, 0, 0, 0, 0, 0, 11, 0, 6, 1, 0, 17, 0, 1, -1, 0, 0, 0, 0, 0, 0, this.requestedEncryptionLevel};
        byte[] byArray2 = new byte[4096];
        String string2 = " Prelogin error: host " + string + " port " + n;
        if (connectionlogger.isLoggable(Level.FINER)) {
            connectionlogger.finer(this.toString() + " Requesting encryption level:" + TDS.getEncryptionLevel(this.requestedEncryptionLevel));
        }
        if (this.tdsChannel.isLoggingPackets()) {
            this.tdsChannel.logPacket(byArray, 0, byArray.length, this.toString() + " Prelogin request");
        }
        try {
            this.tdsChannel.write(byArray, 0, byArray.length);
            this.tdsChannel.flush();
        }
        catch (SQLServerException sQLServerException) {
            connectionlogger.warning(this.toString() + string2 + " Error sending prelogin request: " + sQLServerException.getMessage());
            throw sQLServerException;
        }
        int n3 = byArray2.length;
        int n4 = 0;
        boolean bl = false;
        while (n4 < n3) {
            Object[] objectArray;
            MessageFormat messageFormat;
            try {
                n2 = this.tdsChannel.read(byArray2, n4, n3 - n4);
            }
            catch (SQLServerException sQLServerException) {
                connectionlogger.warning(this.toString() + string2 + " Error reading prelogin response: " + sQLServerException.getMessage());
                throw sQLServerException;
            }
            if (-1 == n2) {
                connectionlogger.warning(this.toString() + string2 + " Unexpected end of prelogin response after " + n4 + " bytes read");
                messageFormat = new MessageFormat(SQLServerException.getErrString("R_tcpipConnectionFailed"));
                objectArray = new Object[]{string, Integer.toString(n), SQLServerException.getErrString("R_notSQLServer")};
                this.terminate(3, messageFormat.format(objectArray));
            }
            assert (n2 >= 0);
            assert (n2 <= n3 - n4);
            if (this.tdsChannel.isLoggingPackets()) {
                this.tdsChannel.logPacket(byArray2, n4, n2, this.toString() + " Prelogin response");
            }
            if (bl || (n4 += n2) < 8) continue;
            if (4 != byArray2[0]) {
                connectionlogger.warning(this.toString() + string2 + " Unexpected response type:" + byArray2[0]);
                messageFormat = new MessageFormat(SQLServerException.getErrString("R_tcpipConnectionFailed"));
                objectArray = new Object[]{string, Integer.toString(n), SQLServerException.getErrString("R_notSQLServer")};
                this.terminate(3, messageFormat.format(objectArray));
            }
            if (1 != (1 & byArray2[1])) {
                connectionlogger.warning(this.toString() + string2 + " Unexpected response status:" + byArray2[1]);
                messageFormat = new MessageFormat(SQLServerException.getErrString("R_tcpipConnectionFailed"));
                objectArray = new Object[]{string, Integer.toString(n), SQLServerException.getErrString("R_notSQLServer")};
                this.terminate(3, messageFormat.format(objectArray));
            }
            n3 = Util.readUnsignedShortBigEndian(byArray2, 2);
            assert (n3 >= 0);
            if (n3 >= byArray2.length) {
                connectionlogger.warning(this.toString() + string2 + " Response length:" + n3 + " is greater than allowed length:" + byArray2.length);
                messageFormat = new MessageFormat(SQLServerException.getErrString("R_tcpipConnectionFailed"));
                objectArray = new Object[]{string, Integer.toString(n), SQLServerException.getErrString("R_notSQLServer")};
                this.terminate(3, messageFormat.format(objectArray));
            }
            bl = true;
        }
        n2 = 0;
        this.negotiatedEncryptionLevel = (byte)-1;
        int n5 = 8;
        block9: while (true) {
            byte by;
            if (n5 >= n3) {
                connectionlogger.warning(this.toString() + " Option token not found");
                this.throwInvalidTDS();
            }
            if (-1 == (by = byArray2[n5++])) break;
            if (n5 + 4 >= n3) {
                connectionlogger.warning(this.toString() + " Offset/Length not found for option:" + by);
                this.throwInvalidTDS();
            }
            int n6 = Util.readUnsignedShortBigEndian(byArray2, n5) + 8;
            n5 += 2;
            assert (n6 >= 0);
            int n7 = Util.readUnsignedShortBigEndian(byArray2, n5);
            n5 += 2;
            assert (n7 >= 0);
            if (n6 + n7 > n3) {
                connectionlogger.warning(this.toString() + " Offset:" + n6 + " and length:" + n7 + " exceed response length:" + n3);
                this.throwInvalidTDS();
            }
            switch (by) {
                case 0: {
                    if (n2 != 0) {
                        connectionlogger.warning(this.toString() + " Version option already received");
                        this.throwInvalidTDS();
                    }
                    if (6 != n7) {
                        connectionlogger.warning(this.toString() + " Version option length:" + n7 + " is incorrect.  Correct value is 6.");
                        this.throwInvalidTDS();
                    }
                    this.serverMajorVersion = byArray2[n6];
                    if (this.serverMajorVersion < 8) {
                        connectionlogger.warning(this.toString() + " Server major version:" + this.serverMajorVersion + " is not supported by this driver.");
                        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unsupportedServerVersion"));
                        Object[] objectArray = new Object[]{Integer.toString(byArray2[n6])};
                        this.terminate(6, messageFormat.format(objectArray));
                    }
                    if (connectionlogger.isLoggable(Level.FINE)) {
                        connectionlogger.fine(this.toString() + " Server returned major version:" + byArray2[n6]);
                    }
                    n2 = 1;
                    continue block9;
                }
                case 1: {
                    if (-1 != this.negotiatedEncryptionLevel) {
                        connectionlogger.warning(this.toString() + " Encryption option already received");
                        this.throwInvalidTDS();
                    }
                    if (1 != n7) {
                        connectionlogger.warning(this.toString() + " Encryption option length:" + n7 + " is incorrect.  Correct value is 1.");
                        this.throwInvalidTDS();
                    }
                    this.negotiatedEncryptionLevel = byArray2[n6];
                    if (0 != this.negotiatedEncryptionLevel && 1 != this.negotiatedEncryptionLevel && 3 != this.negotiatedEncryptionLevel && 2 != this.negotiatedEncryptionLevel) {
                        connectionlogger.warning(this.toString() + " Server returned " + TDS.getEncryptionLevel(this.negotiatedEncryptionLevel));
                        this.throwInvalidTDS();
                    }
                    if (connectionlogger.isLoggable(Level.FINER)) {
                        connectionlogger.finer(this.toString() + " Negotiated encryption level:" + TDS.getEncryptionLevel(this.negotiatedEncryptionLevel));
                    }
                    if (1 == this.requestedEncryptionLevel && 1 != this.negotiatedEncryptionLevel && 3 != this.negotiatedEncryptionLevel) {
                        this.terminate(5, SQLServerException.getErrString("R_sslRequiredNoServerSupport"));
                    }
                    if (2 != this.requestedEncryptionLevel || 2 == this.negotiatedEncryptionLevel) continue block9;
                    if (3 == this.negotiatedEncryptionLevel) {
                        this.terminate(5, SQLServerException.getErrString("R_sslRequiredByServer"));
                    }
                    connectionlogger.warning(this.toString() + " Client requested encryption level: " + TDS.getEncryptionLevel(this.requestedEncryptionLevel) + " Server returned unexpected encryption level: " + TDS.getEncryptionLevel(this.negotiatedEncryptionLevel));
                    this.throwInvalidTDS();
                    continue block9;
                }
            }
            if (!connectionlogger.isLoggable(Level.FINER)) continue;
            connectionlogger.finer(this.toString() + " Ignoring prelogin response option:" + by);
        }
        if (n2 == 0 || -1 == this.negotiatedEncryptionLevel) {
            connectionlogger.warning(this.toString() + " Prelogin response is missing version and/or encryption option.");
            this.throwInvalidTDS();
        }
    }

    final void throwInvalidTDS() throws SQLServerException {
        this.terminate(4, SQLServerException.getErrString("R_invalidTDS"));
    }

    final void terminate(int n, String string) throws SQLServerException {
        this.terminate(n, string, null);
    }

    final void terminate(int n, String string, Throwable throwable) throws SQLServerException {
        String string2;
        String string3 = string2 = this.bIsOpen ? "08006" : "08001";
        if (!this.xopenStates) {
            string2 = SQLServerException.mapFromXopen(string2);
        }
        SQLServerException sQLServerException = new SQLServerException((Object)this, string, string2, 0, true);
        if (null != throwable) {
            sQLServerException.initCause(throwable);
        }
        sQLServerException.setDriverErrorCode(n);
        this.notifyPooledConnection(sQLServerException);
        this.close();
        throw sQLServerException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean executeCommand(TDSCommand tDSCommand) throws SQLServerException {
        Object object = this.schedulerLock;
        synchronized (object) {
            if (null != this.currentCommand) {
                this.currentCommand.detach();
                this.currentCommand = null;
            }
            boolean bl = false;
            try {
                bl = tDSCommand.execute(this.tdsChannel.getWriter(), this.tdsChannel.getReader(tDSCommand));
            }
            finally {
                assert (null == this.currentCommand);
                if (!bl && !this.isClosedInternal()) {
                    this.currentCommand = tDSCommand;
                }
            }
            return bl;
        }
    }

    private final void connectionCommand(String string, String string2) throws SQLServerException {
        final class ConnectionCommand
        extends UninterruptableTDSCommand {
            final String sql;

            ConnectionCommand(String string, String string2) {
                super(string2);
                this.sql = string;
            }

            @Override
            final boolean doExecute() throws SQLServerException {
                this.startRequest((byte)1).writeString(this.sql);
                TDSParser.parse(this.startResponse(), this.getLogContext());
                return true;
            }
        }
        this.executeCommand(new ConnectionCommand(string, string2));
    }

    String sqlStatementToInitialize() {
        String string = "";
        if (this.nLockTimeout > -1) {
            string = string + " set lock_timeout " + this.nLockTimeout;
        }
        return string;
    }

    void setCatalogName(String string) {
        if (string != null && string.length() > 0) {
            this.sCatalog = string;
        }
    }

    String sqlStatementToSetTransactionIsolationLevel() throws SQLServerException {
        String string = "set transaction isolation level ";
        switch (this.transactionIsolationLevel) {
            case 1: {
                string = string + " read uncommitted ";
                break;
            }
            case 2: {
                string = string + " read committed ";
                break;
            }
            case 4: {
                string = string + " repeatable read ";
                break;
            }
            case 8: {
                string = string + " serializable ";
                break;
            }
            case 4096: {
                string = string + " snapshot ";
                break;
            }
            default: {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidTransactionLevel"));
                Object[] objectArray = new Object[]{Integer.toString(this.transactionIsolationLevel)};
                SQLServerException.makeFromDriverError(this, this, messageFormat.format(objectArray), null, false);
            }
        }
        return string;
    }

    static String sqlStatementToSetCommit(boolean bl) {
        return true == bl ? "set implicit_transactions off " : "set implicit_transactions on ";
    }

    String sqlStatementForSettings() throws SQLServerException {
        String string = "";
        string = string + this.sqlStatementToInitialize() + " " + this.sqlStatementToSetTransactionIsolationLevel() + " " + SQLServerConnection.sqlStatementToSetCommit(this.databaseAutoCommitMode);
        return string;
    }

    @Override
    public Statement createStatement() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "createStatement");
        Statement statement = this.createStatement(1003, 1007);
        loggerExternal.exiting(this.getClassNameLogging(), "createStatement", statement);
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "prepareStatement", string);
        PreparedStatement preparedStatement = this.prepareStatement(string, 1003, 1007);
        loggerExternal.exiting(this.getClassNameLogging(), "prepareStatement", preparedStatement);
        return preparedStatement;
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "prepareCall", string);
        CallableStatement callableStatement = this.prepareCall(string, 1003, 1007);
        loggerExternal.exiting(this.getClassNameLogging(), "prepareCall", callableStatement);
        return callableStatement;
    }

    @Override
    public String nativeSQL(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "nativeSQL", string);
        this.checkClosed();
        loggerExternal.exiting(this.getClassNameLogging(), "nativeSQL", string);
        return string;
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setAutoCommit", bl);
        }
        String string = "";
        this.checkClosed();
        if (bl == this.databaseAutoCommitMode) {
            return;
        }
        if (bl) {
            string = "IF @@TRANCOUNT > 0 COMMIT TRAN ";
        }
        if (connectionlogger.isLoggable(Level.FINER)) {
            connectionlogger.finer(this.toString() + " Autocommitmode current :" + this.databaseAutoCommitMode + " new: " + bl);
        }
        this.rolledBackTransaction = false;
        this.connectionCommand(string + SQLServerConnection.sqlStatementToSetCommit(bl), "setAutoCommit");
        this.databaseAutoCommitMode = bl;
        loggerExternal.exiting(this.getClassNameLogging(), "setAutoCommit");
    }

    @Override
    public boolean getAutoCommit() throws SQLServerException {
        boolean bl;
        loggerExternal.entering(this.getClassNameLogging(), "getAutoCommit");
        this.checkClosed();
        boolean bl2 = bl = !this.inXATransaction && this.databaseAutoCommitMode;
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.exiting(this.getClassNameLogging(), "getAutoCommit", bl);
        }
        return bl;
    }

    final byte[] getTransactionDescriptor() {
        return this.transactionDescriptor;
    }

    @Override
    public void commit() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "commit");
        this.checkClosed();
        if (!this.databaseAutoCommitMode) {
            this.connectionCommand("IF @@TRANCOUNT > 0 COMMIT TRAN", "Connection.commit");
        }
        loggerExternal.exiting(this.getClassNameLogging(), "commit");
    }

    @Override
    public void rollback() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "rollback");
        this.checkClosed();
        if (this.databaseAutoCommitMode) {
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_cantInvokeRollback"), null, true);
        } else {
            this.connectionCommand("IF @@TRANCOUNT > 0 ROLLBACK TRAN", "Connection.rollback");
        }
        loggerExternal.exiting(this.getClassNameLogging(), "rollback");
    }

    @Override
    public void close() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "close");
        this.bIsOpen = false;
        if (null != this.tdsChannel) {
            this.tdsChannel.close();
        }
        loggerExternal.exiting(this.getClassNameLogging(), "close");
    }

    final void poolCloseEventNotify() throws SQLServerException {
        if (this.bIsOpen && null != this.pooledConnectionParent) {
            if (!this.databaseAutoCommitMode && !(this.pooledConnectionParent instanceof XAConnection)) {
                this.connectionCommand("IF @@TRANCOUNT > 0 ROLLBACK TRAN", "close connection");
            }
            this.notifyPooledConnection(null);
            if (connectionlogger.isLoggable(Level.FINER)) {
                connectionlogger.finer(this.toString() + " Connection closed and returned to connection pool");
            }
        }
    }

    @Override
    public boolean isClosed() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "isClosed");
        loggerExternal.exiting(this.getClassNameLogging(), "isClosed", this.isClosedInternal());
        return this.isClosedInternal();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getMetaData");
        this.checkClosed();
        if (this.databaseMetaData == null) {
            this.databaseMetaData = new SQLServerDatabaseMetaData(this);
        }
        loggerExternal.exiting(this.getClassNameLogging(), "getMetaData", this.databaseMetaData);
        return this.databaseMetaData;
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setReadOnly", bl);
        }
        this.checkClosed();
        loggerExternal.exiting(this.getClassNameLogging(), "setReadOnly");
    }

    @Override
    public boolean isReadOnly() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "isReadOnly");
        this.checkClosed();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.exiting(this.getClassNameLogging(), "isReadOnly", false);
        }
        return false;
    }

    @Override
    public void setCatalog(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "setCatalog", string);
        this.checkClosed();
        if (string != null) {
            this.connectionCommand("use " + Util.escapeSQLId(string), "setCatalog");
            this.sCatalog = string;
        }
        loggerExternal.exiting(this.getClassNameLogging(), "setCatalog");
    }

    @Override
    public String getCatalog() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getCatalog");
        this.checkClosed();
        loggerExternal.exiting(this.getClassNameLogging(), "getCatalog", this.sCatalog);
        return this.sCatalog;
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setTransactionIsolation", new Integer(n));
        }
        this.checkClosed();
        if (n == 0) {
            return;
        }
        this.transactionIsolationLevel = n;
        String string = this.sqlStatementToSetTransactionIsolationLevel();
        this.connectionCommand(string, "setTransactionIsolation");
        loggerExternal.exiting(this.getClassNameLogging(), "setTransactionIsolation");
    }

    @Override
    public int getTransactionIsolation() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getTransactionIsolation");
        this.checkClosed();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.exiting(this.getClassNameLogging(), "getTransactionIsolation", new Integer(this.transactionIsolationLevel));
        }
        return this.transactionIsolationLevel;
    }

    @Override
    public SQLWarning getWarnings() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getWarnings");
        this.checkClosed();
        loggerExternal.exiting(this.getClassNameLogging(), "getWarnings", this.sqlWarnings);
        return this.sqlWarnings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWarning(String string) {
        Integer n = this.warningSynchronization;
        synchronized (n) {
            SQLWarning sQLWarning = new SQLWarning(string);
            if (null == this.sqlWarnings) {
                this.sqlWarnings = sQLWarning;
            } else {
                this.sqlWarnings.setNextWarning(sQLWarning);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearWarnings() throws SQLServerException {
        Integer n = this.warningSynchronization;
        synchronized (n) {
            loggerExternal.entering(this.getClassNameLogging(), "clearWarnings");
            this.checkClosed();
            this.sqlWarnings = null;
            loggerExternal.exiting(this.getClassNameLogging(), "clearWarnings");
        }
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "createStatement", new Object[]{new Integer(n), new Integer(n2)});
        }
        this.checkClosed();
        SQLServerStatement sQLServerStatement = new SQLServerStatement(this, n, n2);
        loggerExternal.exiting(this.getClassNameLogging(), "createStatement", sQLServerStatement);
        return sQLServerStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "prepareStatement", new Object[]{string, new Integer(n), new Integer(n2)});
        }
        this.checkClosed();
        SQLServerPreparedStatement sQLServerPreparedStatement = new SQLServerPreparedStatement(this, string, n, n2);
        loggerExternal.exiting(this.getClassNameLogging(), "prepareStatement", sQLServerPreparedStatement);
        return sQLServerPreparedStatement;
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "prepareCall", new Object[]{string, new Integer(n), new Integer(n2)});
        }
        this.checkClosed();
        SQLServerCallableStatement sQLServerCallableStatement = new SQLServerCallableStatement(this, string, n, n2);
        loggerExternal.exiting(this.getClassNameLogging(), "prepareCall", sQLServerCallableStatement);
        return sQLServerCallableStatement;
    }

    public void setTypeMap(Map map) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "setTypeMap", map);
        this.checkClosed();
        if (map != null && map instanceof HashMap && map.isEmpty()) {
            loggerExternal.exiting(this.getClassNameLogging(), "setTypeMap");
            return;
        }
        this.NotImplemented();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getTypeMap");
        this.checkClosed();
        HashMap hashMap = new HashMap();
        loggerExternal.exiting(this.getClassNameLogging(), "getTypeMap", hashMap);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void logon(LogonCommand logonCommand) throws SQLServerException {
        AuthenticationJNI authenticationJNI = null;
        if (this.integratedSecurity) {
            authenticationJNI = new AuthenticationJNI();
        }
        try {
            this.sendLogon(logonCommand, authenticationJNI);
            this.originalCatalog = this.sCatalog;
            this.connectionCommand(this.sqlStatementForSettings(), "Change Settings");
        }
        finally {
            if (this.integratedSecurity) {
                if (null != authenticationJNI) {
                    authenticationJNI.ReleaseClientContext();
                }
                authenticationJNI = null;
            }
        }
    }

    private void SSPIData(byte[] byArray, byte[] byArray2, int[] nArray, boolean[] blArray, AuthenticationJNI authenticationJNI) throws SQLServerException {
        int n = null == byArray ? authenticationJNI.GenerateClientContext(null, 0, byArray2, nArray, blArray) : authenticationJNI.GenerateClientContext(byArray, byArray.length, byArray2, nArray, blArray);
        if (n != 0) {
            connectionlogger.warning(this.toString() + " Authentication failed code" + n);
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_notConfiguredForIntegrated"), "08001", false);
        }
    }

    final void processEnvChange(TDSReader tDSReader) throws SQLServerException {
        tDSReader.readUnsignedByte();
        int n = tDSReader.readUnsignedShort();
        TDSReaderMark tDSReaderMark = tDSReader.mark();
        int n2 = tDSReader.readUnsignedByte();
        switch (n2) {
            case 4: {
                try {
                    this.tdsPacketSize = Integer.parseInt(tDSReader.readUnicodeString(tDSReader.readUnsignedByte()));
                }
                catch (NumberFormatException numberFormatException) {
                    tDSReader.throwInvalidTDS();
                }
                if (!connectionlogger.isLoggable(Level.FINER)) break;
                connectionlogger.finer(this.toString() + " Network packet size is " + this.tdsPacketSize + " bytes");
                break;
            }
            case 7: {
                if (SQLCollation.tdsLength() != tDSReader.readUnsignedByte()) {
                    tDSReader.throwInvalidTDS();
                }
                try {
                    this.databaseCollation = new SQLCollation(tDSReader);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    this.terminate(4, unsupportedEncodingException.getMessage(), unsupportedEncodingException);
                }
                break;
            }
            case 8: 
            case 11: {
                this.rolledBackTransaction = false;
                if (!this.isYukonOrLater()) break;
                byte[] byArray = this.getTransactionDescriptor();
                if (byArray.length != tDSReader.readUnsignedByte()) {
                    tDSReader.throwInvalidTDS();
                }
                tDSReader.readBytes(byArray, 0, byArray.length);
                if (!connectionlogger.isLoggable(Level.FINER)) break;
                String string = 8 == n2 ? " started" : " enlisted";
                connectionlogger.finer(this.toString() + string);
                break;
            }
            case 10: {
                this.rolledBackTransaction = true;
                if (this.inXATransaction) {
                    if (!connectionlogger.isLoggable(Level.FINER)) break;
                    connectionlogger.finer(this.toString() + " rolled back. (DTC)");
                    break;
                }
                if (connectionlogger.isLoggable(Level.FINER)) {
                    connectionlogger.finer(this.toString() + " rolled back");
                }
                if (!this.isYukonOrLater()) break;
                Arrays.fill(this.getTransactionDescriptor(), (byte)0);
                break;
            }
            case 9: {
                if (connectionlogger.isLoggable(Level.FINER)) {
                    connectionlogger.finer(this.toString() + " committed");
                }
                if (!this.isYukonOrLater()) break;
                Arrays.fill(this.getTransactionDescriptor(), (byte)0);
                break;
            }
            case 12: {
                if (connectionlogger.isLoggable(Level.FINER)) {
                    connectionlogger.finer(this.toString() + " defected");
                }
                if (!this.isYukonOrLater()) break;
                Arrays.fill(this.getTransactionDescriptor(), (byte)0);
                break;
            }
            case 1: {
                this.setCatalogName(tDSReader.readUnicodeString(tDSReader.readUnsignedByte()));
                break;
            }
            case 13: {
                this.setFailoverPartnerServerProvided(tDSReader.readUnicodeString(tDSReader.readUnsignedByte()));
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                if (!connectionlogger.isLoggable(Level.FINER)) break;
                connectionlogger.finer(this.toString() + " Ignored env change: " + n2);
                break;
            }
            default: {
                connectionlogger.warning(this.toString() + " Unknown environment change: " + n2);
                this.throwInvalidTDS();
            }
        }
        tDSReader.reset(tDSReaderMark);
        tDSReader.readBytes(new byte[n], 0, n);
    }

    private final void executeDTCCommand(int n, byte[] byArray, String string) throws SQLServerException {
        final class DTCCommand
        extends UninterruptableTDSCommand {
            private final int requestType;
            private final byte[] payload;

            DTCCommand(int n, byte[] byArray, String string) {
                super(string);
                this.requestType = n;
                this.payload = byArray;
            }

            @Override
            final boolean doExecute() throws SQLServerException {
                TDSWriter tDSWriter = this.startRequest((byte)14);
                tDSWriter.writeShort((short)this.requestType);
                if (null == this.payload) {
                    tDSWriter.writeShort((short)0);
                } else {
                    assert (this.payload.length <= Short.MAX_VALUE);
                    tDSWriter.writeShort((short)this.payload.length);
                    tDSWriter.writeBytes(this.payload);
                }
                TDSParser.parse(this.startResponse(), this.getLogContext());
                return true;
            }
        }
        this.executeCommand(new DTCCommand(n, byArray, string));
    }

    final void JTAUnenlistConnection() throws SQLServerException {
        this.executeDTCCommand(1, null, "MS_DTC unenlist connection");
        this.inXATransaction = false;
    }

    final void JTAEnlistConnection(byte[] byArray) throws SQLServerException {
        this.executeDTCCommand(1, byArray, "MS_DTC enlist connection");
        this.connectionCommand(this.sqlStatementToSetTransactionIsolationLevel(), "JTAEnlistConnection");
        this.inXATransaction = true;
    }

    private byte[] toUCS16(String string) throws SQLServerException {
        if (string == null) {
            return new byte[0];
        }
        int n = string.length();
        byte[] byArray = new byte[n * 2];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            byte by = (byte)(c & 0xFF);
            byArray[n2++] = by;
            byArray[n2++] = (byte)(c >> 8 & 0xFF);
        }
        return byArray;
    }

    private byte[] encryptPassword(String string) {
        if (string == null) {
            string = "";
        }
        int n = string.length();
        byte[] byArray = new byte[n * 2];
        for (int i = 0; i < n; ++i) {
            byte by;
            byte by2;
            int n2 = string.charAt(i) ^ 0x5A5A;
            n2 = (n2 & 0xF) << 4 | (n2 & 0xF0) >> 4 | (n2 & 0xF00) << 4 | (n2 & 0xF000) >> 4;
            byArray[i * 2 + 1] = by2 = (byte)((n2 & 0xFF00) >> 8);
            byArray[i * 2 + 0] = by = (byte)(n2 & 0xFF);
        }
        return byArray;
    }

    private void sendLogon(LogonCommand logonCommand, AuthenticationJNI authenticationJNI) throws SQLServerException {
        TDSReader tDSReader;
        int n;
        String string = this.activeConnectionProperties.getProperty("workstationID");
        String string2 = this.activeConnectionProperties.getProperty("user");
        String string3 = this.activeConnectionProperties.getProperty("password");
        String string4 = this.activeConnectionProperties.getProperty("applicationName");
        String string5 = this.activeConnectionProperties.getProperty("databaseName");
        if (string == null || string.length() == 0) {
            string = Util.lookupHostName();
        }
        byte[] byArray = new byte[]{};
        int[] nArray = new int[]{0};
        boolean[] blArray = new boolean[]{false};
        if (this.integratedSecurity) {
            if (authenticationJNI.IsEnabled()) {
                nArray[0] = authenticationJNI.GetMaxSSPIBlobSize();
                byArray = new byte[nArray[0]];
                authenticationJNI.InitDNSNameAndPort(this.currentConnectPlaceHolder.getServerName(), this.currentConnectPlaceHolder.getPortNumber());
                this.SSPIData(null, byArray, nArray, blArray, authenticationJNI);
                string2 = null;
                string3 = null;
            } else {
                this.terminate(0, SQLServerException.getErrString("R_notConfiguredForIntegrated"), authenticationJNI.getLinkError());
            }
        }
        byte[] byArray2 = this.toUCS16(string);
        byte[] byArray3 = this.toUCS16(string2);
        byte[] byArray4 = this.encryptPassword(string3);
        int n2 = byArray4 != null ? byArray4.length : 0;
        byte[] byArray5 = this.toUCS16(string4);
        byte[] byArray6 = this.toUCS16(string);
        byte[] byArray7 = this.toUCS16(string5);
        byte[] byArray8 = new byte[6];
        int n3 = 0;
        int n4 = 0;
        if (this.serverMajorVersion >= 10) {
            this.tdsVersion = 1929576458;
            n = 94;
        } else if (this.serverMajorVersion >= 9) {
            this.tdsVersion = 1913192450;
            n = 94;
        } else {
            assert (8 == this.serverMajorVersion);
            this.tdsVersion = 0x70100000;
            n = 86;
        }
        n3 = n2 + byArray2.length + byArray3.length + byArray5.length + byArray6.length + byArray7.length + n + nArray[0];
        TDSWriter tDSWriter = logonCommand.startRequest((byte)16);
        tDSWriter.writeInt(n3);
        tDSWriter.writeInt(this.tdsVersion);
        tDSWriter.writeInt(this.requestedPacketSize);
        tDSWriter.writeInt(0);
        tDSWriter.writeInt(0);
        tDSWriter.writeInt(0);
        tDSWriter.writeByte((byte)-32);
        tDSWriter.writeByte((byte)(3 | (this.integratedSecurity ? -128 : 0)));
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeByte((byte)(0 | (this.serverMajorVersion >= 10 ? 8 : 0)));
        tDSWriter.writeInt(0);
        tDSWriter.writeInt(0);
        tDSWriter.writeShort((short)n);
        tDSWriter.writeShort((short)(string == null ? 0 : string.length()));
        n4 += byArray2.length;
        if (!this.integratedSecurity) {
            tDSWriter.writeShort((short)(n + n4));
            tDSWriter.writeShort((short)(string2 == null ? 0 : string2.length()));
            tDSWriter.writeShort((short)(n + (n4 += byArray3.length)));
            tDSWriter.writeShort((short)(string3 == null ? 0 : string3.length()));
            n4 += n2;
        } else {
            tDSWriter.writeShort((short)0);
            tDSWriter.writeShort((short)0);
            tDSWriter.writeShort((short)0);
            tDSWriter.writeShort((short)0);
        }
        tDSWriter.writeShort((short)(n + n4));
        tDSWriter.writeShort((short)(string4 == null ? 0 : string4.length()));
        tDSWriter.writeShort((short)(n + (n4 += byArray5.length)));
        tDSWriter.writeShort((short)(string == null ? 0 : string.length()));
        n4 += byArray6.length;
        tDSWriter.writeShort((short)0);
        tDSWriter.writeShort((short)0);
        tDSWriter.writeShort((short)0);
        tDSWriter.writeShort((short)0);
        tDSWriter.writeShort((short)0);
        tDSWriter.writeShort((short)0);
        tDSWriter.writeShort((short)(n + n4));
        tDSWriter.writeShort((short)(string5 == null ? 0 : string5.length()));
        n4 += byArray7.length;
        tDSWriter.writeBytes(byArray8);
        if (!this.integratedSecurity) {
            tDSWriter.writeShort((short)0);
            tDSWriter.writeShort((short)0);
        } else {
            tDSWriter.writeShort((short)(n + n4));
            if (65535 <= nArray[0]) {
                tDSWriter.writeShort((short)-1);
            } else {
                tDSWriter.writeShort((short)nArray[0]);
            }
        }
        tDSWriter.writeShort((short)0);
        tDSWriter.writeShort((short)0);
        if (this.tdsVersion >= 1913192450) {
            tDSWriter.writeShort((short)0);
            tDSWriter.writeShort((short)0);
            if (65535 <= nArray[0]) {
                tDSWriter.writeInt(nArray[0]);
            } else {
                tDSWriter.writeInt(0);
            }
        }
        tDSWriter.writeBytes(byArray2);
        tDSWriter.setDataLoggable(false);
        if (!this.integratedSecurity) {
            tDSWriter.writeBytes(byArray3);
            tDSWriter.writeBytes(byArray4);
        }
        tDSWriter.setDataLoggable(true);
        tDSWriter.writeBytes(byArray5);
        tDSWriter.writeBytes(byArray6);
        tDSWriter.writeBytes(byArray7);
        tDSWriter.setDataLoggable(false);
        if (this.integratedSecurity) {
            tDSWriter.writeBytes(byArray, 0, nArray[0]);
        }
        tDSWriter.setDataLoggable(true);
        final class LogonProcessor
        extends TDSTokenHandler {
            private final AuthenticationJNI intAuth;
            private final byte[] secBlobOut;
            private final int[] outBlobSize;
            StreamLoginAck loginAckToken;

            LogonProcessor(AuthenticationJNI authenticationJNI) {
                super("logon");
                this.intAuth = authenticationJNI;
                this.secBlobOut = (byte[])(null != authenticationJNI ? new byte[authenticationJNI.GetMaxSSPIBlobSize()] : null);
                this.outBlobSize = new int[1];
                this.loginAckToken = null;
            }

            @Override
            boolean onSSPI(TDSReader tDSReader) throws SQLServerException {
                StreamSSPI streamSSPI = new StreamSSPI();
                streamSSPI.setFromTDS(tDSReader);
                boolean[] blArray = new boolean[]{false};
                LogonProcessor logonProcessor = this;
                this.outBlobSize[0] = logonProcessor.intAuth.GetMaxSSPIBlobSize();
                SQLServerConnection.this.SSPIData(streamSSPI.sspiBlob, this.secBlobOut, this.outBlobSize, blArray, this.intAuth);
                return true;
            }

            @Override
            boolean onLoginAck(TDSReader tDSReader) throws SQLServerException {
                this.loginAckToken = new StreamLoginAck();
                this.loginAckToken.setFromTDS(tDSReader);
                SQLServerConnection.this.sqlServerVersion = this.loginAckToken.sSQLServerVersion;
                SQLServerConnection.this.tdsVersion = this.loginAckToken.tdsVersion;
                return true;
            }

            final boolean complete(LogonCommand logonCommand, TDSReader tDSReader) throws SQLServerException {
                if (null != this.loginAckToken) {
                    return true;
                }
                if (0 != this.outBlobSize[0]) {
                    logonCommand.startRequest((byte)17).writeBytes(this.secBlobOut, 0, this.outBlobSize[0]);
                    return false;
                }
                logonCommand.startRequest((byte)17);
                logonCommand.onRequestComplete();
                ++((SQLServerConnection)SQLServerConnection.this).tdsChannel.numMsgsSent;
                TDSParser.parse(tDSReader, this);
                return true;
            }
        }
        LogonProcessor logonProcessor = new LogonProcessor(authenticationJNI);
        do {
            tDSReader = logonCommand.startResponse();
            TDSParser.parse(tDSReader, logonProcessor);
        } while (!logonProcessor.complete(logonCommand, tDSReader));
    }

    private void checkValidHoldability(int n) throws SQLServerException {
        if (n != 1 && n != 2) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidHoldability"));
            SQLServerException.makeFromDriverError(this, this, messageFormat.format(new Object[]{n}), null, true);
        }
    }

    private void checkMatchesCurrentHoldability(int n) throws SQLServerException {
        if (n != this.holdability) {
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_sqlServerHoldability"), null, false);
        }
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "createStatement", new Object[]{new Integer(n), new Integer(n2), n3});
        this.checkClosed();
        this.checkValidHoldability(n3);
        this.checkMatchesCurrentHoldability(n3);
        Statement statement = this.createStatement(n, n2);
        loggerExternal.exiting(this.getClassNameLogging(), "createStatement", statement);
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "prepareStatement", new Object[]{new Integer(n), new Integer(n2), n3});
        this.checkClosed();
        this.checkValidHoldability(n3);
        this.checkMatchesCurrentHoldability(n3);
        PreparedStatement preparedStatement = this.prepareStatement(string, n, n2);
        loggerExternal.exiting(this.getClassNameLogging(), "prepareStatement", preparedStatement);
        return preparedStatement;
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "prepareStatement", new Object[]{new Integer(n), new Integer(n2), n3});
        this.checkClosed();
        this.checkValidHoldability(n3);
        this.checkMatchesCurrentHoldability(n3);
        CallableStatement callableStatement = this.prepareCall(string, n, n2);
        loggerExternal.exiting(this.getClassNameLogging(), "prepareCall", callableStatement);
        return callableStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "prepareStatement", new Object[]{string, new Integer(n)});
        this.checkClosed();
        SQLServerPreparedStatement sQLServerPreparedStatement = (SQLServerPreparedStatement)this.prepareStatement(string);
        sQLServerPreparedStatement.bRequestedGeneratedKeys = n == 1;
        loggerExternal.exiting(this.getClassNameLogging(), "prepareStatement", sQLServerPreparedStatement);
        return sQLServerPreparedStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "prepareStatement", new Object[]{string, nArray});
        this.checkClosed();
        if (nArray == null || nArray.length != 1) {
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_invalidColumnArrayLength"), null, false);
        }
        SQLServerPreparedStatement sQLServerPreparedStatement = (SQLServerPreparedStatement)this.prepareStatement(string);
        sQLServerPreparedStatement.bRequestedGeneratedKeys = true;
        loggerExternal.exiting(this.getClassNameLogging(), "prepareStatement", sQLServerPreparedStatement);
        return sQLServerPreparedStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "prepareStatement", new Object[]{string, stringArray});
        this.checkClosed();
        if (stringArray == null || stringArray.length != 1) {
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_invalidColumnArrayLength"), null, false);
        }
        SQLServerPreparedStatement sQLServerPreparedStatement = (SQLServerPreparedStatement)this.prepareStatement(string);
        sQLServerPreparedStatement.bRequestedGeneratedKeys = true;
        loggerExternal.exiting(this.getClassNameLogging(), "prepareStatement", sQLServerPreparedStatement);
        return sQLServerPreparedStatement;
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "releaseSavepoint", savepoint);
        this.NotImplemented();
    }

    private final Savepoint setNamedSavepoint(String string) throws SQLServerException {
        if (this.databaseAutoCommitMode) {
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_cantSetSavepoint"), null, false);
        }
        SQLServerSavepoint sQLServerSavepoint = new SQLServerSavepoint(this, string);
        this.connectionCommand("IF @@TRANCOUNT = 0 BEGIN BEGIN TRAN IF @@TRANCOUNT = 2 COMMIT TRAN END SAVE TRAN " + Util.escapeSQLId(sQLServerSavepoint.getLabel()), "setSavepoint");
        return sQLServerSavepoint;
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "setSavepoint", string);
        this.checkClosed();
        Savepoint savepoint = this.setNamedSavepoint(string);
        loggerExternal.exiting(this.getClassNameLogging(), "setSavepoint", savepoint);
        return savepoint;
    }

    @Override
    public Savepoint setSavepoint() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "setSavepoint");
        this.checkClosed();
        Savepoint savepoint = this.setNamedSavepoint(null);
        loggerExternal.exiting(this.getClassNameLogging(), "setSavepoint", savepoint);
        return savepoint;
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "rollback", savepoint);
        this.checkClosed();
        if (this.databaseAutoCommitMode) {
            SQLServerException.makeFromDriverError(this, this, SQLServerException.getErrString("R_cantInvokeRollback"), null, false);
        }
        this.connectionCommand("IF @@TRANCOUNT > 0 ROLLBACK TRAN " + Util.escapeSQLId(((SQLServerSavepoint)savepoint).getLabel()), "rollbackSavepoint");
        loggerExternal.exiting(this.getClassNameLogging(), "rollback");
    }

    @Override
    public int getHoldability() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getHoldability");
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.exiting(this.getClassNameLogging(), "getHoldability", this.holdability);
        }
        return this.holdability;
    }

    @Override
    public void setHoldability(int n) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "setHoldability", n);
        this.checkValidHoldability(n);
        this.checkClosed();
        if (this.holdability != n) {
            assert (1 == n || 2 == n) : "invalid holdability " + n;
            this.connectionCommand(n == 2 ? "SET CURSOR_CLOSE_ON_COMMIT ON" : "SET CURSOR_CLOSE_ON_COMMIT OFF", "setHoldability");
            this.holdability = n;
        }
        loggerExternal.exiting(this.getClassNameLogging(), "setHoldability");
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        throw new SQLFeatureNotSupportedException(SQLServerException.getErrString("R_notSupported"));
    }

    @Override
    public Blob createBlob() throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        this.checkClosed();
        return new SQLServerBlob(this);
    }

    @Override
    public Clob createClob() throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        this.checkClosed();
        return new SQLServerClob(this);
    }

    @Override
    public NClob createNClob() throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        this.checkClosed();
        return new SQLServerNClob(this);
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        loggerExternal.entering(this.getClassNameLogging(), "createSQLXML");
        DriverJDBCVersion.checkSupportsJDBC4();
        SQLServerSQLXML sQLServerSQLXML = null;
        if (!this.isYukonOrLater()) {
            throw new SQLFeatureNotSupportedException(SQLServerException.getErrString("R_notSupported"));
        }
        sQLServerSQLXML = new SQLServerSQLXML(this);
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.exiting(this.getClassNameLogging(), "createSQLXML", sQLServerSQLXML);
        }
        return sQLServerSQLXML;
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        throw new SQLFeatureNotSupportedException(SQLServerException.getErrString("R_notSupported"));
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        loggerExternal.entering(this.getClassNameLogging(), "getClientInfo");
        this.checkClosed();
        Properties properties = new Properties();
        loggerExternal.exiting(this.getClassNameLogging(), "getClientInfo", properties);
        return properties;
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        loggerExternal.entering(this.getClassNameLogging(), "getClientInfo", string);
        this.checkClosed();
        loggerExternal.exiting(this.getClassNameLogging(), "getClientInfo", null);
        return null;
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        DriverJDBCVersion.checkSupportsJDBC4();
        loggerExternal.entering(this.getClassNameLogging(), "setClientInfo", properties);
        try {
            this.checkClosed();
        }
        catch (SQLServerException sQLServerException) {
            SQLClientInfoException sQLClientInfoException = new SQLClientInfoException();
            sQLClientInfoException.initCause(sQLServerException);
            throw sQLClientInfoException;
        }
        if (!properties.isEmpty()) {
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidProperty"));
                Object[] objectArray = new Object[]{enumeration.nextElement()};
                this.addWarning(messageFormat.format(objectArray));
            }
        }
        loggerExternal.exiting(this.getClassNameLogging(), "setClientInfo");
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        DriverJDBCVersion.checkSupportsJDBC4();
        loggerExternal.entering(this.getClassNameLogging(), "setClientInfo", new Object[]{string, string2});
        try {
            this.checkClosed();
        }
        catch (SQLServerException sQLServerException) {
            SQLClientInfoException sQLClientInfoException = new SQLClientInfoException();
            sQLClientInfoException.initCause(sQLServerException);
            throw sQLClientInfoException;
        }
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidProperty"));
        Object[] objectArray = new Object[]{string};
        this.addWarning(messageFormat.format(objectArray));
        loggerExternal.exiting(this.getClassNameLogging(), "setClientInfo");
    }

    @Override
    public boolean isValid(int n) throws SQLException {
        Object object;
        boolean bl = false;
        loggerExternal.entering(this.getClassNameLogging(), "isValid", n);
        DriverJDBCVersion.checkSupportsJDBC4();
        if (n < 0) {
            object = new MessageFormat(SQLServerException.getErrString("R_invalidQueryTimeOutValue"));
            Object[] objectArray = new Object[]{n};
            SQLServerException.makeFromDriverError(this, this, ((Format)object).format(objectArray), null, true);
        }
        if (this.isClosedInternal()) {
            return false;
        }
        try {
            object = new SQLServerStatement(this, 1003, 1007);
            if (0 != n) {
                ((SQLServerStatement)object).setQueryTimeout(n);
            }
            ((SQLServerStatement)object).executeQueryInternal("SELECT 1");
            ((SQLServerStatement)object).close();
            bl = true;
        }
        catch (SQLException sQLException) {
            connectionlogger.fine(this.toString() + " Exception checking connection validity: " + sQLException.getMessage());
        }
        loggerExternal.exiting(this.getClassNameLogging(), "isValid", bl);
        return bl;
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        loggerExternal.entering(this.getClassNameLogging(), "isWrapperFor", clazz);
        DriverJDBCVersion.checkSupportsJDBC4();
        boolean bl = clazz.isInstance(this);
        loggerExternal.exiting(this.getClassNameLogging(), "isWrapperFor", bl);
        return bl;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        T t;
        loggerExternal.entering(this.getClassNameLogging(), "unwrap", clazz);
        DriverJDBCVersion.checkSupportsJDBC4();
        try {
            t = clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            SQLException sQLException = new SQLException(classCastException.getMessage());
            sQLException.initCause(classCastException);
            throw sQLException;
        }
        loggerExternal.exiting(this.getClassNameLogging(), "unwrap", t);
        return t;
    }

    String replaceParameterMarkers(String string, Parameter[] parameterArray, boolean bl) throws SQLServerException {
        char[] cArray = new char[string.length() + parameterArray.length * (6 + OUT.length)];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            int n5 = ParameterUtils.scanSQLForChar('?', string, n2);
            string.getChars(n2, n5, cArray, n);
            n += n5 - n2;
            if (string.length() == n5) break;
            n += SQLServerConnection.makeParamName(n3++, cArray, n);
            n2 = n5 + 1;
            if (!parameterArray[n4++].isOutput() || bl && n4 <= 1) continue;
            System.arraycopy(OUT, 0, cArray, n, OUT.length);
            n += OUT.length;
        }
        while (n < cArray.length) {
            cArray[n++] = 32;
        }
        return new String(cArray);
    }

    static int makeParamName(int n, char[] cArray, int n2) {
        cArray[n2 + 0] = 64;
        cArray[n2 + 1] = 80;
        if (n < 10) {
            cArray[n2 + 2] = (char)(48 + n);
            return 3;
        }
        if (n < 100) {
            int n3 = 2;
            while (true) {
                if (n < n3 * 10) {
                    cArray[n2 + 2] = (char)(48 + (n3 - 1));
                    cArray[n2 + 3] = (char)(48 + (n - (n3 - 1) * 10));
                    return 4;
                }
                ++n3;
            }
        }
        String string = "" + n;
        string.getChars(0, string.length(), cArray, n2 + 2);
        return 2 + string.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyPooledConnection(SQLServerException sQLServerException) {
        SQLServerConnection sQLServerConnection = this;
        synchronized (sQLServerConnection) {
            if (null != this.pooledConnectionParent) {
                this.pooledConnectionParent.notifyEvent(sQLServerException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void DetachFromPool() {
        SQLServerConnection sQLServerConnection = this;
        synchronized (sQLServerConnection) {
            this.pooledConnectionParent = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getInstancePort(String string, String string2) throws SQLServerException {
        Object object;
        Object object2;
        String string3 = null;
        DatagramSocket datagramSocket = null;
        String string4 = null;
        try {
            InetAddress inetAddress = null;
            string4 = "Failed to determine instance for the : " + string + " instance:" + string2;
            if (null == inetAddress) {
                try {
                    inetAddress = InetAddress.getByName(string);
                }
                catch (UnknownHostException unknownHostException) {
                    string4 = "Unable to determine IP address of host: " + string;
                    throw unknownHostException;
                }
            }
            assert (null != inetAddress);
            if (null == datagramSocket) {
                try {
                    datagramSocket = new DatagramSocket();
                    datagramSocket.setSoTimeout(1000);
                }
                catch (SocketException socketException) {
                    string4 = "Unable to create local datagram socket";
                    throw socketException;
                }
            }
            assert (null != datagramSocket);
            try {
                object2 = (" " + string2).getBytes();
                object2[0] = 4;
                object = new DatagramPacket((byte[])object2, ((Object)object2).length, inetAddress, 1434);
                datagramSocket.send((DatagramPacket)object);
            }
            catch (IOException iOException) {
                string4 = "Error sending SQL Server Browser Service UDP request to address: " + inetAddress + ", port: " + 1434;
                throw iOException;
            }
            try {
                object2 = new byte[4096];
                object = new DatagramPacket((byte[])object2, ((Object)object2).length);
                datagramSocket.receive((DatagramPacket)object);
                string3 = new String((byte[])object2, 3, ((Object)object2).length - 3);
            }
            catch (IOException iOException) {
                string4 = "Error receiving SQL Server Browser Service UDP response from address: " + inetAddress;
                throw iOException;
            }
        }
        catch (IOException iOException) {
            object2 = new MessageFormat(SQLServerException.getErrString("R_sqlBrowserFailed"));
            object = new Object[]{string, string2, iOException.toString()};
            connectionlogger.log(Level.FINE, this.toString() + " " + string4, iOException);
            SQLServerException.makeFromDriverError(this, this, ((Format)object2).format(object), "08001", false);
        }
        finally {
            if (null != datagramSocket) {
                datagramSocket.close();
            }
        }
        assert (null != string3);
        int n = string3.indexOf("tcp;");
        if (-1 == n) {
            object2 = new MessageFormat(SQLServerException.getErrString("R_notConfiguredToListentcpip"));
            object = new Object[]{string2};
            SQLServerException.makeFromDriverError(this, this, ((Format)object2).format(object), "08001", false);
        }
        int n2 = n + 4;
        int n3 = string3.indexOf(59, n2);
        return string3.substring(n2, n3);
    }

    int getNextSavepointId() {
        ++this.nNextSavePointId;
        return this.nNextSavePointId;
    }

    void doSecurityCheck() {
        assert (null != this.currentConnectPlaceHolder);
        this.currentConnectPlaceHolder.doSecurityCheck();
    }

    private final class LogonCommand
    extends UninterruptableTDSCommand {
        LogonCommand() {
            super("logon");
        }

        @Override
        final boolean doExecute() throws SQLServerException {
            SQLServerConnection.this.logon(this);
            return true;
        }
    }
}

