# Development Package Repositories

This page will tell you everything about the development package repositories 
for eduVPN / Let's Connect!.

This page will always reflect the most up to date configuration and keys that
are required for using the packages.

## Repository Key

Owner   | Fingerprint                                          | Expires
------- | ---------------------------------------------------- | ----------
fkooman | `6BA2 95A4 A057 32F6 68A7  55CB ADF0 EADD BAD8 2F3C` | 2026-01-18

### PGP Key

[Download](https://repo.tuxed.net/fkooman+repo@tuxed.net.asc)

```
-----BEGIN PGP PUBLIC KEY BLOCK-----
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=2+CI
-----END PGP PUBLIC KEY BLOCK-----
```

## Debian / Ubuntu

### Repository Key

```bash
$ curl -s https://repo.tuxed.net/eduVPN/v3-dev/deb/fkooman+repo@tuxed.net.gpg | sudo tee /usr/share/keyrings/fkooman+repo@tuxed.net.gpg >/dev/null
```

### Repository Config

```bash
$ echo "deb [arch=$(dpkg --print-architecture) signed-by=/usr/share/keyrings/fkooman+repo@tuxed.net.gpg] https://repo.tuxed.net/eduVPN/v3-dev/deb $(lsb_release -cs) main" | sudo tee /etc/apt/sources.list.d/eduVPN_v3-dev.list >/dev/null
```

## Fedora

### Repository Key

```bash
$ curl -O https://repo.tuxed.net/fkooman+repo@tuxed.net.asc
$ sudo rpm --import fkooman+repo@tuxed.net.asc
```

### Repository Config

Add the following to the file `/etc/yum.repos.d/eduVPN_v3-dev.repo`:

```
[eduVPN_v3-dev]
name=eduVPN 3.x Development Packages (Fedora $releasever)
baseurl=https://repo.tuxed.net/eduVPN/v3-dev/rpm/fedora-$releasever-$basearch
gpgcheck=1
enabled=1
```

## AlmaLinux

### Repository Key

```bash
$ curl -O https://repo.tuxed.net/fkooman+repo@tuxed.net.asc
$ sudo rpm --import fkooman+repo@tuxed.net.asc
```

### Repository Config

Add the following to the file `/etc/yum.repos.d/eduVPN_v3-dev.repo`:

```
[eduVPN_v3-dev]
name=eduVPN 3.x Development Packages (EL 9)
baseurl=https://repo.tuxed.net/eduVPN/v3-dev/rpm/alma+epel-9-$basearch
gpgcheck=1
enabled=1
```

## Rocky Linux

### Repository Key

```bash
$ curl -O https://repo.tuxed.net/fkooman+repo@tuxed.net.asc
$ sudo rpm --import fkooman+repo@tuxed.net.asc
```

### Repository Config

Add the following to the file `/etc/yum.repos.d/eduVPN_v3-dev.repo`:

```
[eduVPN_v3-dev]
name=eduVPN 3.x Development Packages (EL 9)
baseurl=https://repo.tuxed.net/eduVPN/v3-dev/rpm/rocky+epel-9-$basearch
gpgcheck=1
enabled=1
```

## CentOS Stream

```bash
$ curl -O https://repo.tuxed.net/fkooman+repo@tuxed.net.asc
$ sudo rpm --import fkooman+repo@tuxed.net.asc
```

### Repository Config

Add the following to the file `/etc/yum.repos.d/eduVPN_v3-dev.repo`:

```
[eduVPN_v3-dev]
name=eduVPN 3.x Development Packages (EL 9)
baseurl=https://repo.tuxed.net/eduVPN/v3-dev/rpm/centos-stream+epel-next-9-$basearch
gpgcheck=1
enabled=1
```
