/* Copyright (c) 2011, Peter A. Bigot
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in
 *   the documentation and/or other materials provided with the
 *   distribution.
 * - Neither the name of the copyright holder nor the names of its
 *   contributors may be used to endorse or promote products derived
 *   from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef	__SYS_CRTLD_H__
#define	__SYS_CRTLD_H__

/* Linker defined constants, generated by the msp430 target of GNU binutils.
 *
 * These symbols are mostly constant addresses. They are never
 * variables, and users should not be taking their addresses.  Where
 * the symbol is used as a value rather than an address, we explicitly
 * cast the address to the appropriate type; see __data_size and
 * __bss_size. */

extern unsigned int _etext[];

extern unsigned int __data_start[];
extern unsigned int _edata[];
extern unsigned int __data_size;
#define __data_size ((unsigned int)&__data_size)

extern unsigned int __bss_start[];
extern unsigned int __bss_end[];
extern unsigned int __bss_size[];
#define __bss_size ((unsigned int)&__bss_size)

extern unsigned int __noinit_start[];
extern unsigned int __noinit_end[];

extern unsigned int __stack[];
extern unsigned int __data_start_rom[];
extern unsigned int __data_end_rom[];

extern unsigned int __info_segment_size;
#define __info_segment_size ((unsigned int)&__info_segment_size)
extern unsigned char __infoa[];
extern unsigned char __infob[];
extern unsigned char __infoc[];
extern unsigned char __infod[];

/* init routines from libgcc */
void __attribute__ ((__noreturn__)) _reset_vector__ (void);

#endif /* __SYS_CRTLD_H__ */
