# -*- coding: utf-8 -*- #
# Copyright 2018 Google LLC. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Supplementary help for setting up gcloud offline help."""

from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals

from googlecloudsdk.calliope import base


class OfflineHelp(base.TopicCommand):
  """Setting up gcloud command offline help.

  There are many ways to access `gcloud` command help. Only the first requires
  online access:

    * Browse https://cloud.google.com/sdk/gcloud/reference/ for the most
      recent Google Cloud CLI release online documents.

    * Add the *--help* flag to any command. This will render a man style
      document in a terminal pager. The document is always up to date with the
      command because it is generated by collating help text from the command
      itself.

    * Use the `gcloud beta interactive` shell which has as-you-type help. Like
      *--help*, the interactive help documents are always up to date with the
      `gcloud` installation.

    * Generate HTML documents in a local directory and point your browser to
      the generated *index.html* for offline browsing. Hover over a navigation
      item to focus the menu, hover to the left to expand it again. More
      details on this below.

    * Generate and install *man*(1) style documents on a local host. More
      details on this below.

  All of these methods have the same content, all generated from a Google Cloud
  CLI `gcloud` installation. The last two are user maintained and can become out
  of date. Either use them for one time offline access, or make them part of
  your Google Cloud CLI installation/update routine.

  ### Generating offline HTML documents

  To generate HTML documents for offline browsing:

      # Select an empty directory where the HTML and supporting *.css* and
      # *.js* files will be generated.
      HTML_DIR=<some-local-directory>

      # Generate the HTML in $HTML_DIR.
      # Should take ~1 min, 10 min or more on slower systems.
      gcloud meta generate-help-docs --html-dir=$HTML_DIR

  Then enter this URL in the browser address/search bar, where $HTML_DIR
  must be the actual path name of the directory:

      file://$HTML_DIR/index.html

  ### Generating offline manpage documents

  To generate man page documents for the *man*(1) command:

      # Select an empty directory where the man page files will be generated.
      MANPAGE_DIR=<some-local-directory>

      # Generate the man pages in $MANPAGE_DIR.
      # Should take ~1 min, 10 min or more on slower systems.
      gcloud meta generate-help-docs --manpage-dir=$MANPAGE_DIR

      # Append $MANPAGE_DIR to the MANPATH environment variable:
      export MANPATH=$MANPATH:$MANPAGE_dir

  Then run the man command on gcloud manpages:

      man gcloud info
  """
