info = {
    "name": "uk",
    "date_order": "DMY",
    "january": [
        "січ",
        "січень",
        "січня"
    ],
    "february": [
        "лют",
        "лютий",
        "лютого"
    ],
    "march": [
        "бер",
        "березень",
        "березня",
        "берез"
    ],
    "april": [
        "кві",
        "квіт",
        "квітень",
        "квітня"
    ],
    "may": [
        "тра",
        "трав",
        "травень",
        "травня"
    ],
    "june": [
        "чер",
        "черв",
        "червень",
        "червня"
    ],
    "july": [
        "лип",
        "липень",
        "липня"
    ],
    "august": [
        "сер",
        "серп",
        "серпень",
        "серпня"
    ],
    "september": [
        "вер",
        "вересень",
        "вересня",
        "верес"
    ],
    "october": [
        "жов",
        "жовт",
        "жовтень",
        "жовтня"
    ],
    "november": [
        "лис",
        "лист",
        "листопад",
        "листопада",
        "листоп"
    ],
    "december": [
        "гру",
        "груд",
        "грудень",
        "грудня"
    ],
    "monday": [
        "пн",
        "понеділок",
        "пн",
        "пон",
        "понед",
        "понеділок"
    ],
    "tuesday": [
        "вт",
        "вівторок",
        "вт",
        "вів",
        "вівтор",
        "вівторок"
    ],
    "wednesday": [
        "середа",
        "ср",
        "ср",
        "сер",
        "серед",
        "середа",
        "середу"
    ],
    "thursday": [
        "четвер",
        "чт",
        "чт",
        "чет",
        "четвер"
    ],
    "friday": [
        "п'ятниця",
        "пт",
        "пят"
    ],
    "saturday": [
        "сб",
        "субота",
        "сб",
        "суб",
        "субот",
        "субота",
        "суботу"
    ],
    "sunday": [
        "нд",
        "неділя",
        "нд",
        "нед",
        "неділ",
        "неділя",
        "неділю"
    ],
    "am": [
        "дп",
        "до полудня"
    ],
    "pm": [
        "пп",
        "після полудня",
        "пополудні",
        "пополудні"
    ],
    "year": [
        "р",
        "рік",
        "р",
        "рік",
        "роки",
        "років",
        "року",
        "роком",
        "році",
        "роках",
        "роками",
        "рокові"
    ],
    "month": [
        "міс",
        "місяць",
        "м",
        "міс",
        "місяць",
        "місяці",
        "місяців",
        "місяця",
        "місяцю",
        "місяцям",
        "місяцем",
        "місяцеві",
        "місяцях",
        "місяцями"
    ],
    "week": [
        "тиж",
        "тиждень",
        "т",
        "тиждень",
        "тижня",
        "тижні",
        "тижнів",
        "тижнем",
        "тижневі",
        "тижню"
    ],
    "day": [
        "д",
        "день",
        "д",
        "дн",
        "день",
        "дня",
        "дні",
        "днів",
        "доба",
        "доби",
        "діб",
        "дневі",
        "дню",
        "днем"
    ],
    "hour": [
        "год",
        "година",
        "г",
        "год",
        "годин",
        "година",
        "години",
        "годин",
        "годину",
        "г",
        "годині",
        "годиною",
        "годино"
    ],
    "minute": [
        "хв",
        "хвилина",
        "хв",
        "хвилини",
        "хвилин",
        "хвилину",
        "хвилина",
        "хвилині",
        "хвилиною",
        "хвилино"
    ],
    "second": [
        "с",
        "секунда",
        "с",
        "секунда",
        "секунди",
        "секунд",
        "секунду",
        "сек",
        "секунді",
        "секундою",
        "секундо"
    ],
    "relative-type": {
        "0 day ago": [
            "сьогодні"
        ],
        "0 hour ago": [
            "цієї години"
        ],
        "0 minute ago": [
            "цієї хвилини"
        ],
        "0 month ago": [
            "цього місяця"
        ],
        "0 second ago": [
            "зараз"
        ],
        "0 week ago": [
            "цього тижня"
        ],
        "0 year ago": [
            "цього року"
        ],
        "1 day ago": [
            "учора",
            "вчора"
        ],
        "1 month ago": [
            "минулого місяця"
        ],
        "1 week ago": [
            "минулого тижня"
        ],
        "1 year ago": [
            "торік"
        ],
        "in 1 day": [
            "завтра"
        ],
        "in 1 month": [
            "наступного місяця"
        ],
        "in 1 week": [
            "наступного тижня"
        ],
        "in 1 year": [
            "наступного року"
        ],
        "2 day ago": [
            "позавчора"
        ],
        "in 2 day": [
            "післязавтра"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "(\\d+[.,]?\\d*) д тому",
            "(\\d+[.,]?\\d*) день тому",
            "(\\d+[.,]?\\d*) дн тому",
            "(\\d+[.,]?\\d*) дня тому"
        ],
        "\\1 hour ago": [
            "(\\d+[.,]?\\d*) год тому",
            "(\\d+[.,]?\\d*) години тому",
            "(\\d+[.,]?\\d*) годину тому",
            "(\\d+[.,]?\\d*) година тому"
        ],
        "\\1 minute ago": [
            "(\\d+[.,]?\\d*) хв тому",
            "(\\d+[.,]?\\d*) хвилини тому",
            "(\\d+[.,]?\\d*) хвилину тому",
            "(\\d+[.,]?\\d*) хвилина тому"
        ],
        "\\1 month ago": [
            "(\\d+[.,]?\\d*) міс тому",
            "(\\d+[.,]?\\d*) місяць тому",
            "(\\d+[.,]?\\d*) місяця тому"
        ],
        "\\1 second ago": [
            "(\\d+[.,]?\\d*) с тому",
            "(\\d+[.,]?\\d*) секунди тому",
            "(\\d+[.,]?\\d*) секунду тому",
            "(\\d+[.,]?\\d*) секунда тому"
        ],
        "\\1 week ago": [
            "(\\d+[.,]?\\d*) тиж тому",
            "(\\d+[.,]?\\d*) тиждень тому",
            "(\\d+[.,]?\\d*) тижня тому"
        ],
        "\\1 year ago": [
            "(\\d+[.,]?\\d*) р тому",
            "(\\d+[.,]?\\d*) року тому",
            "(\\d+[.,]?\\d*) рік тому"
        ],
        "in \\1 day": [
            "за (\\d+[.,]?\\d*) д",
            "через (\\d+[.,]?\\d*) день",
            "через (\\d+[.,]?\\d*) дн",
            "через (\\d+[.,]?\\d*) дня"
        ],
        "in \\1 hour": [
            "за (\\d+[.,]?\\d*) год",
            "через (\\d+[.,]?\\d*) год",
            "через (\\d+[.,]?\\d*) години",
            "через (\\d+[.,]?\\d*) годину"
        ],
        "in \\1 minute": [
            "за (\\d+[.,]?\\d*) хв",
            "через (\\d+[.,]?\\d*) хв",
            "через (\\d+[.,]?\\d*) хвилини",
            "через (\\d+[.,]?\\d*) хвилину"
        ],
        "in \\1 month": [
            "за (\\d+[.,]?\\d*) міс",
            "через (\\d+[.,]?\\d*) міс",
            "через (\\d+[.,]?\\d*) місяць",
            "через (\\d+[.,]?\\d*) місяця"
        ],
        "in \\1 second": [
            "за (\\d+[.,]?\\d*) с",
            "через (\\d+[.,]?\\d*) с",
            "через (\\d+[.,]?\\d*) секунди",
            "через (\\d+[.,]?\\d*) секунду"
        ],
        "in \\1 week": [
            "за (\\d+[.,]?\\d*) тиж",
            "через (\\d+[.,]?\\d*) тиж",
            "через (\\d+[.,]?\\d*) тиждень",
            "через (\\d+[.,]?\\d*) тижня"
        ],
        "in \\1 year": [
            "за (\\d+[.,]?\\d*) р",
            "через (\\d+[.,]?\\d*) р",
            "через (\\d+[.,]?\\d*) року",
            "через (\\d+[.,]?\\d*) рік"
        ]
    },
    "locale_specific": {},
    "skip": [
        "приблизно",
        "близько",
        "о",
        "об",
        "і",
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ],
    "sentence_splitter_group": 1,
    "ago": [
        "тому",
        "назад"
    ],
    "in": [
        "протягом",
        "через",
        "за"
    ],
    "simplifications": [
        {
            "од(на|ну|ні|ної|нієї|ин|ній)": "1"
        },
        {
            "дв(а|і|оє|ох)": "2"
        },
        {
            "пар[ауі]": "2"
        },
        {
            "три": "3"
        },
        {
            "чотири": "4"
        },
        {
            "п'ять": "5"
        },
        {
            "шість": "6"
        },
        {
            "сім": "7"
        },
        {
            "вісім": "8"
        },
        {
            "дев'ять": "9"
        },
        {
            "десять": "10"
        },
        {
            "одинадцять": "11"
        },
        {
            "дванадцять": "12"
        },
        {
            "п'ятнадцять": "15"
        },
        {
            "двадцять": "20"
        },
        {
            "тридцять": "30"
        },
        {
            "сорок": "40"
        },
        {
            "п'ятдесят": "50"
        },
        {
            "півгодини": "30 хвилин"
        },
        {
            "пів години": "30 хвилин"
        },
        {
            "півроку": "6 місяців"
        },
        {
            "пів року": "6 місяців"
        },
        {
            "півтори години": "90 хвилин"
        },
        {
            "півтора року": "18 місяців"
        },
        {
            "^година": "1 година"
        },
        {
            "^годину": "1 годину"
        },
        {
            "^хвилину": "1 хвилину"
        },
        {
            "^секунду": "1 секунду"
        },
        {
            "кілька секунд": "44 секунди"
        },
        {
            "кілька хвилин": "2 хвилини"
        },
        {
            "опів на": "30 хвилин"
        },
        {
            "за чверть": "15 хвилин"
        }
    ]
}
