/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.traccar.BaseProtocolEncoder;
import org.traccar.Protocol;
import org.traccar.model.Command;

public class CellocatorProtocolEncoder
extends BaseProtocolEncoder {
    public CellocatorProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    public static ByteBuf encodeContent(int type, int uniqueId, int packetNumber, ByteBuf content) {
        ByteBuf buf = Unpooled.buffer();
        buf.writeByte(77);
        buf.writeByte(67);
        buf.writeByte(71);
        buf.writeByte(80);
        buf.writeByte(type);
        buf.writeIntLE(uniqueId);
        buf.writeByte(packetNumber);
        buf.writeIntLE(0);
        buf.writeBytes(content);
        int checksum = 0;
        for (int i = 4; i < buf.writerIndex(); ++i) {
            checksum = (byte)(checksum + buf.getByte(i));
        }
        buf.writeByte(checksum);
        return buf;
    }

    private ByteBuf encodeCommand(long deviceId, int command, int data1, int data2) {
        ByteBuf content = Unpooled.buffer();
        content.writeByte(command);
        content.writeByte(command);
        content.writeByte(data1);
        content.writeByte(data1);
        content.writeByte(data2);
        content.writeByte(data2);
        content.writeIntLE(0);
        ByteBuf buf = CellocatorProtocolEncoder.encodeContent(0, Integer.parseInt(this.getUniqueId(deviceId)), 0, content);
        content.release();
        return buf;
    }

    @Override
    protected Object encodeCommand(Command command) {
        if (command.getType().equals("outputControl")) {
            int data = Integer.parseInt(command.getString("data")) << 4 + command.getInteger("index");
            return this.encodeCommand(command.getDeviceId(), 3, data, 0);
        }
        return null;
    }
}

