/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf) / -1.3333333333333333lf) => dvec3(1.0lf, 0.6375000000000001lf, 0.705lf)
 * (dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf) / 0.85lf) => dvec3(-1.5686274509803921lf, -1.0lf, -1.1058823529411765lf)
 * (dvec3(1.67lf, 0.66lf, 1.87lf) / -1.3333333333333333lf) => dvec3(-1.2525lf, -0.49500000000000005lf, -1.4025lf)
 * (dvec3(1.67lf, 0.66lf, 1.87lf) / 0.85lf) => dvec3(1.964705882352941lf, 0.7764705882352941lf, 2.2lf)
 */
#version 400

void main()
{
  double[distance((dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf) / -1.3333333333333333lf), dvec3(1.0lf, 0.6375000000000001lf, 0.705lf)) <= 1.3796489589747097e-05lf ? 1 : -1] array0;
  double[distance((dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf) / 0.85lf), dvec3(-1.5686274509803921lf, -1.0lf, -1.1058823529411765lf)) <= 2.1641552297642504e-05lf ? 1 : -1] array1;
  double[distance((dvec3(1.67lf, 0.66lf, 1.87lf) / -1.3333333333333333lf), dvec3(-1.2525lf, -0.49500000000000005lf, -1.4025lf)) <= 1.9444247221222015e-05lf ? 1 : -1] array2;
  double[distance((dvec3(1.67lf, 0.66lf, 1.87lf) / 0.85lf), dvec3(1.964705882352941lf, 0.7764705882352941lf, 2.2lf)) <= 3.0500779954858063e-05lf ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
