/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * lessThan(dvec3(-1.5lf, -1.5lf, -1.5lf), dvec3(-1.5lf, -0.5lf, 0.5lf)) => bvec3(false, true, true)
 * lessThan(dvec3(-1.5lf, -0.5lf, -0.5lf), dvec3(1.5lf, -1.5lf, -0.5lf)) => bvec3(true, false, false)
 * lessThan(dvec3(-0.5lf, -0.5lf, 0.5lf), dvec3(0.5lf, 1.5lf, -1.5lf)) => bvec3(true, true, false)
 * lessThan(dvec3(0.5lf, 0.5lf, 0.5lf), dvec3(-0.5lf, 0.5lf, 1.5lf)) => bvec3(false, false, true)
 * lessThan(dvec3(1.5lf, 1.5lf, 1.5lf), dvec3(-1.5lf, -0.5lf, 0.5lf)) => bvec3(false, false, false)
 * lessThan(dvec3(1.5lf, -1.5lf, -1.5lf), dvec3(1.5lf, -1.5lf, -0.5lf)) => bvec3(false, false, true)
 */
#version 400

void main()
{
  double[all(equal(lessThan(dvec3(-1.5lf, -1.5lf, -1.5lf), dvec3(-1.5lf, -0.5lf, 0.5lf)), bvec3(false, true, true))) ? 1 : -1] array0;
  double[all(equal(lessThan(dvec3(-1.5lf, -0.5lf, -0.5lf), dvec3(1.5lf, -1.5lf, -0.5lf)), bvec3(true, false, false))) ? 1 : -1] array1;
  double[all(equal(lessThan(dvec3(-0.5lf, -0.5lf, 0.5lf), dvec3(0.5lf, 1.5lf, -1.5lf)), bvec3(true, true, false))) ? 1 : -1] array2;
  double[all(equal(lessThan(dvec3(0.5lf, 0.5lf, 0.5lf), dvec3(-0.5lf, 0.5lf, 1.5lf)), bvec3(false, false, true))) ? 1 : -1] array3;
  double[all(equal(lessThan(dvec3(1.5lf, 1.5lf, 1.5lf), dvec3(-1.5lf, -0.5lf, 0.5lf)), bvec3(false, false, false))) ? 1 : -1] array4;
  double[all(equal(lessThan(dvec3(1.5lf, -1.5lf, -1.5lf), dvec3(1.5lf, -1.5lf, -0.5lf)), bvec3(false, false, true))) ? 1 : -1] array5;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
