/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * notEqual(vec3(-1.5, -1.5, -1.5), vec3(-1.5, -0.5, 0.5)) => bvec3(false, true, true)
 * notEqual(vec3(-1.5, -0.5, -0.5), vec3(1.5, -1.5, -0.5)) => bvec3(true, true, false)
 * notEqual(vec3(-0.5, -0.5, 0.5), vec3(0.5, 1.5, -1.5)) => bvec3(true, true, true)
 * notEqual(vec3(0.5, 0.5, 0.5), vec3(-0.5, 0.5, 1.5)) => bvec3(true, false, true)
 * notEqual(vec3(1.5, 1.5, 1.5), vec3(-1.5, -0.5, 0.5)) => bvec3(true, true, true)
 * notEqual(vec3(1.5, -1.5, -1.5), vec3(1.5, -1.5, -0.5)) => bvec3(false, false, true)
 */
#version 150

void main()
{
  float[all(equal(notEqual(vec3(-1.5, -1.5, -1.5), vec3(-1.5, -0.5, 0.5)), bvec3(false, true, true))) ? 1 : -1] array0;
  float[all(equal(notEqual(vec3(-1.5, -0.5, -0.5), vec3(1.5, -1.5, -0.5)), bvec3(true, true, false))) ? 1 : -1] array1;
  float[all(equal(notEqual(vec3(-0.5, -0.5, 0.5), vec3(0.5, 1.5, -1.5)), bvec3(true, true, true))) ? 1 : -1] array2;
  float[all(equal(notEqual(vec3(0.5, 0.5, 0.5), vec3(-0.5, 0.5, 1.5)), bvec3(true, false, true))) ? 1 : -1] array3;
  float[all(equal(notEqual(vec3(1.5, 1.5, 1.5), vec3(-1.5, -0.5, 0.5)), bvec3(true, true, true))) ? 1 : -1] array4;
  float[all(equal(notEqual(vec3(1.5, -1.5, -1.5), vec3(1.5, -1.5, -0.5)), bvec3(false, false, true))) ? 1 : -1] array5;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
